/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.util.Assert;

public class SpecifiedCacheSupportingCacheManager
implements CacheManager,
InitializingBean {
    private JCacheCacheManager delegateCacheManager;
    private NoOpCacheManager noOpCacheManager;
    private final Set<String> supportedCacheNames = new LinkedHashSet(16);

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegateCacheManager, (String)"cacheManager cannot be null");
        Assert.notNull((Object)this.noOpCacheManager, (String)"delegate cannot be null");
        Assert.notEmpty((Collection)this.supportedCacheNames, (String)"supportedCacheNames must not be empty");
        this.delegateCacheManager.afterPropertiesSet();
    }

    public Cache getCache(String name) {
        if (this.supportedCacheNames.contains(name)) {
            Cache cache = this.delegateCacheManager.getCache(name);
            if (cache != null) {
                return cache;
            }
            return this.noOpCacheManager.getCache(name);
        }
        return this.noOpCacheManager.getCache(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCacheNames() {
        Set set = this.supportedCacheNames;
        synchronized (set) {
            return Collections.unmodifiableSet(this.supportedCacheNames);
        }
    }

    public void setDelegateCacheManager(JCacheCacheManager delegateCacheManager) {
        this.delegateCacheManager = delegateCacheManager;
    }

    public void setNoOpCacheManager(NoOpCacheManager noOpCacheManager) {
        this.noOpCacheManager = noOpCacheManager;
    }

    public void setSupportedCaches(String ... cacheNames) {
        this.supportedCacheNames.addAll(Arrays.asList(cacheNames));
    }

    @Generated
    public SpecifiedCacheSupportingCacheManager() {
    }
}

