/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.service;

import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailBusinessRulesData;
import org.apache.fineract.infrastructure.campaigns.email.data.EmailCampaignData;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignStatus;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignType;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailBusinessRuleNotFound;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailCampaignNotFound;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignReadPlatformService;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailCampaignReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class EmailCampaignReadPlatformServiceImpl
implements EmailCampaignReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final BusinessRuleMapper businessRuleMapper;
    private final EmailCampaignMapper emailCampaignMapper;

    @Autowired
    public EmailCampaignReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.businessRuleMapper = new BusinessRuleMapper();
        this.emailCampaignMapper = new EmailCampaignMapper();
    }

    public Collection<EmailBusinessRulesData> retrieveAll() {
        String searchType = "Email";
        String sql = "select " + this.businessRuleMapper.schema() + " where sr.report_type = ?";
        return (Collection)this.jdbcTemplate.query(sql, (ResultSetExtractor)this.businessRuleMapper, new Object[]{"Email"});
    }

    public EmailBusinessRulesData retrieveOneTemplate(Long resourceId) {
        String searchType = "Email";
        String sql = "select " + this.businessRuleMapper.schema() + " where sr.report_type = ? and sr.id = ?";
        List retrieveOne = (List)this.jdbcTemplate.query(sql, (ResultSetExtractor)this.businessRuleMapper, new Object[]{"Email", resourceId});
        try {
            EmailBusinessRulesData emailBusinessRulesData = (EmailBusinessRulesData)retrieveOne.get(0);
            return emailBusinessRulesData;
        }
        catch (IndexOutOfBoundsException e) {
            throw new EmailBusinessRuleNotFound(resourceId, e);
        }
    }

    public EmailCampaignData retrieveOne(Long resourceId) {
        boolean isVisible = true;
        try {
            String sql = "select " + this.emailCampaignMapper.schema + " where ec.id = ? and ec.is_visible = ?";
            return (EmailCampaignData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.emailCampaignMapper, new Object[]{resourceId, true});
        }
        catch (EmptyResultDataAccessException e) {
            throw new EmailCampaignNotFound(resourceId, e);
        }
    }

    public Collection<EmailCampaignData> retrieveAllCampaign() {
        boolean visible = true;
        String sql = "select " + this.emailCampaignMapper.schema() + " where ec.is_visible = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)this.emailCampaignMapper, new Object[]{true});
    }

    public Collection<EmailCampaignData> retrieveAllScheduleActiveCampaign() {
        Integer scheduleCampaignType = EmailCampaignType.SCHEDULE.getValue();
        Integer statusEnum = EmailCampaignStatus.ACTIVE.getValue();
        boolean visible = true;
        String sql = "select " + this.emailCampaignMapper.schema() + " where ec.status_enum = ? and ec.campaign_type = ? and ec.is_visible = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)this.emailCampaignMapper, new Object[]{statusEnum, scheduleCampaignType, true});
    }
}

