/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.users;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.PersonnelSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.RoleSheetPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class UserWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final PersonnelSheetPopulator personnelSheetPopulator;
    private final RoleSheetPopulator roleSheetPopulator;

    public UserWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, PersonnelSheetPopulator personnelSheetPopulator, RoleSheetPopulator roleSheetPopulator) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.personnelSheetPopulator = personnelSheetPopulator;
        this.roleSheetPopulator = roleSheetPopulator;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet usersheet = workbook.createSheet("Users");
        this.personnelSheetPopulator.populate(workbook, dateFormat);
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.roleSheetPopulator.populate(workbook, dateFormat);
        this.setLayout(usersheet);
        this.setRules(usersheet);
    }

    private void setRules(Sheet usersheet) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList staffNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList autoGenPwRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 6, 6);
        CellRangeAddressList overridePwExpiryPolicyRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)usersheet);
        List offices = this.officeSheetPopulator.getOffices();
        this.setNames(usersheet, offices);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint staffNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Staff_\",$A1))");
        DataValidationConstraint booleanConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation staffValidation = validationHelper.createValidation(staffNameConstraint, staffNameRange);
        DataValidation autoGenPwValidation = validationHelper.createValidation(booleanConstraint, autoGenPwRange);
        DataValidation overridePwExpiryPolicyValidation = validationHelper.createValidation(booleanConstraint, overridePwExpiryPolicyRange);
        usersheet.addValidationData(officeValidation);
        usersheet.addValidationData(staffValidation);
        usersheet.addValidationData(autoGenPwValidation);
        usersheet.addValidationData(overridePwExpiryPolicyValidation);
    }

    private void setNames(Sheet usersheet, List<OfficeData> offices) {
        Workbook userWorkbook = usersheet.getWorkbook();
        Name officeUser = userWorkbook.createName();
        officeUser.setNameName("Office");
        officeUser.setRefersToFormula("Offices!$B$2:$B$" + (offices.size() + 1));
        Integer i = 0;
        while (i < offices.size()) {
            Integer[] officeNameToBeginEndIndexesOfStaff = (Integer[])this.personnelSheetPopulator.getOfficeNameToBeginEndIndexesOfStaff().get(i);
            Name userOfficeName = userWorkbook.createName();
            if (officeNameToBeginEndIndexesOfStaff != null) {
                this.setSanitized(userOfficeName, "Staff_" + offices.get(i).getName());
                userOfficeName.setRefersToFormula("Staff!$B$" + officeNameToBeginEndIndexesOfStaff[0] + ":$B$" + officeNameToBeginEndIndexesOfStaff[1]);
            }
            Integer n = i;
            i = i + 1;
        }
    }

    private void setLayout(Sheet usersheet) {
        Row rowHeader = usersheet.createRow(0);
        rowHeader.setHeight((short)500);
        usersheet.setColumnWidth(0, 6000);
        usersheet.setColumnWidth(1, 6000);
        usersheet.setColumnWidth(2, 6000);
        usersheet.setColumnWidth(3, 6000);
        usersheet.setColumnWidth(4, 6000);
        usersheet.setColumnWidth(5, 6000);
        usersheet.setColumnWidth(6, 6000);
        usersheet.setColumnWidth(7, 6000);
        usersheet.setColumnWidth(8, 6000);
        usersheet.setColumnWidth(9, 6000);
        this.writeString(0, rowHeader, "Office Name *");
        this.writeString(1, rowHeader, "Staff Name");
        this.writeString(2, rowHeader, "User name");
        this.writeString(3, rowHeader, "First name *");
        this.writeString(4, rowHeader, "Last name *");
        this.writeString(5, rowHeader, "Email *");
        this.writeString(6, rowHeader, "Auto Gen. Password");
        this.writeString(7, rowHeader, "Override pw expiry policy");
        this.writeString(9, rowHeader, "Role Name *(Enter in consecutive cells horizontally)");
    }
}

