/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.util;

import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class CallFailedRuntimeException
extends RuntimeException {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallFailedRuntimeException.class);
    private final Call<?> call;
    private final Response<?> response;

    public <T> CallFailedRuntimeException(Call<T> call, Throwable t) {
        super("HTTP failed: " + call.request().toString(), t);
        this.call = call;
        this.response = null;
    }

    public <T> CallFailedRuntimeException(Call<T> call, Response<T> response) {
        super(CallFailedRuntimeException.message(call, response));
        this.call = call;
        this.response = response;
    }

    private static String message(Call<?> call, Response<?> response) {
        StringBuilder sb = new StringBuilder("HTTP failed: " + call.request() + "; " + response);
        if (null != response.message() && !response.message().isEmpty()) {
            sb.append("; message: ").append(response.message());
        }
        try {
            String errorBody;
            String string = errorBody = response.errorBody() != null ? response.errorBody().string() : null;
            if (errorBody != null) {
                sb.append("; errorBody: ").append(errorBody);
            }
        }
        catch (IOException e) {
            log.error("Exception during creating the {} message:", (Object)CallFailedRuntimeException.class.getSimpleName(), (Object)e);
        }
        return sb.toString();
    }

    public <T> Call<T> getCall() {
        return this.call;
    }

    public <T> Response<T> getResponse() {
        return this.response;
    }
}

