/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi;

import java.util.Set;
import javax.naming.Name;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.store.jndi.SearchStrategy;
import org.apache.directory.server.dns.store.jndi.operations.GetRecords;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBaseSearch
implements SearchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SingleBaseSearch.class);
    private final DirContext ctx;

    SingleBaseSearch(String searchBaseDn, DirectoryService directoryService) {
        try {
            CoreSession session = directoryService.getSession();
            this.ctx = new ServerLdapContext(directoryService, session, (Name)new LdapName(searchBaseDn));
        }
        catch (Exception e) {
            throw new ServiceConfigurationException(I18n.err(I18n.ERR_649, searchBaseDn), e);
        }
    }

    @Override
    public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
        try {
            return new GetRecords(question).execute(this.ctx, null);
        }
        catch (Exception e) {
            LOG.debug("Unexpected error retrieving DNS records.", e);
            throw new DnsException(ResponseCode.SERVER_FAILURE);
        }
    }
}

