/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.helper.Serializer;
import jdbm.helper.TupleBrowser;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.SynchronizedLRUMap;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.avltree.ArrayMarshaller;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.ArrayTreeCursor;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirect;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirectMarshaller;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyBTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyTupleBTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.MarshallerSerializerBridge;
import org.apache.directory.server.core.partition.impl.btree.jdbm.NoDupsCursor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractTable;
import org.apache.directory.server.xdbm.KeyTupleArrayCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmTable<K, V>
extends AbstractTable<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmTable.class);
    private final RecordManager recMan;
    private BTree<K, V> bt;
    private int numDupLimit = 512;
    private final Map<Long, BTree<K, V>> duplicateBtrees;
    private final Serializer valueSerializer;
    Marshaller<ArrayTree<V>> marshaller;

    public JdbmTable(SchemaManager schemaManager, String name, int numDupLimit, RecordManager manager, Comparator<K> keyComparator, Comparator<V> valueComparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        super(schemaManager, name, keyComparator, valueComparator);
        if (valueComparator == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_592, new Object[0]));
        }
        this.duplicateBtrees = new SynchronizedLRUMap(100);
        this.marshaller = valueSerializer != null ? new ArrayMarshaller<V>(valueComparator, new MarshallerSerializerBridge(valueSerializer)) : new ArrayMarshaller<V>(valueComparator);
        this.numDupLimit = numDupLimit;
        this.recMan = manager;
        this.valueSerializer = valueSerializer;
        this.allowsDuplicates = true;
        long recId = this.recMan.getNamedObject(name);
        if (recId == 0L) {
            this.bt = new BTree(this.recMan, keyComparator, keySerializer, null);
            recId = this.bt.getRecordId();
            this.recMan.setNamedObject(name, recId);
        } else {
            this.bt = new BTree().load(this.recMan, recId);
            ((SerializableComparator)this.bt.getComparator()).setSchemaManager(schemaManager);
            this.count = this.bt.size();
        }
    }

    public JdbmTable(SchemaManager schemaManager, String name, RecordManager manager, Comparator<K> keyComparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        super(schemaManager, name, keyComparator, null);
        this.duplicateBtrees = null;
        this.numDupLimit = Integer.MAX_VALUE;
        this.recMan = manager;
        this.valueSerializer = valueSerializer;
        this.allowsDuplicates = false;
        long recId = this.recMan.getNamedObject(name);
        if (recId != 0L) {
            this.bt = new BTree().load(this.recMan, recId);
            ((SerializableComparator)this.bt.getComparator()).setSchemaManager(schemaManager);
            this.bt.setValueSerializer(valueSerializer);
            this.count = this.bt.size();
        } else {
            this.bt = new BTree(this.recMan, keyComparator, keySerializer, valueSerializer);
            recId = this.bt.getRecordId();
            this.recMan.setNamedObject(name, recId);
        }
    }

    @Override
    public long count(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return 0L;
        }
        try {
            if (!this.allowsDuplicates) {
                if (null == this.bt.find(key)) {
                    return 0L;
                }
                return 1L;
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                return values.getArrayTree().size();
            }
            return this.getBTree(values.getBTreeRedirect()).size();
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    @Override
    public V get(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return null;
        }
        try {
            if (!this.allowsDuplicates) {
                return this.bt.find(key);
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                if (set.getFirst() == null) {
                    return null;
                }
                return set.getFirst();
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
            TupleBrowser browser = tree.browse();
            browser.getNext(tuple);
            return (V)tuple.getKey();
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    @Override
    public boolean hasGreaterOrEqual(PartitionTxn transaction, K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_593, new Object[0]));
        }
        try {
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                V result = set.findGreaterOrEqual(val);
                return result != null;
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            return tree.size() != 0 && this.btreeHas(tree, val, true);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    @Override
    public boolean hasLessOrEqual(PartitionTxn transaction, K key, V val) throws LdapException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_593, new Object[0]));
        }
        try {
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                V result = set.findLessOrEqual(val);
                return result != null;
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            return tree.size() != 0 && this.btreeHas(tree, val, false);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    @Override
    public boolean hasGreaterOrEqual(PartitionTxn transaction, K key) throws LdapException {
        try {
            jdbm.helper.Tuple<K, V> tuple = this.bt.findGreaterOrEqual(key);
            if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
                return true;
            }
            return null != tuple;
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    @Override
    public boolean hasLessOrEqual(PartitionTxn transaction, K key) throws LdapException {
        try {
            jdbm.helper.Tuple<K, V> tuple = this.bt.findGreaterOrEqual(key);
            if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
                return true;
            }
            if (null == tuple) {
                return this.count > 0L;
            }
            TupleBrowser<K, V> browser = this.bt.browse(tuple.getKey());
            return browser.getPrevious(tuple);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    @Override
    public boolean has(PartitionTxn transaction, K key, V value) throws LdapException {
        if (key == null) {
            return false;
        }
        try {
            if (!this.allowsDuplicates) {
                V stored = this.bt.find(key);
                return null != stored && stored.equals(value);
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                return values.getArrayTree().find(value) != null;
            }
            return this.getBTree(values.getBTreeRedirect()).find(value) != null;
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    @Override
    public boolean has(PartitionTxn transaction, K key) throws LdapException {
        try {
            return key != null && this.bt.find(key) != null;
        }
        catch (IOException ioe) {
            throw new LdapException(ioe);
        }
    }

    @Override
    public synchronized void put(PartitionTxn transaction, K key, V value) throws LdapException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("---> Add {} = {}", (Object)this.name, (Object)key);
            }
            if (value == null || key == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_594, new Object[0]));
            }
            if (!this.allowsDuplicates) {
                Object replaced = this.bt.insert(key, value, true);
                if (null == replaced) {
                    ++this.count;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Add ONE {} = {}", (Object)this.name, (Object)key);
                }
                return;
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                V replaced = set.insert(value);
                if (replaced != null) {
                    return;
                }
                if (set.size() > this.numDupLimit) {
                    BTree<V, K> tree = this.convertToBTree(set);
                    BTreeRedirect redirect = new BTreeRedirect(tree.getRecordId());
                    this.bt.insert(key, BTreeRedirectMarshaller.INSTANCE.serialize(redirect), true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<--- Add new BTREE {} = {}", (Object)this.name, (Object)key);
                    }
                } else {
                    this.bt.insert(key, this.marshaller.serialize(set), true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<--- Add AVL {} = {}", (Object)this.name, (Object)key);
                    }
                }
                ++this.count;
                return;
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            Object replaced = tree.insert(value, Strings.EMPTY_BYTES, true);
            if (replaced == null) {
                ++this.count;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<--- Add BTREE {} = {}", (Object)this.name, (Object)key);
            }
        }
        catch (IOException | CursorException | LdapException e) {
            LOG.error(I18n.err(I18n.ERR_131, key, this.name), e);
            throw new LdapOtherException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void remove(PartitionTxn transaction, K key, V value) throws LdapException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("---> Remove {} = {}, {}", this.name, key, value);
            }
            if (key == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove NULL key {}", (Object)this.name);
                }
                return;
            }
            if (!this.allowsDuplicates) {
                V oldValue = this.bt.find(key);
                if (oldValue != null && oldValue.equals(value)) {
                    this.bt.remove(key);
                    --this.count;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<--- Remove ONE {} = {}, {}", this.name, key, value);
                    }
                }
                return;
            }
            DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                if (set.remove(value) != null) {
                    if (set.isEmpty()) {
                        this.bt.remove(key);
                    } else {
                        this.bt.insert(key, this.marshaller.serialize(set), true);
                    }
                    --this.count;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<--- Remove AVL {} = {}, {}", this.name, key, value);
                    }
                }
                return;
            }
            BTree tree = this.getBTree(values.getBTreeRedirect());
            if (tree.find(value) != null && tree.remove(value) != null) {
                if (tree.size() <= this.numDupLimit) {
                    ArrayTree<V> avlTree = this.convertToArrayTree(tree);
                    this.bt.insert(key, this.marshaller.serialize(avlTree), true);
                    this.recMan.delete(tree.getRecordId());
                }
                --this.count;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove BTREE {} = {}, {}", this.name, key, value);
                }
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_132, key, value, this.name), e);
        }
    }

    @Override
    public synchronized void remove(PartitionTxn transaction, K key) throws LdapException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("---> Remove {} = {}", (Object)this.name, (Object)key);
            }
            if (key == null) {
                return;
            }
            V returned = this.bt.remove(key);
            if (null == returned) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove AVL {} = {} (not found)", (Object)this.name, (Object)key);
                }
                return;
            }
            if (!this.allowsDuplicates) {
                --this.count;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove ONE {} = {}", (Object)this.name, (Object)key);
                }
                return;
            }
            byte[] serialized = (byte[])returned;
            if (BTreeRedirectMarshaller.isRedirect(serialized)) {
                BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
                this.count -= (long)tree.size();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove BTree {} = {}", (Object)this.name, (Object)key);
                }
                this.recMan.delete(tree.getRecordId());
                this.duplicateBtrees.remove(tree.getRecordId());
            } else {
                ArrayTree<V> set = this.marshaller.deserialize(serialized);
                this.count -= (long)set.size();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<--- Remove AVL {} = {}", (Object)this.name, (Object)key);
                }
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_133, key, this.name), e);
        }
    }

    @Override
    public Cursor<Tuple<K, V>> cursor() {
        if (this.allowsDuplicates) {
            return new DupsCursor(this);
        }
        return new NoDupsCursor(this);
    }

    @Override
    public Cursor<Tuple<K, V>> cursor(PartitionTxn partitionTxn, K key) throws LdapException {
        if (key == null) {
            return new EmptyCursor<Tuple<K, V>>();
        }
        try {
            V raw = this.bt.find(key);
            if (null == raw) {
                return new EmptyCursor<Tuple<K, V>>();
            }
            if (!this.allowsDuplicates) {
                return new SingletonCursor<Tuple<K, V>>(new Tuple<K, V>(key, raw));
            }
            byte[] serialized = (byte[])raw;
            if (BTreeRedirectMarshaller.isRedirect(serialized)) {
                BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
                return new KeyTupleBTreeCursor(tree, key, this.valueComparator);
            }
            ArrayTree<V> set = this.marshaller.deserialize(serialized);
            return new KeyTupleArrayCursor<K, V>(set, key);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public Cursor<V> valueCursor(PartitionTxn transaction, K key) throws LdapException {
        if (key == null) {
            return new EmptyCursor();
        }
        try {
            V raw = this.bt.find(key);
            if (null == raw) {
                return new EmptyCursor();
            }
            if (!this.allowsDuplicates) {
                return new SingletonCursor<V>(raw);
            }
            byte[] serialized = (byte[])raw;
            if (BTreeRedirectMarshaller.isRedirect(serialized)) {
                BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
                return new KeyBTreeCursor(tree, this.valueComparator);
            }
            return new ArrayTreeCursor<V>(this.marshaller.deserialize(serialized));
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public synchronized void close(PartitionTxn transaction) throws LdapException {
    }

    public Marshaller<ArrayTree<V>> getMarshaller() {
        return this.marshaller;
    }

    boolean isKeyUsingBTree(K key) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!this.allowsDuplicates) {
            return false;
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        return values.isBTreeRedirect();
    }

    DupsContainer<V> getDupsContainer(byte[] serialized) throws LdapException {
        if (serialized == null) {
            return new DupsContainer(new ArrayTree(this.valueComparator));
        }
        if (BTreeRedirectMarshaller.isRedirect(serialized)) {
            try {
                return new DupsContainer(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage());
            }
        }
        try {
            return new DupsContainer<V>(this.marshaller.deserialize(serialized));
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage());
        }
    }

    BTree getBTree() {
        return this.bt;
    }

    BTree getBTree(BTreeRedirect redirect) throws IOException {
        if (this.duplicateBtrees.containsKey(redirect.getRecId())) {
            return this.duplicateBtrees.get(redirect.getRecId());
        }
        BTree tree = new BTree().load(this.recMan, redirect.getRecId());
        ((SerializableComparator)tree.getComparator()).setSchemaManager(this.schemaManager);
        this.duplicateBtrees.put(redirect.getRecId(), tree);
        return tree;
    }

    private boolean btreeHas(BTree tree, V key, boolean isGreaterThan) throws IOException {
        jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
        TupleBrowser browser = tree.browse(key);
        if (isGreaterThan) {
            return browser.getNext(tuple);
        }
        if (browser.getPrevious(tuple)) {
            return true;
        }
        browser.getNext(tuple);
        Object firstKey = tuple.getKey();
        return this.valueComparator.compare(key, firstKey) == 0;
    }

    private ArrayTree<V> convertToArrayTree(BTree bTree) throws IOException {
        ArrayTree avlTree = new ArrayTree(this.valueComparator);
        TupleBrowser browser = bTree.browse();
        jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
        while (browser.getNext(tuple)) {
            avlTree.insert(tuple.getKey());
        }
        return avlTree;
    }

    private BTree<V, K> convertToBTree(ArrayTree<V> arrayTree) throws IOException, CursorException, LdapException {
        BTree<Object, Object> bTree = this.valueSerializer != null ? new BTree(this.recMan, this.valueComparator, this.valueSerializer, null) : new BTree(this.recMan, this.valueComparator);
        try (ArrayTreeCursor<V> keys = new ArrayTreeCursor<V>(arrayTree);){
            keys.beforeFirst();
            while (keys.next()) {
                bTree.insert(keys.get(), Strings.EMPTY_BYTES, true);
            }
        }
        return bTree;
    }
}

