/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.i18n.I18n;

public class SingletonOrOrderedSet<V> {
    private V singleton;
    private AvlTree<V> orderedSet;

    public SingletonOrOrderedSet(V singleton) {
        if (singleton == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_447, new Object[0]));
        }
        this.singleton = singleton;
    }

    public SingletonOrOrderedSet(AvlTree<V> orderedSet) {
        if (orderedSet == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_448, new Object[0]));
        }
        this.orderedSet = orderedSet;
    }

    public boolean isSingleton() {
        return this.singleton != null;
    }

    public boolean isOrderedSet() {
        return this.orderedSet != null;
    }

    public V getSingleton() {
        if (this.singleton != null) {
            return this.singleton;
        }
        throw new RuntimeException(I18n.err(I18n.ERR_449, new Object[0]));
    }

    public V setSingleton(V singleton) {
        if (singleton == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_447, new Object[0]));
        }
        if (this.orderedSet != null) {
            throw new RuntimeException(I18n.err(I18n.ERR_450, new Object[0]));
        }
        V retval = this.singleton;
        this.singleton = singleton;
        return retval;
    }

    public AvlTree<V> switchToSingleton(V singleton) {
        if (singleton == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_447, new Object[0]));
        }
        if (this.singleton != null) {
            throw new RuntimeException(I18n.err(I18n.ERR_451, new Object[0]));
        }
        AvlTree<V> retval = this.orderedSet;
        this.orderedSet = null;
        this.singleton = singleton;
        return retval;
    }

    public AvlTree<V> getOrderedSet() {
        if (this.orderedSet != null) {
            return this.orderedSet;
        }
        throw new RuntimeException(I18n.err(I18n.ERR_452, new Object[0]));
    }

    public AvlTree<V> setOrderedSet(AvlTree<V> orderedSet) {
        if (orderedSet == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_448, new Object[0]));
        }
        if (this.singleton != null) {
            throw new RuntimeException(I18n.err(I18n.ERR_453, new Object[0]));
        }
        AvlTree<V> retval = this.orderedSet;
        this.orderedSet = orderedSet;
        return retval;
    }

    public V switchToOrderedSet(AvlTree<V> orderedSet) {
        if (orderedSet == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_448, new Object[0]));
        }
        if (this.orderedSet != null) {
            throw new RuntimeException(I18n.err(I18n.ERR_454, new Object[0]));
        }
        V retval = this.singleton;
        this.orderedSet = orderedSet;
        this.singleton = null;
        return retval;
    }
}

