/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.StringUtils;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.param.Parameters;
import org.apache.deltaspike.data.impl.util.jpa.QueryStringExtractorFactory;

@ApplicationScoped
public class AnnotatedQueryBuilder
extends QueryBuilder {
    private final QueryStringExtractorFactory factory = new QueryStringExtractorFactory();

    @Override
    public Object execute(CdiQueryInvocationContext context) {
        Method method = context.getMethod();
        org.apache.deltaspike.data.api.Query query = method.getAnnotation(org.apache.deltaspike.data.api.Query.class);
        Query jpaQuery = this.createJpaQuery(query, context);
        return context.executeQuery(jpaQuery);
    }

    private Query createJpaQuery(org.apache.deltaspike.data.api.Query query, CdiQueryInvocationContext context) {
        EntityManager entityManager = context.getEntityManager();
        Parameters params = context.getParams();
        Query result = null;
        if (StringUtils.isNotEmpty((String)query.named())) {
            if (!context.hasQueryStringPostProcessors()) {
                result = params.applyTo(entityManager.createNamedQuery(query.named()));
            } else {
                Query namedQuery = entityManager.createNamedQuery(query.named());
                String named = this.factory.extract(namedQuery);
                String jpqlQuery = context.applyQueryStringPostProcessors(named);
                result = params.applyTo(entityManager.createQuery(jpqlQuery));
            }
        } else if (query.isNative()) {
            String jpqlQuery = context.applyQueryStringPostProcessors(query.value());
            Class<?> resultType = this.getQueryResultType(context.getMethod());
            result = this.isEntityType(resultType) ? params.applyTo(entityManager.createNativeQuery(jpqlQuery, resultType)) : params.applyTo(entityManager.createNativeQuery(jpqlQuery));
        } else {
            String jpqlQuery = context.applyQueryStringPostProcessors(query.value());
            context.setQueryString(jpqlQuery);
            result = params.applyTo(entityManager.createQuery(jpqlQuery));
        }
        return context.applyRestrictions(result);
    }

    private boolean isEntityType(Class<?> cls) {
        return cls.getAnnotation(Entity.class) != null;
    }

    private Class<?> getQueryResultType(Method method) {
        if (ClassUtils.returns((Method)method, List.class) && !ClassUtils.returns((Method)method, Object.class)) {
            ParameterizedType pt = (ParameterizedType)method.getGenericReturnType();
            return (Class)pt.getActualTypeArguments()[0];
        }
        return method.getReturnType();
    }
}

