/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class TestDurabilityProperty {
    public static void main(String[] stringArray) {
        try {
            TestDurabilityProperty.testNoSyncs(stringArray);
            String string = System.getProperty("derby.system.home");
            TestDurabilityProperty.report("Is warning message about derby.system.durability=test present in derby.log =" + TestDurabilityProperty.isMessageInDerbyLog(string));
            TestDurabilityProperty.markerInControlFile(string);
            TestDurabilityProperty.report("2. shutdown database and reboot database without derby.system.durability=test and test for marker in log.ctrl file");
            TestDurabilityProperty.markerNotOverwritten(string);
        }
        catch (Throwable throwable) {
            TestDurabilityProperty.report("FAIL -- unexpected exception: " + String.valueOf(throwable));
            throwable.printStackTrace();
        }
    }

    public static long timeTakenToInsert(String string, boolean bl, boolean bl2) throws Exception {
        long l;
        block3: {
            System.setProperty("derby.system.durability", string);
            Connection connection = ij.startJBMS();
            if (bl) {
                Statement statement = connection.createStatement();
                statement.execute("create table t1 (c1 int, c2 int)");
                statement.close();
            }
            l = TestDurabilityProperty.doInserts(connection, bl2);
            try {
                connection.close();
                TestUtil.getConnection("", "shutdown=true");
            }
            catch (SQLException sQLException) {
                if ("XJ015".equals(sQLException.getSQLState())) break block3;
                TestDurabilityProperty.report(sQLException.getSQLState());
                TestDurabilityProperty.report("ERROR! during shutdown");
                sQLException.printStackTrace();
            }
        }
        return l;
    }

    public static long doInserts(Connection connection, boolean bl) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t1 values(?,?)");
        connection.setAutoCommit(bl);
        long l = 0L;
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            l += (long)preparedStatement.executeUpdate();
        }
        if (!bl) {
            connection.commit();
        }
        long l3 = System.currentTimeMillis();
        if (l < 500L) {
            TestDurabilityProperty.report(" FAIL!! all rows didnt get inserted ?");
        }
        return l3 - l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMessageInDerbyLog(String string) throws Exception {
        BufferedReader bufferedReader = null;
        File file = null;
        try {
            file = new File(string, "derby.log");
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf("derby.system.durability=test") == -1) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markerInControlFile(String string) throws Exception {
        try (RandomAccessFile randomAccessFile = null;){
            int n = 28;
            int n2 = 2;
            randomAccessFile = new RandomAccessFile(string + "/wombat/log/log.ctrl", "r");
            randomAccessFile.seek(n);
            TestDurabilityProperty.report("log.ctrl file has durability testMode no sync marker value = " + ((randomAccessFile.readByte() & n2) != 0));
        }
    }

    public static void markerNotOverwritten(String string) throws Exception {
        Connection connection = null;
        System.setProperty("derby.system.durability", "");
        connection = ij.startJBMS();
        connection.close();
        TestDurabilityProperty.markerInControlFile(string);
        TestDurabilityProperty.report("Is warning message about derby.system.durability=test present in derby.log =" + TestDurabilityProperty.isMessageInDerbyLog(string));
    }

    public static void report(String string) {
        System.out.println(string);
    }

    public static void testNoSyncs(String[] stringArray) throws Exception {
        boolean bl = false;
        TestDurabilityProperty.report("1. With derby.system.durability=test,Test to see if syncs are not happening ");
        ij.getPropertyArg((String[])stringArray);
        boolean bl2 = true;
        long l = TestDurabilityProperty.timeTakenToInsert("", bl2, true);
        String string = System.getProperty("derby.system.home");
        if (TestDurabilityProperty.isMessageInDerbyLog(string)) {
            TestDurabilityProperty.report("ERROR! System should not have been booted withderby.system.durability=test mode here");
        }
        bl2 = false;
        long l2 = TestDurabilityProperty.timeTakenToInsert("test", bl2, true);
        long l3 = TestDurabilityProperty.timeTakenToInsert("test", bl2, false);
        if (bl) {
            TestDurabilityProperty.report("timeCommitOn = " + l);
            TestDurabilityProperty.report("timeWithTestModeCommitOn = " + l2);
            TestDurabilityProperty.report("timeWithTestModeCommitOff = " + l3);
        }
    }
}

