/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import junit.framework.TestCase;

public class DerbyJUnitTest
extends TestCase {
    public static final String DEBUG_FLAG = "drb.tests.debug";
    public static final int SUCCESS_EXIT = 0;
    public static final int FAILURE_EXIT = 1;
    public static final String DEFAULT_USER_NAME = "APP";
    public static final String DEFAULT_PASSWORD = "APP";
    public static final String DEFAULT_DATABASE_NAME = "wombat";
    protected static final int JDBC_BOOLEAN = 16;
    private static final String TABLE = "table";
    private static final String FUNCTION = "function";
    private static final String PROCEDURE = "procedure";
    private static final String TYPE = "type";
    private static final String CREATE_PROPERTY = "create=true";
    public static final int DATABASE_URL = 0;
    public static final int DRIVER_NAME = 1;
    public static final int FRAMEWORK_NAME = 2;
    private static final String[] DERBY_CLIENT = new String[]{"jdbc:derby://localhost:1527/", "org.apache.derby.jdbc.ClientDriver", "DerbyNetClient"};
    private static final String[] EMBEDDED_CLIENT = new String[]{"jdbc:derby:", "org.apache.derby.jdbc.EmbeddedDriver", "embedded"};
    public static final String[][] LEGAL_CLIENTS = new String[][]{DERBY_CLIENT, EMBEDDED_CLIENT};
    private static boolean _debug;
    private static PrintStream _outputStream;
    private static String _databaseName;
    private static String[] _defaultClientSettings;

    public boolean usingEmbeddedClient() {
        return _defaultClientSettings == EMBEDDED_CLIENT;
    }

    public boolean usingDerbyClient() {
        return _defaultClientSettings == DERBY_CLIENT;
    }

    public static String[] getClientSettings() {
        return _defaultClientSettings;
    }

    public static void setClient(String[] stringArray) {
        _defaultClientSettings = stringArray;
    }

    public static void setDatabaseName(String string) {
        _databaseName = string;
    }

    public static void setDebug(boolean bl) {
        _debug = bl;
    }

    public static boolean parseDebug() {
        _debug = Boolean.getBoolean(DEBUG_FLAG);
        return true;
    }

    public static void println(String string) {
        if (_debug) {
            DerbyJUnitTest.alarm(string);
        }
    }

    public static void alarm(String string) {
        _outputStream.println(string);
        _outputStream.flush();
    }

    public static void printStackTrace(Throwable throwable) {
        while (throwable != null) {
            throwable.printStackTrace(_outputStream);
            if (!(throwable instanceof SQLException)) break;
            throwable = ((SQLException)throwable).getNextException();
        }
    }

    protected static boolean faultInDriver(String[] stringArray) {
        String string = stringArray[1];
        try {
            Class.forName(string);
            return true;
        }
        catch (Exception exception) {
            DerbyJUnitTest.println("Could not find " + string);
            return false;
        }
    }

    protected static Connection getConnection() throws Exception {
        return DerbyJUnitTest.getConnection(_defaultClientSettings, _databaseName, new Properties());
    }

    protected static Connection getConnection(String[] stringArray, String string, Properties properties) throws Exception {
        DerbyJUnitTest.faultInDriver(stringArray);
        properties.put("user", "APP");
        properties.put("password", "APP");
        properties.put("retreiveMessagesFromServerOnGetMessage", "true");
        Connection connection = DriverManager.getConnection(DerbyJUnitTest.makeDatabaseURL(stringArray, string), properties);
        DerbyJUnitTest.println("Connection is a " + connection.getClass().getName());
        return connection;
    }

    private static String makeDatabaseURL(String[] stringArray, String string) {
        return stringArray[0] + string;
    }

    protected void createDB(String string) throws Exception {
        String[] stringArray = DerbyJUnitTest.getClientSettings();
        Object object = DerbyJUnitTest.makeDatabaseURL(stringArray, string);
        object = (String)object + ";create=true";
        Properties properties = new Properties();
        properties.put("user", "APP");
        properties.put("password", "APP");
        DerbyJUnitTest.faultInDriver(stringArray);
        Connection connection = DriverManager.getConnection((String)object, properties);
        connection.close();
    }

    protected static void executeDDL(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = DerbyJUnitTest.prepare(connection, string);
            preparedStatement.execute();
        }
        finally {
            DerbyJUnitTest.close(preparedStatement);
        }
    }

    protected static void execute(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = DerbyJUnitTest.prepare(connection, string);
        preparedStatement.execute();
        DerbyJUnitTest.close(preparedStatement);
    }

    protected static PreparedStatement prepare(Connection connection, String string) throws SQLException {
        DerbyJUnitTest.println("Preparing: " + string);
        return connection.prepareStatement(string);
    }

    protected static CallableStatement prepareCall(Connection connection, String string) throws SQLException {
        DerbyJUnitTest.println("Preparing procedure call: '" + string + "'");
        CallableStatement callableStatement = connection.prepareCall(string);
        return callableStatement;
    }

    protected static void truncateTable(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = DerbyJUnitTest.prepare(connection, "delete from " + string);
        preparedStatement.execute();
    }

    protected static void dropTable(Connection connection, String string) {
        DerbyJUnitTest.dropSchemaObject(connection, TABLE, string, false);
    }

    protected static void dropFunction(Connection connection, String string) {
        DerbyJUnitTest.dropSchemaObject(connection, FUNCTION, string, false);
    }

    protected static void dropProcedure(Connection connection, String string) {
        DerbyJUnitTest.dropSchemaObject(connection, PROCEDURE, string, false);
    }

    protected static void dropUDT(Connection connection, String string) {
        DerbyJUnitTest.dropSchemaObject(connection, TYPE, string, true);
    }

    protected static void dropSchemaObject(Connection connection, String string, String string2, boolean bl) {
        PreparedStatement preparedStatement;
        block3: {
            preparedStatement = null;
            try {
                String string3 = "drop " + string + " " + string2;
                if (bl) {
                    string3 = string3 + " restrict";
                }
                preparedStatement = DerbyJUnitTest.prepare(connection, string3);
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                if (!_debug) break block3;
                DerbyJUnitTest.printStackTrace(sQLException);
            }
        }
        DerbyJUnitTest.close(preparedStatement);
    }

    protected static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            DerbyJUnitTest.printStackTrace(sQLException);
        }
    }

    protected static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            DerbyJUnitTest.printStackTrace(sQLException);
        }
    }

    protected static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            DerbyJUnitTest.printStackTrace(sQLException);
        }
    }

    protected Object getColumn(ResultSet resultSet, String string, int n) throws Exception {
        Object object = null;
        switch (n) {
            case 16: {
                object = resultSet.getBoolean(string);
                break;
            }
            case -5: {
                object = resultSet.getLong(string);
                break;
            }
            case 2004: {
                object = resultSet.getBlob(string);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                object = resultSet.getString(string);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = resultSet.getBytes(string);
                break;
            }
            case 2005: {
                object = resultSet.getClob(string);
                break;
            }
            case 91: {
                object = resultSet.getDate(string);
                break;
            }
            case 2: 
            case 3: {
                object = resultSet.getBigDecimal(string);
                break;
            }
            case 8: {
                object = resultSet.getDouble(string);
                break;
            }
            case 7: {
                object = Float.valueOf(resultSet.getFloat(string));
                break;
            }
            case 4: {
                object = resultSet.getInt(string);
                break;
            }
            case 5: {
                object = resultSet.getShort(string);
                break;
            }
            case 92: {
                object = resultSet.getTime(string);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(string);
                break;
            }
            default: {
                DerbyJUnitTest.fail((String)("Unknown jdbc type " + n + " used to retrieve column: " + string));
            }
        }
        if (resultSet.wasNull()) {
            object = null;
        }
        return object;
    }

    protected Object getColumn(ResultSet resultSet, int n, Object object) throws Exception {
        Object object2 = object == null ? resultSet.getObject(n) : (object instanceof Boolean ? Boolean.valueOf(resultSet.getBoolean(n)) : (object instanceof Byte ? Byte.valueOf(resultSet.getByte(n)) : (object instanceof Short ? Short.valueOf(resultSet.getShort(n)) : (object instanceof Integer ? Integer.valueOf(resultSet.getInt(n)) : (object instanceof Long ? Long.valueOf(resultSet.getLong(n)) : (object instanceof Float ? Float.valueOf(resultSet.getFloat(n)) : (object instanceof Double ? Double.valueOf(resultSet.getDouble(n)) : (object instanceof String ? resultSet.getString(n) : (object instanceof BigDecimal ? resultSet.getBigDecimal(n) : resultSet.getObject(n))))))))));
        if (resultSet.wasNull()) {
            object2 = null;
        }
        return object2;
    }

    protected Object getOutArg(CallableStatement callableStatement, int n, int n2) throws Exception {
        Object object = null;
        switch (n2) {
            case 16: {
                object = callableStatement.getBoolean(n);
                break;
            }
            case -5: {
                object = callableStatement.getLong(n);
                break;
            }
            case 2004: {
                object = callableStatement.getBlob(n);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                object = callableStatement.getString(n);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = callableStatement.getBytes(n);
                break;
            }
            case 2005: {
                object = callableStatement.getClob(n);
                break;
            }
            case 91: {
                object = callableStatement.getDate(n);
                break;
            }
            case 2: 
            case 3: {
                object = callableStatement.getBigDecimal(n);
                break;
            }
            case 8: {
                object = callableStatement.getDouble(n);
                break;
            }
            case 7: {
                object = Float.valueOf(callableStatement.getFloat(n));
                break;
            }
            case 4: {
                object = callableStatement.getInt(n);
                break;
            }
            case 5: {
                object = callableStatement.getShort(n);
                break;
            }
            case 92: {
                object = callableStatement.getTime(n);
                break;
            }
            case 93: {
                object = callableStatement.getTimestamp(n);
                break;
            }
            default: {
                DerbyJUnitTest.fail((String)("Unknown jdbc type " + n2 + " used to retrieve column: " + n));
            }
        }
        if (callableStatement.wasNull()) {
            object = null;
        }
        return object;
    }

    protected void setParameter(PreparedStatement preparedStatement, int n, int n2, Object object) throws Exception {
        if (object == null) {
            preparedStatement.setNull(n, n2);
            return;
        }
        switch (n2) {
            case 16: {
                preparedStatement.setBoolean(n, (Boolean)object);
                break;
            }
            case -5: {
                preparedStatement.setLong(n, (Long)object);
                break;
            }
            case 2004: {
                preparedStatement.setBlob(n, (Blob)object);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                preparedStatement.setString(n, (String)object);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                preparedStatement.setBytes(n, (byte[])object);
                break;
            }
            case 2005: {
                preparedStatement.setClob(n, (Clob)object);
                break;
            }
            case 91: {
                preparedStatement.setDate(n, (Date)object);
                break;
            }
            case 2: 
            case 3: {
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case 8: {
                preparedStatement.setDouble(n, (Double)object);
                break;
            }
            case 7: {
                preparedStatement.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case 4: {
                preparedStatement.setInt(n, (Integer)object);
                break;
            }
            case 5: {
                preparedStatement.setShort(n, (Short)object);
                break;
            }
            case 92: {
                preparedStatement.setTime(n, (Time)object);
                break;
            }
            case 93: {
                preparedStatement.setTimestamp(n, (Timestamp)object);
                break;
            }
            default: {
                DerbyJUnitTest.fail((String)("Unknown jdbc type: " + n2));
            }
        }
    }

    protected void setParameter(PreparedStatement preparedStatement, int n, Object object) throws Exception {
        if (object == null) {
            preparedStatement.setObject(n, null);
            return;
        }
        if (object instanceof Boolean) {
            preparedStatement.setBoolean(n, (Boolean)object);
        } else if (object instanceof Byte) {
            preparedStatement.setByte(n, (Byte)object);
        } else if (object instanceof Short) {
            preparedStatement.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            preparedStatement.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            preparedStatement.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (object instanceof String) {
            preparedStatement.setString(n, (String)object);
        } else {
            preparedStatement.setObject(n, object);
        }
    }

    protected String singleQuote(String string) {
        return "'" + string + "'";
    }

    public void assertRow(ResultSet resultSet, Object[] objectArray) throws Exception {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            Object object = objectArray[i];
            Object object2 = this.getColumn(resultSet, n2, object);
            this.compareObjects("Column number " + n2, object, object2);
        }
    }

    public void assertScalar(Connection connection, String string, Object object) throws Exception {
        PreparedStatement preparedStatement = DerbyJUnitTest.prepare(connection, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        this.assertColumnEquals(string, resultSet, 1, object);
        DerbyJUnitTest.close(resultSet);
        DerbyJUnitTest.close(preparedStatement);
    }

    public void assertColumnEquals(ResultSet resultSet, int n, Object[] objectArray) throws Exception {
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            resultSet.next();
            this.assertColumnEquals(Integer.toString(i), resultSet, n, objectArray[i]);
        }
    }

    public void assertColumnEquals(String string, ResultSet resultSet, int n, Object object) throws Exception {
        Object object2 = this.getColumn(resultSet, n, object);
        this.compareObjects(string, object, object2);
    }

    public void compareObjects(String object, Object object2, Object object3) throws Exception {
        object = (String)object + "\n\t expected = " + String.valueOf(object2) + "\n\t actual = " + String.valueOf(object3);
        if (object2 == null) {
            DerbyJUnitTest.assertNull((String)object, (Object)object3);
        } else {
            DerbyJUnitTest.assertNotNull((String)object, (Object)object3);
            if (object2 instanceof byte[]) {
                this.compareBytes((String)object, object2, object3);
            } else if (object2 instanceof java.util.Date) {
                this.compareDates((String)object, object2, object3);
            } else {
                DerbyJUnitTest.assertTrue((String)object, (boolean)object2.equals(object3));
            }
        }
    }

    public void compareBytes(String string, Object object, Object object2) throws Exception {
        if (object == null) {
            DerbyJUnitTest.assertNull((String)string, (Object)object2);
        } else {
            DerbyJUnitTest.assertNotNull((Object)object2);
        }
        if (!(object instanceof byte[])) {
            DerbyJUnitTest.fail((String)string);
        }
        if (!(object2 instanceof byte[])) {
            DerbyJUnitTest.fail((String)string);
        }
        byte[] byArray = (byte[])object;
        byte[] byArray2 = (byte[])object2;
        int n = byArray.length;
        DerbyJUnitTest.assertEquals((String)string, (int)n, (int)byArray2.length);
        for (int i = 0; i < n; ++i) {
            DerbyJUnitTest.assertEquals((String)(string + "[ " + i + " ]"), (byte)byArray[i], (byte)byArray2[i]);
        }
    }

    public void compareDates(String string, Object object, Object object2) throws Exception {
        if (object == null) {
            DerbyJUnitTest.assertNull((String)string, (Object)object2);
        } else {
            DerbyJUnitTest.assertNotNull((Object)object2);
        }
        if (!(object instanceof java.util.Date)) {
            DerbyJUnitTest.fail((String)string);
        }
        if (!(object2 instanceof java.util.Date)) {
            DerbyJUnitTest.fail((String)string);
        }
        DerbyJUnitTest.assertEquals((String)string, (String)object.toString(), (String)object2.toString());
    }

    static {
        _outputStream = System.out;
    }
}

