/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class MadhareTest
extends BaseJDBCTestCase {
    public MadhareTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("MadhareTest Test");
        return TestConfiguration.defaultSuite(MadhareTest.class);
    }

    public void testBasicMadhare() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t( i int )");
        statement.executeUpdate("insert into t(i) values (1956)");
        ResultSet resultSet = statement.executeQuery("select i from t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1956"}});
        statement.executeUpdate("create table s (i int, n int, t int, e int, g int, r int)");
        statement.executeUpdate("insert into s (i,r,t,n,g,e) values (1,6,3,2,5,4)");
        statement.executeUpdate("insert into s values (10,11,12,13,14,15)");
        resultSet = statement.executeQuery("select i from s");
        String[][] stringArray = new String[][]{{"1"}, {"10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select n,e,r,i,t,g from s");
        stringArray = new String[][]{{"2", "4", "6", "1", "3", "5"}, {"11", "13", "15", "10", "12", "14"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select 20,n,22,e,24,r from s");
        stringArray = new String[][]{{"20", "2", "22", "4", "24", "6"}, {"20", "11", "22", "13", "24", "15"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        PreparedStatement preparedStatement = this.prepareStatement("select i,n,t,e,g,r from s");
        resultSet = preparedStatement.executeQuery();
        stringArray = new String[][]{{"1", "2", "3", "4", "5", "6"}, {"10", "11", "12", "13", "14", "15"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, stringArray);
        preparedStatement.close();
        statement.executeUpdate("create table r(s smallint, i int)");
        statement.executeUpdate("insert into r values (23,2)");
        resultSet = statement.executeQuery("select s,i from r");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"23", "2"}});
        statement.executeUpdate("drop table r");
        statement.executeUpdate("drop table s");
        statement.executeUpdate("drop table t");
        statement.close();
    }
}

