/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.util.StringTokenizer;

public class JavaVersionHolder {
    private static final String EARLY_ACCESS_SUFFIX = "-ea";
    private String majorVersion;
    private String minorVersion;
    private int major;
    private int minor;

    public JavaVersionHolder(String object) throws NumberFormatException {
        object = this.stripEarlyAccessSuffix((String)object);
        if (((String)object).startsWith("9")) {
            object = "1.9.0";
        }
        if (((String)object).startsWith("11")) {
            object = "1.11.0";
        }
        switch (object) {
            case "10": 
            case "13": 
            case "14": 
            case "15": 
            case "16": 
            case "17": 
            case "18": 
            case "19": 
            case "20": 
            case "21": {
                object = "1." + (String)object + ".0";
                break;
            }
        }
        int n = ((String)object).indexOf(46);
        int n2 = ((String)object).indexOf(46, n + 1);
        this.majorVersion = ((String)object).substring(0, n);
        try {
            Integer n3 = Integer.valueOf(this.majorVersion);
            this.major = n3;
            if (n2 != -1) {
                this.minorVersion = ((String)object).substring(n + 1, n2);
                Integer n4 = Integer.valueOf(this.minorVersion);
                this.minor = n4;
            } else {
                this.minorVersion = ((String)object).substring(n + 1);
                Integer n5 = Integer.valueOf(this.minorVersion);
                this.minor = n5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (((String)object).startsWith("HP")) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ".");
                String string = stringTokenizer.nextToken();
                this.majorVersion = stringTokenizer.nextToken();
                if (this.majorVersion.equals("01")) {
                    this.majorVersion = "1";
                } else if (this.majorVersion.equals("02")) {
                    this.majorVersion = "2";
                }
                this.minorVersion = stringTokenizer.nextToken();
                if (this.minorVersion.startsWith("1")) {
                    this.minorVersion = "1";
                } else if (this.minorVersion.startsWith("2")) {
                    this.minorVersion = "2";
                }
                try {
                    Integer n6 = Integer.valueOf(this.majorVersion);
                    this.major = n6;
                    Integer n7 = Integer.valueOf(this.minorVersion);
                    this.minor = n7;
                }
                catch (NumberFormatException numberFormatException2) {
                    System.out.println("Could not parse version: " + String.valueOf(numberFormatException2));
                }
            }
            System.out.println("NumberFormatException thrown trying to parse the version. " + (String)object);
            System.out.println("The test harness only handles the HP special case.");
        }
    }

    private String stripEarlyAccessSuffix(String string) {
        int n = string.indexOf(EARLY_ACCESS_SUFFIX);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorNumber() {
        return this.major;
    }

    public int getMinorNumber() {
        return this.minor;
    }

    public boolean atLeast(int n, int n2) {
        if (this.major < n) {
            return false;
        }
        if (this.major > n) {
            return true;
        }
        return this.minor >= n2;
    }
}

