/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.sttest;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.system.sttest.tools.MemCheck;
import org.apache.derbyTesting.system.sttest.utils.Datatypes;
import org.apache.derbyTesting.system.sttest.utils.Setup;
import org.apache.derbyTesting.system.sttest.utils.StStatus;

public class Sttest
extends Thread {
    static int loops = 200;
    static int rowcount = 0;
    static int testcount = 0;
    static int connections_to_make = 250;
    static Random rand;
    static boolean increase;
    static boolean not_finished;
    static int targetmax;
    static int targetmin;
    static int insertsize;
    static int updatesize;
    static int deletesize;
    static boolean fatal;
    static int rows;
    static boolean countlock;
    static int delete_freq;
    static int locker_id;
    static final int INIT = 0;
    static final int GROW = 1;
    static final int SHRINK = 2;
    static int mode;
    static int count_timer;
    static int inserts_to_try;
    static final int INITIAL_CONNECTIONS = 2;
    static boolean startByIJ;
    static String dbURL;
    static String driver;
    static StStatus status;
    int thread_id;
    int ind = 0;

    public static void main(String[] args) throws SQLException, IOException, InterruptedException, Exception, Throwable {
        System.getProperties().put("derby.locks.deadlockTimeout", "60");
        System.getProperties().put("derby.locks.waitTimeout", "200");
        System.out.println("Test Sttest starting");
        System.getProperties().put("derby.infolog.append", "true");
        System.getProperties().put("derby.stream.error.logSeverityLevel", "0");
        Sttest.userProperties();
        Class<?> clazz = Class.forName(driver);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (!Setup.doit(dbURL)) {
            System.exit(1);
        }
        status = new StStatus();
        Sttest.sttTop();
    }

    static void userProperties() throws Throwable {
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream("Sttest.properties");
        }
        catch (Exception e) {
            System.out.println("user control file 'Sttest.properties' not found; using defaults");
        }
        if (fileIn != null) {
            Properties props = new Properties();
            props.load(fileIn);
            fileIn.close();
            String prop = null;
            prop = props.getProperty("connections");
            if (prop != null) {
                connections_to_make = Integer.parseInt(prop);
            }
            if ((prop = props.getProperty("dbURL")) != null) {
                dbURL = prop;
            }
            if ((prop = props.getProperty("driver")) != null) {
                driver = prop;
            }
            Properties sysprops = System.getProperties();
            Enumeration<?> list = props.propertyNames();
            String s = null;
            while (list.hasMoreElements()) {
                s = (String)list.nextElement();
                sysprops.put(s, props.getProperty(s));
            }
        }
        System.out.println("driver = " + driver);
        System.out.println("dbURL = " + dbURL);
        System.out.println("connections = " + connections_to_make);
    }

    public static void sttTop() throws SQLException, IOException, InterruptedException, Exception, Throwable {
        int i;
        Datatypes.Rn = rand = new Random();
        delete_freq = 1 + connections_to_make % 5;
        Sttest.initial_data();
        Date d = new Date();
        status.firstMessage(connections_to_make, d);
        MemCheck mc = new MemCheck(200000);
        mc.start();
        Sttest[] testsessions = new Sttest[connections_to_make];
        for (i = 0; i < connections_to_make; ++i) {
            testsessions[i] = new Sttest(i);
            testsessions[i].start();
            Sttest.sleep(3000L);
        }
        for (i = 0; i < connections_to_make; ++i) {
            testsessions[i].join();
        }
        mc.stopNow = true;
        mc.join();
    }

    Sttest(int num) throws SQLException {
        this.thread_id = num;
    }

    static synchronized void reset_loops(int myloopcount) {
        if (myloopcount == loops) {
            --loops;
        }
    }

    static synchronized void locksync() {
    }

    static synchronized boolean get_countlock() {
        Sttest.locksync();
        return countlock;
    }

    static synchronized boolean set_countlock(boolean state) {
        Sttest.locksync();
        if (state && countlock) {
            return false;
        }
        countlock = state;
        return true;
    }

    static synchronized void changerowcount(int in) {
        rowcount += in;
    }

    static synchronized void changerowcount2zero() {
        rowcount = 0;
    }

    static void initial_data() throws Exception, Throwable {
        int i;
        Connection conn = null;
        int rows = 0;
        conn = Sttest.mystartJBMS();
        int x = Datatypes.get_table_count(conn);
        if (x != -1) {
            rows = x;
        }
        if (conn != null) {
            conn.commit();
            conn.close();
        }
        rowcount = rows;
        if (rows >= targetmin) {
            mode = 1;
            System.out.println("initial data not needed");
            return;
        }
        inserts_to_try = targetmin - rows;
        Sttest[] testthreads = new Sttest[2];
        for (i = 0; i < 2; ++i) {
            testthreads[i] = new Sttest(i);
            testthreads[i].start();
        }
        for (i = 0; i < 2; ++i) {
            testthreads[i].join();
        }
        mode = 1;
        System.out.println("complete initial data");
    }

    @Override
    public void run() {
        Connection conn = null;
        Date d = null;
        try {
            conn = Sttest.mystartJBMS();
        }
        catch (Throwable t) {
            return;
        }
        int ind2 = 0;
        int myloops = loops;
        while (not_finished && loops > 0) {
            myloops = loops;
            if (fatal || mode == 0 && inserts_to_try <= 0) break;
            if (mode == 1 && rowcount > targetmax) {
                System.out.println("hit targetmax with " + rowcount + " " + d);
                d = new Date();
                mode = 2;
                Sttest.reset_loops(myloops);
                insertsize = 1;
                deletesize = 12;
                if (Sttest.set_countlock(true)) {
                    try {
                        Sttest.checkrowcount(conn);
                        MemCheck.showmem();
                        status.updateStatus();
                    }
                    catch (Exception e) {
                        System.out.println("unexpected exception in rowcount");
                        Sttest.set_countlock(false);
                        System.exit(1);
                    }
                    MemCheck.showmem();
                }
                Sttest.set_countlock(false);
                Thread.yield();
            } else if (mode == 1 && rowcount >= targetmax) {
                d = new Date();
                System.out.println("hit targetmax with " + rowcount + " " + d);
                mode = 2;
                insertsize = 1;
                deletesize = 12;
            } else if (mode == 2 && rowcount <= targetmin) {
                d = new Date();
                System.out.println("hit targetmin with " + rowcount + " " + d);
                mode = 1;
                Sttest.reset_loops(myloops);
                insertsize = 8;
                deletesize = 1;
                if (Sttest.set_countlock(true)) {
                    try {
                        Sttest.checkrowcount(conn);
                        MemCheck.showmem();
                        status.updateStatus();
                    }
                    catch (Exception e) {
                        System.out.println("unexpected exception in rowcount");
                        Sttest.set_countlock(false);
                        System.exit(1);
                    }
                    MemCheck.showmem();
                    try {
                        Sttest.compress(conn);
                    }
                    catch (Exception e) {
                        System.out.println("unexpected exception during compress");
                    }
                }
                Sttest.set_countlock(false);
                Thread.yield();
            }
            while (Sttest.get_countlock()) {
                try {
                    Sttest.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    System.out.println("unexpected sleep interruption");
                    break;
                }
            }
            try {
                this.ind = mode == 0 ? 0 : Math.abs(rand.nextInt() % 3);
                switch (this.ind) {
                    case 0: {
                        ind2 = Math.abs(rand.nextInt() % insertsize);
                        int addrows = 0;
                        for (int i = 0; i <= ind2; ++i) {
                            Datatypes.add_one_row(conn, this.thread_id);
                            ++addrows;
                            conn.commit();
                            if (mode == 0) {
                                --inserts_to_try;
                            }
                            Thread.yield();
                            Sttest.changerowcount(1);
                        }
                        System.out.println(addrows + "  Rows inserted");
                        break;
                    }
                    case 1: {
                        ind2 = Math.abs(rand.nextInt() % updatesize);
                        int updaterow = 0;
                        for (int i = 0; i <= ind2; ++i) {
                            Datatypes.update_one_row(conn, this.thread_id);
                            ++updaterow;
                            conn.commit();
                            Thread.yield();
                        }
                        System.out.println(updaterow + "  rows updated");
                        break;
                    }
                    case 2: {
                        ind2 = Math.abs(rand.nextInt() % deletesize);
                        int del_rows = 0;
                        del_rows = Datatypes.delete_some(conn, this.thread_id, ind2 + 1);
                        Thread.yield();
                        Sttest.changerowcount(-1 * del_rows);
                        System.out.println(del_rows + " rows deleted");
                    }
                }
            }
            catch (SQLException se) {
                if (se.getSQLState() == null) {
                    se.printStackTrace();
                }
                if (se.getSQLState().equals("40001")) {
                    System.out.println("t" + this.thread_id + " deadlock op = " + this.ind);
                    continue;
                }
                if (se.getSQLState().equals("40XL1")) {
                    System.out.println("t" + this.thread_id + " timeout op = " + this.ind);
                    continue;
                }
                if (se.getSQLState().equals("23500")) {
                    System.out.println("t" + this.thread_id + " duplicate key violation\n");
                    continue;
                }
                if (se.getSQLState().equals("23505")) {
                    System.out.println("t" + this.thread_id + " duplicate key violation\n");
                    continue;
                }
                System.out.println("t" + this.thread_id + " FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
                fatal = true;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (e.getMessage().equals("java.lang.ThreadDeath")) {
                    System.out.println("caught threaddeath and continuing\n");
                    continue;
                }
                fatal = true;
                e.printStackTrace();
            }
        }
        try {
            conn.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.out.println("Thread finished: " + this.thread_id);
    }

    static synchronized void checkrowcount(Connection conn) throws Exception {
        int x = Datatypes.get_table_count(conn);
        if (x == -1) {
            System.out.println("table count timed out");
        } else {
            System.out.println("rowcount by select: " + x + " client rowcount = " + rowcount);
            Sttest.changerowcount(x - rowcount);
        }
        conn.commit();
    }

    public static Connection mystartJBMS() throws Throwable {
        Connection conn = null;
        if (startByIJ) {
            conn = ij.startJBMS();
        } else {
            try {
                conn = DriverManager.getConnection(dbURL + ";create=false");
                conn.setAutoCommit(false);
                conn.setHoldability(2);
            }
            catch (SQLException se) {
                System.out.println("connect failed  for " + dbURL);
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            }
        }
        return conn;
    }

    static synchronized void compress(Connection conn) throws Exception {
        System.out.println("compressing table");
        boolean autocom = conn.getAutoCommit();
        try {
            conn.setAutoCommit(true);
            CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
            cs.setString(1, "APP");
            cs.setString(2, "DATATYPES");
            cs.setShort(3, (short)1);
            cs.setShort(4, (short)1);
            cs.setShort(5, (short)1);
            cs.execute();
            cs.close();
        }
        catch (SQLException se) {
            System.out.println("compress table: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            se.printStackTrace();
        }
        conn.setAutoCommit(autocom);
    }

    static {
        increase = true;
        not_finished = true;
        targetmax = 100000;
        targetmin = 90000;
        insertsize = 7;
        updatesize = 1;
        deletesize = 1;
        fatal = false;
        rows = 0;
        countlock = false;
        delete_freq = 1;
        locker_id = -1;
        mode = 0;
        count_timer = 0;
        inserts_to_try = 0;
        startByIJ = false;
        dbURL = "jdbc:derby:testDB";
        driver = "org.apache.derby.jdbc.EmbeddedDriver";
        status = null;
    }
}

