/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.services.MarkedLimitInputStream;

public class T_MarkedLimitInputStream
extends T_Generic {
    private static final int TEST_SIZE = 10000;
    private static final int BLOCK_SIZE = 256;

    private static MarkedLimitInputStream setup(byte[] data) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10200);
        DataOutputStream dos = new DataOutputStream(baos);
        T_MarkedLimitInputStream.writeDos(inputStream, dos);
        return T_MarkedLimitInputStream.makeMLIS(baos.toByteArray());
    }

    private static void writeDos(InputStream x, DataOutputStream out) throws Exception {
        boolean isLastBlock = false;
        byte[] b = new byte[256];
        while (!isLastBlock) {
            int len = x.read(b);
            if (len != 256) {
                isLastBlock = true;
                if (len < 0) {
                    len = 0;
                }
            }
            out.writeBoolean(isLastBlock);
            out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                out.writeByte(b[i]);
            }
        }
    }

    private static MarkedLimitInputStream makeMLIS(byte[] b) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(b);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        return new MarkedLimitInputStream(dataInputStream);
    }

    private static boolean readAndCompare(MarkedLimitInputStream mlis, byte[] x) throws Exception {
        int b;
        int i = 0;
        while ((b = mlis.read()) != -1) {
            if (x[i] != (byte)b) {
                System.out.println("Stream and array differ at position " + i);
                return false;
            }
            ++i;
        }
        if (i != x.length) {
            System.out.println("array size and stream size differ");
            return false;
        }
        return true;
    }

    private static boolean readAndCompareChunks(MarkedLimitInputStream mlis, byte[] x) throws Exception {
        int chunkSize = 10;
        byte[] chunk = new byte[chunkSize];
        int c = 0;
        int base = 0;
        while ((c = mlis.read(chunk)) > 0) {
            for (int offset = 0; offset < c; ++offset) {
                if (x[base + offset] == chunk[offset]) continue;
                System.out.println("Stream and array differ at position " + (base + offset));
                System.out.println("Array : x[" + (base + offset) + "] = " + x[base + offset]);
                System.out.println("Stream : chunk[" + offset + "] = " + chunk[offset]);
                return false;
            }
            base += c;
        }
        if (base != x.length) {
            System.out.println("array size ( " + x.length + " ) and stream size ( " + base + " ) differ");
            return false;
        }
        return true;
    }

    private static boolean skipAndCompare(MarkedLimitInputStream mlis, byte[] x, long skipTo) throws Exception {
        long c = mlis.skip(skipTo);
        T_Fail.T_ASSERT(c == skipTo);
        byte[] y = new byte[x.length - (int)c];
        System.arraycopy(x, (int)skipTo, y, 0, x.length - (int)c);
        return T_MarkedLimitInputStream.readAndCompare(mlis, y);
    }

    @Override
    public String getModuleToTestProtocolName() {
        return "internalUtils.MarkedLimitInputStream";
    }

    @Override
    protected void runTests() throws Exception {
        boolean success = true;
        byte[] data = new byte[10000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i & 0xFF);
        }
        MarkedLimitInputStream mlis = T_MarkedLimitInputStream.setup(data);
        if (T_MarkedLimitInputStream.readAndCompare(mlis, data)) {
            this.PASS("test1");
        } else {
            this.FAIL("test1");
            success = false;
        }
        MarkedLimitInputStream mlis2 = T_MarkedLimitInputStream.setup(data);
        if (T_MarkedLimitInputStream.readAndCompareChunks(mlis2, data)) {
            this.PASS("test2");
        } else {
            this.FAIL("test2");
            success = false;
        }
        MarkedLimitInputStream mlis3 = T_MarkedLimitInputStream.setup(data);
        if (T_MarkedLimitInputStream.skipAndCompare(mlis3, data, 5000L)) {
            this.PASS("test3");
        } else {
            this.FAIL("test3");
            success = false;
        }
        MarkedLimitInputStream mlis4 = T_MarkedLimitInputStream.setup(data);
        if (T_MarkedLimitInputStream.skipAndCompare(mlis4, data, 9999L)) {
            this.PASS("test4");
        } else {
            this.FAIL("test4");
            success = false;
        }
        if (!success) {
            throw T_Fail.testFail();
        }
        byte[] data2 = new byte[256];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i & 0xFF);
        }
        MarkedLimitInputStream mlis5 = T_MarkedLimitInputStream.setup(data2);
        if (T_MarkedLimitInputStream.readAndCompare(mlis5, data2)) {
            this.PASS("test5");
        } else {
            this.FAIL("test5");
            success = false;
        }
        if (!success) {
            throw T_Fail.testFail();
        }
    }
}

