/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.optimizer.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.derbyTesting.system.optimizer.StaticValues;
import org.apache.derbyTesting.system.optimizer.utils.TestViews;

public class DataUtils {
    public static void dropObjects(Connection conn, boolean verbose) throws SQLException {
        int i;
        Statement stmt = null;
        if (verbose) {
            System.out.println("Dropping existing Tables and Views...");
        }
        for (i = 0; i < TestViews.dropViews.size(); ++i) {
            try {
                stmt = conn.createStatement();
                stmt.executeUpdate(TestViews.dropViews.get(i));
                continue;
            }
            catch (SQLException sqe) {
                if (sqe.getSQLState().equalsIgnoreCase("X0X05")) continue;
                throw sqe;
            }
        }
        for (i = 1; i <= StaticValues.NUM_OF_TABLES; ++i) {
            try {
                String tableName = StaticValues.TABLE_NAME + i;
                stmt = conn.createStatement();
                stmt.execute(StaticValues.DROP_TABLE + tableName);
                stmt.close();
                continue;
            }
            catch (SQLException sqe) {
                if (sqe.getSQLState().equalsIgnoreCase("42Y55")) continue;
                throw sqe;
            }
        }
    }

    public static void createObjects(Connection conn, boolean verbose) throws SQLException {
        int i;
        Statement stmt = null;
        if (verbose) {
            System.out.println("Creating Tables...");
        }
        for (i = 1; i <= StaticValues.NUM_OF_TABLES; ++i) {
            try {
                String tableName = StaticValues.TABLE_NAME + i;
                if (verbose) {
                    System.out.println(" Creating Table - " + tableName);
                }
                stmt = conn.createStatement();
                stmt.execute(StaticValues.CREATE_TABLE + tableName + StaticValues.TABLE_COLS);
                stmt.close();
                continue;
            }
            catch (SQLException sqe) {
                if (!sqe.getSQLState().equalsIgnoreCase("X0Y32")) {
                    throw sqe;
                }
                System.out.println("Table " + StaticValues.TABLE_NAME + i + " exists");
            }
        }
        if (verbose) {
            System.out.println("Creating Views...");
        }
        for (i = 0; i < TestViews.createViews.size(); ++i) {
            try {
                stmt = conn.createStatement();
                stmt.executeUpdate(TestViews.createViews.get(i));
                continue;
            }
            catch (SQLException sqe) {
                System.out.println("SQLState = " + sqe.getSQLState() + ", " + sqe);
                System.out.println("View statement ==> " + TestViews.createViews.get(i) + " failed");
            }
        }
    }

    public static void insertData(Connection conn, boolean verbose) {
        try {
            String commonString = "String value for the ";
            String valueForString = commonString + "varchar column ";
            String valueForBitData = commonString + "bit data column ";
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            ResultSet rs = null;
            int totalRows = 0;
            for (int i = 1; i <= StaticValues.NUM_OF_TABLES; ++i) {
                int k;
                String tableName = StaticValues.TABLE_NAME + i;
                rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
                while (rs.next()) {
                    totalRows = rs.getInt(1);
                }
                if (totalRows >= StaticValues.NUM_OF_ROWS) {
                    if (!verbose) continue;
                    System.out.println(" InsertData.insert_data() => " + totalRows + " exists in table " + tableName + "...");
                    continue;
                }
                if (totalRows > 0) {
                    block16: {
                        block15: {
                            if (verbose) {
                                System.out.println("Dropping existing indexes from table: " + tableName);
                            }
                            try {
                                stmt.executeUpdate("DROP INDEX " + tableName + "_col4_idx");
                            }
                            catch (SQLException sqe) {
                                if (sqe.getSQLState().equalsIgnoreCase("42X65")) break block15;
                                throw sqe;
                            }
                        }
                        try {
                            stmt.executeUpdate("DROP INDEX " + tableName + "_col7_idx");
                        }
                        catch (SQLException sqe) {
                            if (sqe.getSQLState().equalsIgnoreCase("42X65")) break block16;
                            throw sqe;
                        }
                    }
                    if (verbose) {
                        System.out.println("Rows deleted from " + tableName + "= " + stmt.executeUpdate("DELETE FROM " + tableName));
                    }
                }
                PreparedStatement ps = conn.prepareStatement(StaticValues.INSERT_TABLE + tableName + StaticValues.INSERT_VALUES);
                long start = System.currentTimeMillis();
                for (k = 1; k <= StaticValues.NUM_OF_ROWS; ++k) {
                    ps.setInt(1, k);
                    ps.setString(2, valueForString + "in Table " + StaticValues.TABLE_NAME + i + ": " + k);
                    ps.setString(3, valueForBitData + "in Table " + StaticValues.TABLE_NAME + i + ": " + k);
                    ps.setString(4, StaticValues.TABLE_NAME + i + "_COL4:" + k);
                    ps.setString(5, StaticValues.TABLE_NAME + i + "_COL5:" + k);
                    ps.setString(6, StaticValues.TABLE_NAME + i + "_COL6:" + k);
                    ps.setString(7, StaticValues.TABLE_NAME + i + "_COL7:" + k);
                    ps.setInt(8, k);
                    ps.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                    ps.executeUpdate();
                    if (k % 10000 != 0) continue;
                    conn.commit();
                }
                ps.close();
                conn.commit();
                if (verbose) {
                    System.out.println("Inserted " + (k - 1) + " rows into " + tableName + " in " + (System.currentTimeMillis() - start) + " milliseconds");
                }
                conn.setAutoCommit(true);
                if (verbose) {
                    System.out.println("Creating indexes for table: " + tableName);
                }
                stmt.executeUpdate("CREATE INDEX " + tableName + "_col4_idx on " + tableName + "(col4)");
                stmt.executeUpdate("CREATE INDEX " + tableName + "_col7_idx on " + tableName + "(col7)");
            }
        }
        catch (Exception se) {
            System.out.println(" EXCEPTION:" + se.getMessage());
            System.out.println("Stack Trace :  \n");
            se.printStackTrace();
            return;
        }
    }
}

