/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

class Utils {
    boolean printDebug = false;
    private static final String FS = File.separator;

    Utils() {
    }

    void copyDir(String string, String string2) throws IOException {
        this.DEBUG("copyDir from " + string + " to " + string2);
        this.copyFiles(string, string2);
    }

    void copyFiles(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        if (file.isDirectory()) {
            this.DEBUG("Make dir: " + file2.getAbsolutePath());
            file2.mkdirs();
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = file.getAbsolutePath() + FS + stringArray[i];
                String string4 = file2.getAbsolutePath() + FS + stringArray[i];
                this.copyFiles(string3, string4);
            }
        } else {
            this.copy(file, file2);
        }
    }

    private void copy(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        while ((n = fileInputStream.read()) >= 0) {
            fileOutputStream.write(n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    void writeToFile(String string, String string2) throws IOException {
        this.DEBUG("writeToFile " + string2);
        FileWriter fileWriter = new FileWriter(string2);
        fileWriter.write(string);
        fileWriter.close();
    }

    void mkDirs(String string) {
        File file = new File(string);
        file.mkdirs();
    }

    void DEBUG(String string) {
        if (this.printDebug) {
            System.out.println(string);
        }
    }

    void DEBUG(String string, PrintWriter printWriter) {
        if (this.printDebug) {
            printWriter.println(string);
        }
    }

    void sleep(long l, String string) throws InterruptedException {
        this.DEBUG(string + ": sleep " + l + "ms.");
        Thread.sleep(l);
    }

    String[] toStringArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    String splice(String[] stringArray, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }
}

