/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AuthenticationTest
extends BaseJDBCTestCase {
    private static final String PASSWORD_SUFFIX = "suf2ix";
    private static final String[] USERS = new String[]{"APP", "dan", "kreg", "jeff", "ames", "jerry", "francois", "jamie", "howardR", "\"eVe\"", "\"fred@derby.com\"", "\"123\""};
    private static final String zeus = "\u0396\u0395\u03a5\u03a3";
    private static final String apollo = "\u0391\u09a0\u039f\u039b\u039b\u039a\u0390";
    private static final String BUILTIN_ALGO_PROP = "derby.authentication.builtin.algorithm";
    private static final String BUILTIN_SALT_LENGTH_PROP = "derby.authentication.builtin.saltLength";
    private static final String BUILTIN_ITERATIONS_PROP = "derby.authentication.builtin.iterations";
    private static final String USER_PREFIX = "derby.user.";
    private static final String NO_SUCH_ALGO = "XBCXW";

    public AuthenticationTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("AuthenticationTest");
        baseTestSuite.addTest(AuthenticationTest.baseSuite("AuthenticationTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(AuthenticationTest.baseSuite("AuthenticationTest:client")));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("AuthenticationTest");
        AuthenticationTest authenticationTest = new AuthenticationTest("testConnectShutdownAuthentication");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testUserCasing");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testUserFunctions");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testNotFullAccessUsers");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testUserAccessRoutines");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testChangePasswordAndDatabasePropertiesOnly");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testGreekCharacters");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testSystemShutdown");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testDefaultHashAlgorithm");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        authenticationTest = new AuthenticationTest("testDerby5507PlaintextPassword");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest);
        Properties properties = new Properties();
        properties.setProperty(BUILTIN_ALGO_PROP, "MD5");
        authenticationTest = new AuthenticationTest("testVariousBuiltinAlgorithms");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest, properties);
        authenticationTest = new AuthenticationTest("testNoCollisionsWithConfigurableHash");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest, properties);
        authenticationTest = new AuthenticationTest("testInvalidAlgorithmName");
        AuthenticationTest.setBaseProps(baseTestSuite, (Test)authenticationTest, properties);
        return TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
    }

    protected static void setBaseProps(BaseTestSuite baseTestSuite, Test test) {
        AuthenticationTest.setBaseProps(baseTestSuite, test, null);
    }

    private static void setBaseProps(BaseTestSuite baseTestSuite, Test object, Properties properties) {
        Properties properties2 = new Properties();
        properties2.setProperty("derby.infolog.append", "true");
        properties2.setProperty("derby.debug.true", "AuthenticationTrace");
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        Properties properties3 = new Properties();
        properties3.put("derby.user.system", "admin");
        properties3.put("derby.user.mickey", "mouse");
        object = DatabasePropertyTestSetup.builtinAuthentication(object, USERS, PASSWORD_SUFFIX);
        object = new DatabasePropertyTestSetup((Test)object, properties2, true);
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup((Test)object, properties3));
    }

    protected void setUp() throws Exception {
        this.setDatabaseProperty("derby.database.defaultConnectionMode", null, this.getConnection());
        this.setDatabaseProperty("derby.database.readOnlyAccessUsers", null, this.getConnection());
        this.setDatabaseProperty("derby.database.fullAccessUsers", null, this.getConnection());
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        AuthenticationTest.removeSystemProperty("derby.connection.requireAuthentication");
        AuthenticationTest.removeSystemProperty("derby.user.\u0391\u09a0\u039f\u039b\u039b\u039a\u0390");
        super.tearDown();
    }

    public void testUserCasing() throws SQLException {
        String string;
        int n;
        Object object;
        for (int i = 0; i < USERS.length; ++i) {
            object = USERS[i];
            n = ((String)object).charAt(0) == '\"' ? 1 : 0;
            string = n != 0 ? ((String)object).substring(1, ((String)object).length() - 1) : ((String)object).toUpperCase(Locale.ENGLISH);
            String string2 = USERS[i] + PASSWORD_SUFFIX;
            this.userCasingTest((String)object, string, string2);
            if (n == 0 && string.equals(object)) continue;
        }
        PreparedStatement preparedStatement = this.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_USER_ACCESS(?)");
        object = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_USER_ACCESS(?, ?)");
        this.setDatabaseProperty("derby.database.fullAccessUsers", USERS[0], this.getConnection());
        this.setDatabaseProperty("derby.database.readOnlyAccessUsers", null, this.getConnection());
        this.commit();
        for (n = 1; n < USERS.length; ++n) {
            string = USERS[n];
            boolean bl = string.charAt(0) == '\"';
            String string3 = bl ? string.substring(1, string.length() - 1) : string.toUpperCase(Locale.ENGLISH);
            String string4 = USERS[n] + PASSWORD_SUFFIX;
            this.setDatabaseProperty("derby.database.readOnlyAccessUsers", string, this.getConnection());
            this.commit();
            Connection connection = this.openDefaultConnection(string, string4);
            if (AuthenticationTest.usingEmbedded()) {
                AuthenticationTest.assertTrue((String)(string + ":isReadOnly()"), (boolean)connection.isReadOnly());
            }
            connection.close();
            preparedStatement.setString(1, string3);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
            this.commit();
            this.setDatabaseProperty("derby.database.readOnlyAccessUsers", null, this.getConnection());
            this.commit();
            connection = this.openDefaultConnection(string, string4);
            AuthenticationTest.assertFalse((boolean)connection.isReadOnly());
            connection.close();
            preparedStatement.setString(1, string3);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
            this.commit();
            object.setString(1, string3);
            object.setString(2, "READONLYACCESS");
            object.executeUpdate();
            this.commit();
            connection = this.openDefaultConnection(string, string4);
            if (AuthenticationTest.usingEmbedded()) {
                AuthenticationTest.assertTrue((String)(string + ":isReadOnly()"), (boolean)connection.isReadOnly());
            }
            connection.close();
            preparedStatement.setString(1, string3);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
            this.commit();
        }
    }

    private void userCasingTest(String string, String string2, String string3) throws SQLException {
        this.userCasingTest(string, string2, this.openDefaultConnection(string, string3));
        DataSource dataSource = JDBCDataSource.getDataSource();
        this.userCasingTest(string, string2, dataSource.getConnection(string, string3));
        JDBCDataSource.setBeanProperty(dataSource, "user", string);
        JDBCDataSource.setBeanProperty(dataSource, "password", string3);
        this.userCasingTest(string, string2, dataSource.getConnection());
    }

    private void userCasingTest(String string, String string2, Connection connection) throws SQLException {
        this.assertNormalUserName(string2, connection);
        AuthenticationTest.assertEquals((String)"DatabaseMetaData.getUserName()", (String)string, (String)connection.getMetaData().getUserName());
        Statement statement = connection.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_SET_USER_ACCESS(CURRENT_USER, 'FULLACCESS')");
        statement.close();
        JDBC.cleanup(connection);
    }

    private void assertNormalUserName(String string, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("VALUES CURRENT_USER"), string);
        JDBC.assertSingleValueResultSet(statement.executeQuery("VALUES SESSION_USER"), string);
        JDBC.assertSingleValueResultSet(statement.executeQuery("VALUES {fn user()}"), string);
        statement.close();
    }

    public void testConnectShutdownAuthentication() throws SQLException {
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        this.assertConnectionFail(string);
        this.assertConnectionOK(string, "system", "admin");
        this.assertConnectionWOUPOK(string, "system", "admin");
        this.assertConnectionOK(string, "dan", "dansuf2ix");
        this.assertConnectionWOUPOK(string, "dan", "dansuf2ix");
        this.assertShutdownOK(string, "dan", "dansuf2ix");
        this.assertConnectionOK(string, "system", "admin");
        this.assertShutdownWOUPOK(string, "dan", "dansuf2ix");
        this.assertConnectionOK(string, "system", "admin");
        this.assertShutdownOK(string, "system", "admin");
        this.assertConnectionOK(string, "system", "admin");
        this.assertShutdownWOUPOK(string, "system", "admin");
        this.assertConnectionOK(string, "system", "admin");
        this.assertShutdownUsingConnAttrsOK(string, "APP", "APPsuf2ix");
        Connection connection = this.openDefaultConnection("dan", "dansuf2ix");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.user.dan')");
        resultSet.next();
        AuthenticationTest.assertNotSame((Object)"dansuf2ix", (Object)resultSet.getString(1));
        connection.commit();
        connection.close();
        connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.fullAccessUsers", "APP,system,nomen,francois,jeff", connection);
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "NoAccess", connection);
        connection.commit();
        connection.close();
        this.assertConnectionOK(string, "system", "admin");
        this.assertConnectionFail("08004", string, "nomen", "nescio");
        this.assertConnectionWOUPFail("08004", string, "nomen", "nescio");
        this.assertShutdownOK(string, "francois", "francoissuf2ix");
        this.assertConnectionOK(string, "system", "admin");
        this.assertShutdownWOUPOK(string, "APP", "APPsuf2ix");
        this.assertConnectionOK(string, "jeff", "jeffsuf2ix");
        this.assertConnectionFail("08004", string, "dan", "dansuf2ix");
        this.assertShutdownFail("08004", string, "dan", "dansuf2ix");
        connection = this.openDefaultConnection("francois", "francoissuf2ix");
        this.setDatabaseProperty("derby.database.fullAccessUsers", "jeff,dan,francois,jamie", connection);
        connection.commit();
        connection.close();
        this.assertConnectionOK(string, "dan", "dansuf2ix");
        this.assertShutdownOK(string, "dan", "dansuf2ix");
        this.assertConnectionOK(string, "dan", "dansuf2ix");
        this.assertShutdownFail("08004", string, "APP", "APPsuf2ix");
        connection = this.openDefaultConnection("francois", "francoissuf2ix");
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "NoAccess", connection);
        this.setDatabaseProperty("derby.database.fullAccessUsers", "APP,jeff,dan,francois,jamie", connection);
        connection.commit();
        connection.close();
        this.assertConnectionFail("08004", string, "badUser", "badPwd");
        this.assertConnectionFail("08004", string, "badUser", "badPwd");
        this.assertConnectionFail("08004", string, "system", "admin");
        this.assertConnectionFail("08004", string, "dan", "badPwd");
        this.assertConnectionFail("08004", string, "jamie", "dansuf2ix");
        this.assertShutdownFail("08004", string, "system", "admin");
        this.assertShutdownFail("08004", string, "badUser", "badPwd");
        this.assertShutdownFail("08004", string, "dan", "badPwd");
        this.assertShutdownFail("08004", string, "badUser", "dansuf2ix");
        this.assertSystemShutdownOK("", "badUser", "dansuf2ix");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownOK("", "dan", "jeffsuf2ix");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownOK("", "APP", "POO");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownOK("", "dan", "dansuf2ix");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownOK("", "APP", "APPsuf2ix");
        connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "fullAccess", connection);
        this.setDatabaseProperty("derby.connection.requireAuthentication", "false", connection);
        connection.commit();
        statement.close();
        connection.close();
    }

    public void testUserFunctions() throws SQLException {
        Connection connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.fullAccessUsers", "francois,jeff,ames,jerry,jamie,dan,system", connection);
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "NoAccess", connection);
        connection.commit();
        Statement statement = connection.createStatement();
        AuthenticationTest.assertUpdateCount(statement, 0, "create table APP.t1(c1 varchar(30) check (UPPER(c1) <> 'JAMIE'))");
        AuthenticationTest.assertUpdateCount(statement, 1, "insert into APP.t1 values USER");
        connection.commit();
        statement.close();
        connection.close();
        this.useUserValue(1, "jeff", "insert into APP.t1 values CURRENT_USER");
        this.useUserValue(1, "ames", "insert into APP.t1 values SESSION_USER");
        this.useUserValue(1, "jerry", "insert into APP.t1 values {fn user()}");
        this.assertUserValue(new String[]{"DAN", "JEFF", "AMES", "JERRY"}, "dan", "select * from APP.t1");
        this.useUserValue(1, "dan", "update APP.t1 set c1 = 'edward' where c1 = USER");
        this.assertUserValue(new String[]{"JEFF"}, "jeff", "select * from APP.t1 where c1 like CURRENT_USER");
        this.useUserValue(1, "ames", "update APP.t1 set c1 = 'sema' where SESSION_USER = c1");
        this.useUserValue(1, "jerry", "update APP.t1 set c1 = 'yrrej' where c1 like {fn user()}");
        this.assertUserValue(new String[]{"edward", "JEFF", "sema", "yrrej"}, "dan", "select * from APP.t1");
        this.useUserValue(4, "francois", "update APP.T1 set c1 = USER");
        this.assertUserValue(new String[]{"FRANCOIS", "FRANCOIS", "FRANCOIS", "FRANCOIS"}, "dan", "select * from APP.t1");
        connection = this.openDefaultConnection("jamie", "jamiesuf2ix");
        statement = connection.createStatement();
        try {
            statement.execute("insert into APP.t1 values CURRENT_USER");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("23513", sQLException);
        }
        statement.close();
        connection.rollback();
        connection.close();
        connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "fullAccess", connection);
        this.setDatabaseProperty("derby.connection.requireAuthentication", "false", connection);
        statement = connection.createStatement();
        AuthenticationTest.assertUpdateCount(statement, 0, "drop table APP.t1");
        connection.commit();
        statement.close();
        connection.close();
    }

    public void testChangePasswordAndDatabasePropertiesOnly() throws SQLException {
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        Connection connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.fullAccessUsers", "dan,jeff,system", connection);
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "NoAccess", connection);
        this.setDatabaseProperty("derby.database.requireAuthentication", "true", connection);
        connection.commit();
        this.assertConnectionOK(string, "system", "admin");
        this.assertConnectionFail("08004", string, "system", "otherSysPwd");
        this.assertConnectionOK(string, "jeff", "jeffsuf2ix");
        this.assertConnectionFail("08004", string, "jeff", "otherPwd");
        this.setDatabaseProperty("derby.user.jeff", "otherPwd", connection);
        connection.commit();
        this.assertConnectionOK(string, "jeff", "otherPwd");
        this.setDatabaseProperty("derby.database.propertiesOnly", "true", connection);
        connection.commit();
        this.assertConnectionFail("08004", string, "system", "admin");
        this.setDatabaseProperty("derby.database.propertiesOnly", "false", connection);
        connection.commit();
        connection.close();
        this.assertConnectionOK(string, "system", "admin");
        AuthenticationTest.setSystemProperty("derby.user.system", "thrdSysPwd");
        this.assertConnectionOK(string, "system", "thrdSysPwd");
        AuthenticationTest.setSystemProperty("derby.user.system", "admin");
        connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "fullAccess", connection);
        this.setDatabaseProperty("derby.connection.requireAuthentication", "false", connection);
        this.setDatabaseProperty("derby.database.propertiesOnly", "false", connection);
        connection.commit();
        connection.close();
    }

    public void testNotFullAccessUsers() throws SQLException {
        Connection connection = this.openDefaultConnection("dan", "dansuf2ix");
        try {
            this.setDatabaseProperty("derby.database.fullAccessUsers", "dan,jamie,dan", connection);
            AuthenticationTest.fail((String)"Duplicate allowed on derby.database.fullAccessUsers");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("4250D", sQLException);
        }
        try {
            this.setDatabaseProperty("derby.database.fullAccessUsers", "dan,jamie,DaN", connection);
            AuthenticationTest.fail((String)"Duplicate allowed on derby.database.fullAccessUsers");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("4250D", sQLException);
        }
        try {
            this.setDatabaseProperty("derby.database.fullAccessUsers", "dan,jamie,\"DAN\"", connection);
            AuthenticationTest.fail((String)"Duplicate allowed on derby.database.fullAccessUsers");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("4250D", sQLException);
        }
        try {
            this.setDatabaseProperty("derby.database.fullAccessUsers", "\"dan\",jamie,\"dan\"", connection);
            AuthenticationTest.fail((String)"Duplicate allowed on derby.database.fullAccessUsers");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("4250D", sQLException);
        }
        try {
            this.setDatabaseProperty("derby.database.readOnlyAccessUsers", "dan,jamie,dan", connection);
            AuthenticationTest.fail((String)"Duplicate allowed on derby.database.readOnlyAccessUsers");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("4250D", sQLException);
        }
        try {
            this.setDatabaseProperty("derby.database.readOnlyAccessUsers", "dan,jamie,DaN", connection);
            AuthenticationTest.fail((String)"Duplicate allowed on derby.database.readOnlyAccessUsers");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("4250D", sQLException);
        }
        try {
            this.setDatabaseProperty("derby.database.readOnlyAccessUsers", "dan,jamie,\"DAN\"", connection);
            AuthenticationTest.fail((String)"Duplicate allowed on derby.database.readOnlyAccessUsers");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("4250D", sQLException);
        }
        try {
            this.setDatabaseProperty("derby.database.readOnlyAccessUsers", "\"dan\",jamie,\"dan\"", connection);
            AuthenticationTest.fail((String)"Duplicate allowed on derby.database.readOnlyAccessUsers");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("4250D", sQLException);
        }
        this.setDatabaseProperty("derby.database.fullAccessUsers", "dan,jamie,system", connection);
        this.assertFailSetDatabaseProperty("derby.database.readOnlyAccessUsers", "jamie", connection);
        this.setDatabaseProperty("derby.database.readOnlyAccessUsers", "ames,mickey", connection);
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "NoAccess", connection);
        this.setDatabaseProperty("derby.database.requireAuthentication", "true", connection);
        connection.commit();
        PreparedStatement preparedStatement = connection.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_USER_ACCESS(?)");
        preparedStatement.setString(1, "JAMIE");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "DAN");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "SYSTEM");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "AMES");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
        preparedStatement.setString(1, "MICKEY");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
        preparedStatement.setString(1, "hagrid");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "NOACCESS");
        connection.commit();
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_USER_ACCESS(?, ?)");
        callableStatement.setString(1, "AMES");
        callableStatement.setString(2, "FULLACCESS");
        callableStatement.execute();
        preparedStatement.setString(1, "AMES");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "MICKEY");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
        preparedStatement.setString(1, "JAMIE");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "DAN");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "SYSTEM");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        callableStatement.setString(1, "AMES");
        callableStatement.setString(2, "READONLYACCESS");
        callableStatement.execute();
        preparedStatement.setString(1, "AMES");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
        preparedStatement.setString(1, "MICKEY");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
        preparedStatement.setString(1, "JAMIE");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "DAN");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "SYSTEM");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        callableStatement.setString(1, "BOND");
        callableStatement.setString(2, "FULLACCESS");
        callableStatement.execute();
        callableStatement.setString(1, "JAMES");
        callableStatement.setString(2, "READONLYACCESS");
        callableStatement.execute();
        connection.commit();
        preparedStatement.setString(1, "BOND");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        preparedStatement.setString(1, "JAMES");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
        connection.commit();
        callableStatement.setString(1, "BOND");
        callableStatement.setString(2, null);
        callableStatement.execute();
        callableStatement.setString(1, "JAMES");
        callableStatement.setString(2, null);
        callableStatement.execute();
        connection.commit();
        preparedStatement.setString(1, "BOND");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "NOACCESS");
        preparedStatement.setString(1, "JAMES");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "NOACCESS");
        connection.commit();
        preparedStatement.close();
        callableStatement.close();
        Statement statement = connection.createStatement();
        AuthenticationTest.assertUpdateCount(statement, 0, "create table APP.t1(c1 varchar(30) check (UPPER(c1) <> 'JAMIE'))");
        AuthenticationTest.assertUpdateCount(statement, 1, "insert into APP.t1 values USER");
        connection.commit();
        statement.close();
        connection.close();
        connection = this.openDefaultConnection("system", "admin");
        statement = connection.createStatement();
        AuthenticationTest.assertUpdateCount(statement, 1, "update APP.t1 set c1 = USER");
        connection.commit();
        statement.close();
        connection.close();
        this.assertUserValue(new String[]{"SYSTEM"}, "ames", "select * from APP.t1");
        connection = this.openDefaultConnection("ames", "amessuf2ix");
        if (AuthenticationTest.usingEmbedded()) {
            AuthenticationTest.assertTrue((boolean)connection.isReadOnly());
        }
        statement = connection.createStatement();
        AuthenticationTest.assertStatementError("25502", statement, "delete from APP.t1 where c1 = 'SYSTEM'");
        AuthenticationTest.assertStatementError("25502", statement, "insert into APP.t1 values USER");
        AuthenticationTest.assertStatementError("25502", statement, "update APP.t1 set c1 = USER where c1 = 'SYSTEM'");
        AuthenticationTest.assertStatementError("25503", statement, "create table APP.t2 (c1 int)");
        connection.commit();
        statement.close();
        connection.close();
        connection = this.openDefaultConnection("mickey", "mouse");
        if (AuthenticationTest.usingEmbedded()) {
            AuthenticationTest.assertTrue((boolean)connection.isReadOnly());
        }
        statement = connection.createStatement();
        AuthenticationTest.assertStatementError("25502", statement, "delete from APP.t1 where c1 = 'SYSTEM'");
        connection.rollback();
        connection.close();
        connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "fullAccess", connection);
        this.setDatabaseProperty("derby.connection.requireAuthentication", "false", connection);
        statement = connection.createStatement();
        AuthenticationTest.assertUpdateCount(statement, 0, "drop table APP.t1");
        connection.commit();
        statement.close();
        connection.close();
    }

    public void testUserAccessRoutines() throws SQLException {
        Connection connection = this.openDefaultConnection("dan", "dansuf2ix");
        PreparedStatement preparedStatement = connection.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_USER_ACCESS(?)");
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_USER_ACCESS(?, ?)");
        callableStatement.setString(1, "DAN");
        callableStatement.setString(2, "FULLACCESS");
        callableStatement.execute();
        callableStatement.setString(1, null);
        callableStatement.setString(2, "FULLACCESS");
        AuthenticationTest.assertStatementError("28502", callableStatement);
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "READONLYACCESS", connection);
        connection.commit();
        preparedStatement.setString(1, "TONYBLAIR");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "READONLYACCESS");
        connection.commit();
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "FULLACCESS", connection);
        connection.commit();
        preparedStatement.setString(1, "TONYBLAIR");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        connection.commit();
        this.setDatabaseProperty("derby.database.defaultConnectionMode", null, connection);
        connection.commit();
        preparedStatement.setString(1, "TONYBLAIR");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "FULLACCESS");
        connection.commit();
        connection.close();
    }

    public void testGreekCharacters() throws SQLException {
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        AuthenticationTest.setSystemProperty("derby.user.\u0391\u09a0\u039f\u039b\u039b\u039a\u0390", zeus);
        Connection connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.user.\u0396\u0395\u03a5\u03a3", apollo, connection);
        this.setDatabaseProperty("derby.database.fullAccessUsers", "dan,system,APP\u0396\u0395\u03a5\u03a3,\u0391\u09a0\u039f\u039b\u039b\u039a\u0390", connection);
        connection.commit();
        connection.close();
        this.assertConnectionOK(string, zeus, apollo);
        this.assertConnectionFail("08004", string, apollo, apollo);
        this.assertShutdownOK(string, zeus, apollo);
        this.assertConnectionOK(string, apollo, zeus);
        this.assertShutdownFail("08004", string, zeus, zeus);
        this.assertShutdownOK(string, apollo, zeus);
        this.assertConnectionOK(string, apollo, zeus);
        this.assertShutdownUsingSetShutdownOK(string, "APP", "APPsuf2ix");
        connection = this.openDefaultConnection(zeus, apollo);
        Statement statement = connection.createStatement();
        AuthenticationTest.assertUpdateCount(statement, 0, "create table APP.t1(c1 varchar(30))");
        AuthenticationTest.assertUpdateCount(statement, 1, "insert into APP.t1 values USER");
        connection.commit();
        this.assertUserValue(new String[]{zeus}, zeus, apollo, "select * from APP.t1 where c1 like CURRENT_USER");
        statement.close();
        connection.close();
        connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "fullAccess", connection);
        this.setDatabaseProperty("derby.connection.requireAuthentication", "false", connection);
        statement = connection.createStatement();
        if (AuthenticationTest.usingEmbedded()) {
            AuthenticationTest.assertUpdateCount(statement, 0, "drop table APP.t1");
        }
        connection.commit();
        statement.close();
        connection.close();
    }

    public void testSystemShutdown() throws SQLException {
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        this.assertConnectionOK(string, "system", "admin");
        this.assertConnectionOK(string, "dan", "dansuf2ix");
        AuthenticationTest.setSystemProperty("derby.connection.requireAuthentication", "true");
        this.assertShutdownUsingSetShutdownOK(string, "APP", "APPsuf2ix");
        this.assertConnectionOK(string, "system", "admin");
        this.assertConnectionOK(string, "dan", "dansuf2ix");
        this.assertSystemShutdownOK("", "badUser", "dansuf2ix");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownFail("08004", "", "badUser", "dansuf2ix");
        this.assertSystemShutdownFail("08004", "", "dan", "jeffsuf2ix");
        this.assertSystemShutdownFail("08004", "", "APP", "POO");
        this.assertSystemShutdownOK("", "system", "admin");
        Connection connection = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("derby.database.defaultConnectionMode", "fullAccess", connection);
        this.setDatabaseProperty("derby.connection.requireAuthentication", "false", connection);
        AuthenticationTest.setSystemProperty("derby.connection.requireAuthentication", "false");
        connection.commit();
        connection.close();
        this.openDefaultConnection("system", "admin").close();
        this.assertShutdownUsingSetShutdownOK(string, "APP", "APPsuf2ix");
        this.assertSystemShutdownOK("", "system", "admin");
        this.openDefaultConnection("system", "admin").close();
    }

    public void testDefaultHashAlgorithm() throws SQLException {
        String string = this.supportsAlgorithm("SHA-256") ? "SHA-256" : "SHA-1";
        AuthenticationTest.assertEquals((String)string, (String)this.getDatabaseProperty(BUILTIN_ALGO_PROP));
    }

    private boolean supportsAlgorithm(String string) {
        try {
            MessageDigest.getInstance(string);
            return true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }

    public void testVariousBuiltinAlgorithms() throws SQLException {
        this.setAutoCommit(true);
        String[] stringArray = new String[]{null, "MD5", "SHA-1", "SHA-256", "SHA-512"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string != null && !this.supportsAlgorithm(string)) continue;
            this.testVariousBuiltinAlgorithms(string, true);
            this.testVariousBuiltinAlgorithms(string, false);
        }
    }

    private void testVariousBuiltinAlgorithms(String string, boolean bl) throws SQLException {
        this.setDatabaseProperty(BUILTIN_ALGO_PROP, string);
        if (bl) {
            this.setDatabaseProperty(BUILTIN_SALT_LENGTH_PROP, null);
            this.setDatabaseProperty(BUILTIN_ITERATIONS_PROP, null);
        } else {
            this.setDatabaseProperty(BUILTIN_SALT_LENGTH_PROP, "0");
            this.setDatabaseProperty(BUILTIN_ITERATIONS_PROP, "1");
        }
        for (int i = 0; i < USERS.length; ++i) {
            String string2 = USERS[i];
            String string3 = string2 + PASSWORD_SUFFIX;
            String string4 = USER_PREFIX + string2;
            this.setDatabaseProperty(string4, string3);
            String string5 = this.getDatabaseProperty(string4);
            if (string == null) {
                AuthenticationTest.assertTrue((String)("Expected old authentication scheme: " + string5), (boolean)string5.startsWith("3b60"));
            } else {
                if (bl) {
                    AuthenticationTest.assertTrue((String)("Expected configurable hash scheme with key stretching: " + string5), (boolean)string5.startsWith("3b62"));
                } else {
                    AuthenticationTest.assertTrue((String)("Expected configurable hash scheme: " + string5), (boolean)string5.startsWith("3b61"));
                }
                AuthenticationTest.assertTrue((String)("Expected algorithm " + string + ":" + string5), (boolean)string5.endsWith(":" + string));
            }
            this.openDefaultConnection(string2, string3).close();
        }
    }

    public void testNoCollisionsWithConfigurableHash() throws SQLException {
        AuthenticationTest.assertNotNull((String)"hash algorithm not set up", (Object)this.getDatabaseProperty(BUILTIN_ALGO_PROP));
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < USERS.length; ++i) {
            String string = USERS[i];
            String string2 = USER_PREFIX + string;
            AuthenticationTest.assertNotNull((String)("missing user " + string), (Object)this.getDatabaseProperty(string2));
            char[] cArray = new char[]{'t', 'e', 's', 't', 'i', 'n', 'g'};
            for (int j = 0; j < 100; ++j) {
                String string3 = new String(cArray);
                this.setDatabaseProperty(string2, string3);
                AuthenticationTest.assertTrue((String)"collision detected", (boolean)hashSet.add(this.getDatabaseProperty(string2)));
                int n = cArray.length / 2;
                cArray[n] = (char)(cArray[n] + '\u0001');
            }
        }
    }

    public void testInvalidAlgorithmName() throws SQLException {
        this.setDatabaseProperty(BUILTIN_ALGO_PROP, "not-a-valid-name");
        for (int i = 0; i < USERS.length; ++i) {
            try {
                this.setDatabaseProperty(USER_PREFIX + USERS[i], "abcdef");
                AuthenticationTest.fail();
                continue;
            }
            catch (SQLException sQLException) {
                AuthenticationTest.assertSQLState(NO_SUCH_ALGO, sQLException);
            }
        }
    }

    public void testDerby5507PlaintextPassword() throws SQLException {
        String string = "derby.user.mickey";
        String string2 = "M0u$e";
        this.setDatabaseProperty(string, string2);
        String string3 = this.getDatabaseProperty(string);
        AuthenticationTest.assertFalse((String)"Password stored in plaintext", (boolean)string3.equals(string2));
    }

    protected void assertFailSetDatabaseProperty(String string, String string2, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        AuthenticationTest.assertStatementError("4250C", callableStatement);
        callableStatement.close();
    }

    protected void setDatabaseProperty(String string, String string2, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.execute();
        callableStatement.close();
    }

    void setDatabaseProperty(String string, String string2) throws SQLException {
        this.setDatabaseProperty(string, string2, this.getConnection());
    }

    protected void useUserValue(int n, String string, String string2) throws SQLException {
        Connection connection = this.openDefaultConnection(string, string + PASSWORD_SUFFIX);
        Statement statement = connection.createStatement();
        AuthenticationTest.assertUpdateCount(statement, n, string2);
        connection.commit();
        statement.close();
        connection.close();
    }

    protected void assertUserValue(String[] stringArray, String string, String string2, String string3) throws SQLException {
        Connection connection = this.openDefaultConnection(string, string2);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string3);
        int n = 0;
        while (resultSet.next()) {
            AuthenticationTest.assertEquals((String)stringArray[n], (String)resultSet.getString(1));
            ++n;
        }
        AuthenticationTest.assertEquals((int)stringArray.length, (int)n);
        connection.commit();
        statement.close();
        connection.close();
    }

    protected void assertUserValue(String[] stringArray, String string, String string2) throws SQLException {
        this.assertUserValue(stringArray, string, string + PASSWORD_SUFFIX, string2);
    }

    protected void assertConnectionOK(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        Connection connection = dataSource.getConnection(string2, string3);
        AuthenticationTest.assertNotNull((Object)connection);
        connection.close();
    }

    protected void assertConnectionWOUPOK(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "user", string2);
        JDBCDataSource.setBeanProperty(dataSource, "password", string3);
        Connection connection = dataSource.getConnection();
        AuthenticationTest.assertNotNull((Object)connection);
        connection.close();
    }

    protected void assertConnectionFail(String string, String string2, String string3, String string4) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string2);
        try {
            dataSource.getConnection(string3, string4);
            AuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    protected void assertConnectionWOUPFail(String string, String string2, String string3, String string4) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string2);
        JDBCDataSource.setBeanProperty(dataSource, "user", string3);
        JDBCDataSource.setBeanProperty(dataSource, "password", string4);
        try {
            dataSource.getConnection();
            AuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    protected void assertShutdownUsingSetShutdownOK(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection(string2, string3);
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    protected void assertShutdownUsingConnAttrsOK(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "shutdown=true");
        try {
            dataSource.getConnection(string2, string3);
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    protected void assertShutdownWOUPOK(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(dataSource, "user", string2);
        JDBCDataSource.setBeanProperty(dataSource, "password", string3);
        try {
            dataSource.getConnection();
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    protected void assertShutdownFail(String string, String string2, String string3, String string4) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string2);
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection(string3, string4);
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    protected void assertShutdownOK(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection(string2, string3);
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    protected void assertShutdownWOUPFail(String string, String string2, String string3, String string4) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string2);
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(dataSource, "user", string3);
        JDBCDataSource.setBeanProperty(dataSource, "password", string4);
        try {
            dataSource.getConnection();
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    protected void assertSystemShutdownOK(String string, String string2, String string3) throws SQLException {
        DataSource dataSource;
        if (AuthenticationTest.usingEmbedded()) {
            dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.clearStringBeanProperty(dataSource, "databaseName");
        } else {
            dataSource = JDBCDataSource.getDataSource(string);
        }
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection(string2, string3);
            AuthenticationTest.fail((String)"expected system shutdown resulting in XJ015 error");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("XJ015", sQLException);
        }
    }

    protected void assertSystemShutdownFail(String string, String string2, String string3, String string4) throws SQLException {
        DataSource dataSource;
        if (AuthenticationTest.usingEmbedded()) {
            dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.clearStringBeanProperty(dataSource, "databaseName");
        } else {
            dataSource = JDBCDataSource.getDataSource(string2);
        }
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(dataSource, "user", string3);
        JDBCDataSource.setBeanProperty(dataSource, "password", string4);
        try {
            dataSource.getConnection();
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    public void assertConnectionFail(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        if (AuthenticationTest.usingDerbyNetClient()) {
            JDBCDataSource.setBeanProperty(dataSource, "user", "APP");
        } else {
            JDBCDataSource.clearStringBeanProperty(dataSource, "user");
        }
        JDBCDataSource.clearStringBeanProperty(dataSource, "password");
        try {
            dataSource.getConnection();
            AuthenticationTest.fail((String)"expected connection to fail");
        }
        catch (SQLException sQLException) {
            AuthenticationTest.assertSQLState("08004", sQLException);
        }
    }
}

