/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.shared.common.reference.ModuleUtil;
import org.apache.derbyTesting.functionTests.harness.BackgroundStreamDrainer;
import org.apache.derbyTesting.functionTests.harness.HandleResult;
import org.apache.derbyTesting.functionTests.harness.NetServer;
import org.apache.derbyTesting.functionTests.harness.RunTest;
import org.apache.derbyTesting.functionTests.harness.Sed;
import org.apache.derbyTesting.functionTests.harness.SimpleDiff;

public class FileCompare {
    private String testBase;
    private String framework;
    private String jvmName;
    private String jvmString;
    private String serverJvm;
    private int iminor;
    private boolean searchJdk12 = false;
    private boolean searchJdk13 = false;
    private boolean searchJdk14 = false;
    private int driverVersionMajor = 0;
    private int driverVersionMinor = 0;
    private boolean searchFrame;
    private boolean searchDriverVersion;
    private InputStream master = null;
    private boolean verbose = Boolean.getBoolean("verbose");

    public boolean exec(String string, File file, PrintWriter printWriter, String string2, String string3, String string4, int n, boolean bl, boolean bl2, String string5, String string6, String string7) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        this.testBase = string2;
        this.framework = string3;
        this.jvmName = string4;
        this.iminor = n;
        this.jvmString = string4;
        this.serverJvm = string7;
        StringBuffer stringBuffer = new StringBuffer();
        if (string3.startsWith("DerbyNet")) {
            try {
                object2 = Class.forName(NetServer.getDriverName(string3));
                object = ((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.driverVersionMajor = (Integer)((Class)object2).getMethod("getMajorVersion", new Class[0]).invoke(object, new Object[0]);
                this.driverVersionMinor = (Integer)((Class)object2).getMethod("getMinorVersion", new Class[0]).invoke(object, new Object[0]);
                if (string3.startsWith("DerbyNet")) {
                    this.searchDriverVersion = true;
                }
            }
            catch (Exception exception) {
                System.out.println("Cannot determine driver version:" + exception);
                this.driverVersionMinor = 0;
                this.driverVersionMajor = 0;
                this.searchDriverVersion = false;
            }
        }
        object2 = "";
        if (string5 != null && string5.length() > 0) {
            object2 = string5;
        } else {
            InputStream inputStream;
            Object object3;
            object = "/org/apache/derby/info/engine/info.properties";
            if (JVMInfo.isModuleAware()) {
                object3 = ModuleUtil.derbyModule((String)"org.apache.derby.engine");
                inputStream = ((Module)object3).getResourceAsStream((String)object);
            } else {
                object3 = FileCompare.class;
                inputStream = ((Class)object3).getResourceAsStream((String)object);
            }
            object3 = new Properties();
            ((Properties)object3).load(inputStream);
            inputStream.close();
            String string8 = ((Properties)object3).getProperty("derby.product.file");
            if (string8 != null) {
                if (string8.startsWith("derby") && string8.endsWith(".jar")) {
                    string5 = "product_master";
                    object2 = "product_master";
                } else {
                    object2 = "master";
                }
            } else {
                object2 = "master";
            }
        }
        object = "";
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        if (string3 != null && string3.length() > 0) {
            this.searchFrame = true;
            object = string3;
        }
        if (string4 != null && string4.length() > 0 & !string4.equals("currentjvm")) {
            bl5 = true;
            if (this.searchFrame) {
                bl4 = true;
            }
            if (n >= 2) {
                this.jvmString = "jdk12";
            }
            if (n >= 2) {
                this.searchJdk12 = true;
            }
            if (n >= 3) {
                this.searchJdk13 = true;
            }
            if (n >= 4) {
                this.searchJdk14 = true;
            }
            object = (String)object + string4;
        }
        if (this.searchFrame || bl5 || bl4) {
            bl3 = false;
        }
        stringBuffer.append((String)object2);
        if (((String)object).length() > 0) {
            stringBuffer.append((String)object + "/");
        }
        stringBuffer.append(this.testBase + ".out");
        String string9 = stringBuffer.toString();
        InputStream inputStream = null;
        if (inputStream == null) {
            this.searchCanondir((String)object2);
            inputStream = this.master;
        }
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        if (NetServer.isClientConnection(string3)) {
            try {
                Sed sed = new Sed();
                File file2 = new File(file, this.testBase + ".tmpmstr");
                sed.execJCC(inputStream, file2);
                inputStream = new FileInputStream(file2);
            }
            catch (ClassFormatError classFormatError) {
                System.out.println("SED Error: " + classFormatError.getMessage());
            }
        } else {
            int n2;
            File file3 = new File(file, this.testBase + ".tmpmstr");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            PrintWriter printWriter2 = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file3), 10000), true);
            while ((n2 = bufferedReader.read()) != -1) {
                printWriter2.write(n2);
            }
            printWriter2.flush();
            printWriter2.close();
            inputStream = new FileInputStream(file3);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream));
        if (bl2) {
            return this.doSysDiff(inputStream, this.testBase, string, file, printWriter);
        }
        return this.doDiff2(bufferedReader, bufferedReader2, printWriter);
    }

    public boolean doDiff2(BufferedReader bufferedReader, BufferedReader bufferedReader2, PrintWriter printWriter) throws IOException {
        return new SimpleDiff().doWork(bufferedReader2, bufferedReader, printWriter);
    }

    public boolean doSysDiff(InputStream inputStream, String string, String string2, File file, PrintWriter printWriter) throws IOException {
        String string3;
        File file2;
        block3: {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            file2 = new File(new File(file, string + ".master").getCanonicalPath());
            PrintWriter printWriter2 = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file2.getPath()), 10000), true);
            String string4 = "";
            while ((string4 = bufferedReader.readLine()) != null) {
                printWriter2.println(string4);
            }
            printWriter2.close();
            printWriter2 = null;
            bufferedReader = null;
            string3 = "0";
            Process process = null;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("diff ");
                stringBuffer.append(file2.getCanonicalPath());
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                String string5 = stringBuffer.toString();
                process = Runtime.getRuntime().exec(string5);
                BackgroundStreamDrainer backgroundStreamDrainer = new BackgroundStreamDrainer(process.getInputStream(), null);
                BackgroundStreamDrainer backgroundStreamDrainer2 = new BackgroundStreamDrainer(process.getErrorStream(), null);
                process.waitFor();
                String string6 = HandleResult.handleResult(process.exitValue(), backgroundStreamDrainer.getData(), backgroundStreamDrainer2.getData(), printWriter);
                string3 = string6.substring(string6.lastIndexOf(44) + 1);
                process.destroy();
                process = null;
            }
            catch (Throwable throwable) {
                System.out.println("Process exception: " + throwable);
                if (process == null) break block3;
                process.destroy();
                process = null;
            }
        }
        file2.delete();
        return !string3.equals("0");
    }

    public boolean doDiff(BufferedReader bufferedReader, BufferedReader bufferedReader2, PrintWriter printWriter) throws IOException {
        String string;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        while ((string = bufferedReader.readLine()) != null) {
            ++n;
            string = string.trim();
            String string2 = bufferedReader2.readLine();
            if (string2 == null) continue;
            if (!string.equals(string2 = string2.trim())) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                while (stringTokenizer2.hasMoreTokens()) {
                    stringBuffer2.append(stringTokenizer2.nextToken());
                }
                if (stringBuffer.toString().equals(stringBuffer2.toString())) {
                    bl = false;
                    continue;
                }
                if (string.startsWith("-----") && string.endsWith("-----")) {
                    if (!string2.startsWith("-----") || !string2.endsWith("-----")) continue;
                    bl = false;
                    continue;
                }
                bl = true;
                ++n2;
                System.out.println("Diff occurred at line: " + n);
                printWriter.println("Diff occurred  at line: " + n);
                printWriter.flush();
                break;
            }
            bl = false;
        }
        bufferedReader.close();
        bufferedReader2.close();
        return bl;
    }

    private void searchCanondir(String string) {
        String string2 = string + "/";
        if (this.master == null && this.searchFrame) {
            this.searchFramework(string2);
        }
        if (this.master == null) {
            this.searchJvm(string2);
        }
        if (this.master == null && this.searchDriverVersion) {
            this.searchDriverVersion(string2);
        }
        if (this.master == null) {
            this.getmaster(string2);
        }
        if (this.master == null && string != "master") {
            this.searchCanondir("master");
        }
    }

    private void searchJvm(String string) {
        int n;
        String string2;
        if ((this.jvmName.startsWith("j9") || this.serverJvm != null && this.serverJvm.startsWith("j9")) && !this.jvmName.startsWith("j9dee")) {
            if (this.jvmName.startsWith("j9_foundation")) {
                string2 = string + "j9_foundation/";
                if (this.master == null && this.searchDriverVersion) {
                    this.searchDriverVersion(string2);
                }
                if (this.master == null) {
                    this.getmaster(string2);
                }
            } else {
                string2 = string + this.jvmName + "/";
                if (!this.jvmName.equals("j9_13") && this.iminor > 1) {
                    for (n = this.iminor; n > 1; --n) {
                        if (this.master != null) continue;
                        string2 = string + "j9_2" + n + "/";
                        this.getmaster(string2);
                    }
                }
                if (this.master == null) {
                    string2 = string + "j9_13/";
                }
            }
            if (this.master == null && this.searchDriverVersion) {
                this.searchDriverVersion(string2);
            }
            if (this.master == null) {
                this.getmaster(string2);
            }
        }
        for (n = this.iminor; n >= 2; --n) {
            if (this.jvmName.startsWith("ibm")) {
                string2 = string + "ibm1" + n + "/";
                if (this.master == null && this.searchDriverVersion) {
                    this.searchDriverVersion(string2);
                }
                if (this.master == null) {
                    this.getmaster(string2);
                }
            }
            string2 = string + "jdk1" + n + "/";
            if (this.master == null && this.searchDriverVersion) {
                this.searchDriverVersion(string2);
            }
            if (this.master != null) continue;
            this.getmaster(string2);
        }
    }

    private void searchFramework(String string) {
        String string2 = string + this.framework + "/";
        if (this.master == null) {
            this.searchJvm(string2);
        }
        if (this.master == null && this.searchDriverVersion) {
            this.searchDriverVersion(string2);
        }
        if (this.master == null) {
            this.getmaster(string2);
        }
    }

    private void searchDriverVersion(String string) {
        for (int i = this.driverVersionMajor * 10 + this.driverVersionMinor; i >= 10; --i) {
            String string2 = string + "ver" + i / 10 + "." + i % 10 + "/";
            if (this.master != null) continue;
            this.getmaster(string2);
        }
    }

    private void getmaster(String string) {
        String string2 = string + this.testBase + ".out";
        this.master = RunTest.loadTestResource(string2);
        if (this.master != null && this.verbose) {
            System.out.println("MasterFileName = " + string2);
        }
    }
}

