/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.optional.lucene.DerbyLuceneDir;
import org.apache.lucene.store.IndexOutput;

class DerbyIndexOutput
extends IndexOutput {
    private StorageFile _file;
    private DerbyLuceneDir _parentDir;
    private StorageRandomAccessFile _sraf;
    private final CRC32 _crc = new CRC32();

    DerbyIndexOutput(StorageFile file, DerbyLuceneDir parentDir) throws IOException {
        this._file = file;
        this._parentDir = parentDir;
        this._sraf = this._file.getRandomAccessFile("rw");
    }

    public void close() throws IOException {
        this._sraf.close();
        this._parentDir.removeIndexOutput(this._file.getName());
        this._file = null;
        this._parentDir = null;
        this._sraf = null;
    }

    public long getFilePointer() {
        try {
            return this._sraf.getFilePointer();
        }
        catch (IOException ioe) {
            throw this.wrap(ioe);
        }
    }

    @Deprecated
    public void seek(long pos) throws IOException {
        this._sraf.seek(pos);
    }

    public void flush() throws IOException {
        this._sraf.sync();
    }

    public long length() throws IOException {
        return this._sraf.length();
    }

    public long getChecksum() {
        return this._crc.getValue();
    }

    public void writeByte(byte b) throws IOException {
        this._sraf.writeByte((int)b);
        this._crc.update(b);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this._sraf.write(b, offset, length);
        this._crc.update(b, offset, length);
    }

    private RuntimeException wrap(Throwable t) {
        return new RuntimeException(t.getMessage(), t);
    }
}

