/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.json;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.optional.api.SimpleJsonUtils;
import org.apache.derby.optional.utils.ToolUtilities;
import org.json.simple.JSONArray;

public class SimpleJsonTool
implements OptionalTool {
    private FunctionDescriptor[] _functionDescriptors = new FunctionDescriptor[]{new FunctionDescriptor("toJSON", "create function toJSON\n(\n\tqueryString varchar( 32672 ),\n\tqueryArgs varchar( 32672 ) ...\n)\nreturns JSONArray\n\nlanguage java parameter style derby reads sql data\nexternal name 'org.apache.derby.optional.json.SimpleJsonTool.toJSON'\n"), new FunctionDescriptor("readArrayFromString", "create function readArrayFromString( document varchar( 32672 ) )\nreturns JSONArray\nlanguage java parameter style java contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonUtils.readArrayFromString'\n"), new FunctionDescriptor("readArrayFromFile", "create function readArrayFromFile\n( fileName varchar( 32672 ), characterSetName varchar( 100 ) )\nreturns JSONArray\nlanguage java parameter style java contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonUtils.readArrayFromFile'\n"), new FunctionDescriptor("readArrayFromURL", "create function readArrayFromURL\n( urlString varchar( 32672 ), characterSetName varchar( 100 ) )\nreturns JSONArray\nlanguage java parameter style java contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonUtils.readArrayFromURL'\n"), new FunctionDescriptor("arrayToClob", "create function arrayToClob( jsonDocument JSONArray ) returns clob\nlanguage java parameter style java no sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonUtils.arrayToClob'")};

    public void loadTool(String ... configurationParameters) throws SQLException {
        if (configurationParameters != null && configurationParameters.length != 0) {
            throw this.wrap(LocalizedResource.getMessage((String)"OT_BadLoadUnloadArgs", (Object[])new Object[0]));
        }
        Connection derbyConn = SimpleJsonTool.getDerbyConnection();
        this.createUDT(derbyConn);
        this.createFunctions(derbyConn);
        boolean sqlAuthorizationEnabled = ToolUtilities.sqlAuthorizationEnabled(derbyConn);
        if (sqlAuthorizationEnabled) {
            this.grantPermissions(derbyConn);
        }
    }

    private void grantPermissions(Connection conn) throws SQLException {
        this.executeDDL(conn, "grant usage on type JSONArray to public");
        for (FunctionDescriptor desc : this._functionDescriptors) {
            this.executeDDL(conn, "grant execute on function " + desc.functionName + " to public");
        }
    }

    public void unloadTool(String ... configurationParameters) throws SQLException {
        if (configurationParameters != null && configurationParameters.length != 0) {
            throw this.wrap(LocalizedResource.getMessage((String)"OT_BadLoadUnloadArgs", (Object[])new Object[0]));
        }
        Connection derbyConn = SimpleJsonTool.getDerbyConnection();
        this.dropFunctions(derbyConn);
        this.dropUDT(derbyConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray toJSON(String queryString, String ... queryArgs) throws SQLException {
        try (PreparedStatement ps = null;){
            Connection conn = SimpleJsonTool.getDerbyConnection();
            ps = conn.prepareStatement(queryString);
            if (queryArgs != null) {
                for (int i = 0; i < queryArgs.length; ++i) {
                    ps.setString(i + 1, queryArgs[i]);
                }
            }
            ResultSet rs = ps.executeQuery();
            JSONArray jSONArray = SimpleJsonUtils.toJSON(rs);
            return jSONArray;
        }
    }

    private void createUDT(Connection derbyConn) throws SQLException {
        String createString = "create type JSONArray external name 'org.json.simple.JSONArray' language java";
        this.executeDDL(derbyConn, createString);
    }

    private void dropUDT(Connection derbyConn) throws SQLException {
        String createString = "drop type JSONArray restrict";
        this.executeDDL(derbyConn, createString);
    }

    private void createFunctions(Connection derbyConn) throws SQLException {
        for (FunctionDescriptor desc : this._functionDescriptors) {
            this.executeDDL(derbyConn, desc.creationDDL);
        }
    }

    private void dropFunctions(Connection derbyConn) throws SQLException {
        for (FunctionDescriptor desc : this._functionDescriptors) {
            String dropString = "drop function " + desc.functionName;
            this.executeDDL(derbyConn, dropString);
        }
    }

    private void executeDDL(Connection conn, String text) throws SQLException {
        PreparedStatement ddl = this.prepareStatement(conn, text);
        ddl.execute();
        ddl.close();
    }

    private PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        return conn.prepareStatement(text);
    }

    private SQLException wrap(String errorMessage) {
        String sqlState = "XJ001.U".substring(0, 5);
        return new SQLException(errorMessage, sqlState);
    }

    private static Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    public static final class FunctionDescriptor {
        public final String functionName;
        public final String creationDDL;

        public FunctionDescriptor(String functionName, String creationDDL) {
            this.functionName = functionName;
            this.creationDDL = creationDDL;
        }
    }
}

