/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.SqlException;

public class Section {
    private int sectionNumber;
    private String packageName;
    private String serverCursorName;
    private int resultSetHoldability_;
    private byte[] PKGNAMCBytes;
    private boolean isGenerated;
    private Agent agent_;
    String serverCursorNameForPositionedUpdate_ = null;
    private transient String clientCursorName_;

    Section(Agent agent, String name, int sectionNumber, String cursorName, int resultSetHoldability) {
        this.init(agent, name, sectionNumber, cursorName, resultSetHoldability, false);
    }

    public Section(Agent agent, String name, int sectionNumber, String cursorName, int resultSetHoldability, boolean isGenerated) {
        this.init(agent, name, sectionNumber, cursorName, resultSetHoldability, isGenerated);
    }

    private void init(Agent agent, String name, int sectionNumber, String cursorName, int resultSetHoldability, boolean isGenerated) {
        this.packageName = name;
        this.sectionNumber = sectionNumber;
        this.serverCursorName = cursorName;
        this.resultSetHoldability_ = resultSetHoldability;
        this.agent_ = agent;
        this.isGenerated = isGenerated;
        if (!isGenerated) {
            if (this.resultSetHoldability_ == 1) {
                this.PKGNAMCBytes = this.agent_.sectionManager_.holdPKGNAMCBytes;
            } else if (this.resultSetHoldability_ == 2) {
                this.PKGNAMCBytes = this.agent_.sectionManager_.noHoldPKGNAMCBytes;
            }
        }
    }

    public void setPKGNAMCBytes(byte[] b) {
        if (this.isGenerated) {
            this.PKGNAMCBytes = (byte[])b.clone();
        } else {
            this.agent_.sectionManager_.setPKGNAMCBytes(b, this.resultSetHoldability_);
        }
    }

    public byte[] getPKGNAMCBytes() {
        return this.PKGNAMCBytes != null ? (byte[])this.PKGNAMCBytes.clone() : null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getSectionNumber() {
        return this.sectionNumber;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getServerCursorName() {
        return this.serverCursorName;
    }

    public String getServerCursorNameForPositionedUpdate() {
        return this.serverCursorNameForPositionedUpdate_;
    }

    public String getClientCursorName() {
        return this.clientCursorName_;
    }

    public void setClientCursorName(String clientCursorName) {
        this.clientCursorName_ = clientCursorName;
    }

    void free() {
        if (this.resultSetHoldability_ != -1) {
            this.agent_.sectionManager_.freeSection(this, this.resultSetHoldability_);
        }
    }

    public boolean isReservedPositionedUpdate() {
        return false;
    }

    public int getStaticStatementType() {
        return 0;
    }

    public Section getPositionedUpdateSection() throws SqlException {
        return this.agent_.sectionManager_.getPositionedUpdateSection(this);
    }

    public void setCursorName(String name) {
        this.serverCursorName = name;
    }
}

