/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_RawStoreRow {
    DataValueDescriptor[] col;

    public T_RawStoreRow(int numberOfColumns) {
        this.col = new DataValueDescriptor[numberOfColumns];
    }

    public T_RawStoreRow(String data) {
        this(1);
        this.col[0] = data == null ? new SQLChar() : new SQLChar(data);
    }

    public DataValueDescriptor[] getRow() {
        return this.col;
    }

    public void setColumn(int columnId, String data) {
        this.col[columnId] = data == null ? new SQLChar() : new SQLChar(data);
    }

    public void setColumn(int columnId, int stringLen, String data) {
        this.col[columnId] = new SQLChar(T_Util.getStringFromData(data, stringLen));
    }

    public void setColumn(int columnId, DataValueDescriptor data) {
        this.col[columnId] = data;
    }

    public DataValueDescriptor getStorableColumn(int columnId) {
        return this.col[columnId];
    }

    public DataValueDescriptor getColumn(int columnId) {
        return this.col[columnId];
    }

    public void setStorableColumn(int columnId, DataValueDescriptor value) {
        this.col[columnId] = value;
    }

    public int nColumns() {
        return this.col.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.nColumns(); ++i) {
            sb.append(this.col[i].toString());
            if (i >= this.nColumns() - 1) continue;
            sb.append(",");
        }
        sb.append("");
        return sb.toString();
    }
}

