/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestNullOutputStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public abstract class BaseJDBCTestCase
extends BaseTestCase {
    private static final boolean ORDERED = true;
    private static final boolean UNORDERED = false;
    private Connection conn;
    private List<Statement> statements;
    private List<Connection> connections;

    public BaseJDBCTestCase(String name) {
        super(name);
    }

    public Connection getConnection() throws SQLException {
        if (this.conn != null) {
            if (!this.conn.isClosed()) {
                return this.conn;
            }
            this.conn = null;
        }
        this.conn = this.openDefaultConnection();
        return this.conn;
    }

    protected void initializeConnection(Connection conn) throws SQLException {
    }

    public Statement createStatement() throws SQLException {
        Statement s = this.getConnection().createStatement();
        this.addStatement(s);
        return s;
    }

    private void addStatement(Statement s) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(s);
    }

    private void addConnection(Connection c) {
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        }
        this.connections.add(c);
    }

    public void closeStatement(Statement s) throws SQLException {
        s.close();
        if (this.statements != null) {
            this.statements.remove(s);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement s = this.getConnection().createStatement(resultSetType, resultSetConcurrency);
        this.addStatement(s);
        return s;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, autoGeneratedKeys);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, columnIndexes);
        this.addStatement(ps);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql, columnNames);
        this.addStatement(ps);
        return ps;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cs = this.getConnection().prepareCall(sql);
        this.addStatement(cs);
        return cs;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement cs = this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
        this.addStatement(cs);
        return cs;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement cs = this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.addStatement(cs);
        return cs;
    }

    public void setAutoCommit(boolean commit) throws SQLException {
        this.getConnection().setAutoCommit(commit);
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    protected void runBareOverridable() throws Throwable {
        super.runBare();
    }

    @Override
    public final void runBare() throws Throwable {
        this.runBareOverridable();
        BaseJDBCTestCase.assertNull((String)"Connection should be null by now. Missing call to super.tearDown()?", (Object)this.conn);
    }

    protected void tearDown() throws Exception {
        if (this.statements != null) {
            for (Statement s : this.statements) {
                s.close();
            }
            this.statements = null;
        }
        if (this.connections != null) {
            for (Connection c : this.connections) {
                JDBC.cleanup(c);
            }
            this.connections = null;
        }
        this.conn = null;
    }

    public Connection openDefaultConnection() throws SQLException {
        Connection conn = this.getTestConfiguration().openDefaultConnection();
        this.addConnection(conn);
        this.initializeConnection(conn);
        return conn;
    }

    public Connection openDefaultConnection(TestConfiguration tc) throws SQLException {
        Connection conn = tc.openDefaultConnection();
        this.addConnection(conn);
        this.initializeConnection(conn);
        return conn;
    }

    public Connection openDefaultConnection(String user, String password) throws SQLException {
        Connection conn = this.getTestConfiguration().openDefaultConnection(user, password);
        this.addConnection(conn);
        this.initializeConnection(conn);
        return conn;
    }

    public Connection openUserConnection(String user) throws SQLException {
        return this.openDefaultConnection(user, this.getTestConfiguration().getPassword(user));
    }

    public Connection openConnection(String databaseName) throws SQLException {
        Connection conn = this.getTestConfiguration().openConnection(databaseName);
        this.addConnection(conn);
        this.initializeConnection(conn);
        return conn;
    }

    public int runScript(InputStream script, String encoding) throws UnsupportedEncodingException, SQLException {
        TestNullOutputStream sink = new TestNullOutputStream();
        return ij.runScript((Connection)this.getConnection(), (InputStream)script, (String)encoding, (OutputStream)sink, (String)encoding);
    }

    public int runScript(String resource, String encoding) throws UnsupportedEncodingException, SQLException, PrivilegedActionException, IOException {
        URL sql = BaseJDBCTestCase.getTestResource(resource);
        BaseJDBCTestCase.assertNotNull((String)("SQL script missing: " + resource), (Object)sql);
        InputStream sqlIn = BaseJDBCTestCase.openTestResource(sql);
        Connection conn = this.getConnection();
        int numErrors = this.runScript(sqlIn, encoding);
        sqlIn.close();
        if (!conn.isClosed() && !conn.getAutoCommit()) {
            conn.commit();
        }
        return numErrors;
    }

    public int runSQLCommands(String sqlCommands) throws UnsupportedEncodingException, SQLException {
        byte[] raw = sqlCommands.getBytes("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(raw);
        return this.runScript(in, "UTF-8");
    }

    public static boolean usingEmbedded() {
        return TestConfiguration.getCurrent().getJDBCClient().isEmbedded();
    }

    public static boolean usingDerbyNetClient() {
        return TestConfiguration.getCurrent().getJDBCClient().isDerbyNetClient();
    }

    public static boolean usingDB2Client() {
        return TestConfiguration.getCurrent().getJDBCClient().isDB2Client();
    }

    public String getDatabaseProperty(String propertyName) throws SQLException {
        PreparedStatement ps = this.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(?)");
        ps.setString(1, propertyName);
        ResultSet rs = ps.executeQuery();
        rs.next();
        String val = rs.getString(1);
        rs.close();
        this.closeStatement(ps);
        return val;
    }

    public static void assertEquals(Blob b1, Blob b2) throws IOException, SQLException {
        if (b1 == null || b2 == null) {
            BaseJDBCTestCase.assertNull((String)"Blob b2 is null, b1 is not", (Object)b1);
            BaseJDBCTestCase.assertNull((String)"Blob b1 is null, b2 is not", (Object)b2);
            return;
        }
        BaseJDBCTestCase.assertEquals((String)"Blobs have different lengths", (long)b1.length(), (long)b2.length());
        InputStream is1 = b1.getBinaryStream();
        InputStream is2 = b2.getBinaryStream();
        if (is1 == null || is2 == null) {
            BaseJDBCTestCase.assertNull((String)"Blob b2 has null-stream, blob b1 doesn't", (Object)is1);
            BaseJDBCTestCase.assertNull((String)"Blob b1 has null-stream, blob b2 doesn't", (Object)is2);
            return;
        }
        is1 = new BufferedInputStream(is1);
        is2 = new BufferedInputStream(is2);
        long index = 1L;
        int by1 = is1.read();
        int by2 = is2.read();
        do {
            if (by1 != by2) {
                BaseJDBCTestCase.assertEquals((String)("Blobs differ at index " + index), (int)by1, (int)by2);
            }
            ++index;
            by1 = is1.read();
            by2 = is2.read();
        } while (by1 != -1 || by2 != -1);
        is1.close();
        is2.close();
    }

    public static void assertEquals(Clob c1, Clob c2) throws IOException, SQLException {
        if (c1 == null || c2 == null) {
            BaseJDBCTestCase.assertNull((String)"Clob c2 is null, c1 is not", (Object)c1);
            BaseJDBCTestCase.assertNull((String)"Clob c1 is null, c2 is not", (Object)c2);
            return;
        }
        BaseJDBCTestCase.assertEquals((String)"Clobs have different lengths", (long)c1.length(), (long)c2.length());
        Reader r1 = c1.getCharacterStream();
        BaseJDBCTestCase.assertNotNull((Object)r1);
        Reader r2 = c2.getCharacterStream();
        BaseJDBCTestCase.assertNotNull((Object)r2);
        r1 = new BufferedReader(r1);
        r2 = new BufferedReader(r2);
        long index = 1L;
        int ch1 = r1.read();
        int ch2 = r2.read();
        do {
            if (ch1 != ch2) {
                BaseJDBCTestCase.assertEquals((String)("Clobs differ at index " + index), (int)ch1, (int)ch2);
            }
            ++index;
            ch1 = r1.read();
            ch2 = r2.read();
        } while (ch1 != -1 || ch2 != -1);
        r1.close();
        r2.close();
    }

    public static void assertEquals(String msg, Time t1, Time t2) {
        if (null == t1 && null == t2) {
            return;
        }
        BaseJDBCTestCase.assertNotNull((String)msg, (Object)t1);
        BaseJDBCTestCase.assertNotNull((String)msg, (Object)t2);
        BaseJDBCTestCase.assertEquals((String)msg, (String)t1.toString(), (String)t2.toString());
    }

    public static void assertSQLState(String message, String expected, SQLException exception) {
        BaseJDBCTestCase.assertNotNull((String)"Exception cannot be null when asserting on SQLState", (Object)exception);
        try {
            String state = exception.getSQLState();
            if (state != null) {
                BaseJDBCTestCase.assertTrue((String)"The exception's SQL state must be five characters long", (state.length() == 5 ? 1 : 0) != 0);
            }
            if (expected != null) {
                BaseJDBCTestCase.assertTrue((String)"The expected SQL state must be five characters long", (expected.length() == 5 ? 1 : 0) != 0);
            }
            BaseJDBCTestCase.assertEquals((String)message, (String)expected, (String)state);
        }
        catch (AssertionFailedError e) {
            e.initCause((Throwable)exception);
            if (BaseJDBCTestCase.usingDB2Client()) {
                String msg = exception.getMessage();
                if (!msg.substring(msg.lastIndexOf(":") + 1).trim().equals(expected)) {
                    throw e;
                }
            }
            if ((exception = exception.getNextException()) != null) {
                BaseJDBCTestCase.assertSQLState(message, expected, exception);
            }
            throw e;
        }
    }

    public static void assertWarning(Connection conn, String expected) throws SQLException {
        SQLWarning firstWarning = conn.getWarnings();
        BaseJDBCTestCase.assertNotNull((Object)firstWarning);
        for (SQLWarning warning = firstWarning; warning != null; warning = warning.getNextWarning()) {
            if (!expected.equals(warning.getSQLState())) continue;
            return;
        }
        BaseJDBCTestCase.fail((String)("Expected to see a SQLWarning with the SQLState " + expected));
    }

    public static void assertSQLState(String expected, SQLException exception) {
        BaseJDBCTestCase.assertSQLState("Unexpected SQL state.", expected, exception);
    }

    public static void assertErrorCode(int expected, SQLException exception) {
        BaseJDBCTestCase.assertNotNull((String)"Exception should not be null", (Object)exception);
        int actual = exception.getErrorCode();
        if (actual != expected) {
            BaseJDBCTestCase.fail("Expected error code " + expected + ", got " + actual, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCompileError(String sqlState, String sql) {
        try {
            PreparedStatement pSt = this.prepareStatement(sql);
            if (BaseJDBCTestCase.usingDB2Client()) {
                try {
                    pSt.execute();
                }
                finally {
                    pSt.close();
                }
            }
            BaseJDBCTestCase.fail((String)("expected compile error: " + sqlState));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public void assertCheckTable(String table) throws SQLException {
        PreparedStatement ps = this.prepareStatement("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE(?, ?)");
        ps.setString(1, this.getTestConfiguration().getUserName());
        ps.setString(2, table);
        ResultSet rs = ps.executeQuery();
        JDBC.assertSingleValueResultSet(rs, "1");
        ps.close();
    }

    protected void assertTableRowCount(String table, int rowCount) throws SQLException {
        this.assertEscapedTableRowCount(JDBC.escape(table), rowCount);
    }

    private void assertEscapedTableRowCount(String escapedTableName, int rowCount) throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM " + escapedTableName);
        rs.next();
        BaseJDBCTestCase.assertEquals((String)(escapedTableName + " row count:"), (int)rowCount, (int)rs.getInt(1));
        rs.close();
        s.close();
    }

    protected final void emptyStatementCache() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CALL SYSCS_UTIL.SYSCS_EMPTY_STATEMENT_CACHE()");
        this.closeStatement(s);
    }

    public final void dropTable(String tableName) throws SQLException {
        BaseJDBCTestCase.dropTable(this.getConnection(), tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(Connection conn, String tableName) throws SQLException {
        String dropSQL = "DROP TABLE " + tableName;
        try (Statement statement = conn.createStatement();){
            statement.executeUpdate(dropSQL);
        }
    }

    public final void dropView(String viewName) throws SQLException {
        BaseJDBCTestCase.dropView(this.getConnection(), viewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropView(Connection conn, String viewName) throws SQLException {
        String dropSQL = "DROP VIEW " + viewName;
        try (Statement statement = conn.createStatement();){
            statement.executeUpdate(dropSQL);
        }
    }

    public static void assertStatementError(String[] sqlStates, Statement st, String query) {
        BaseJDBCTestCase.assertStatementErrorMinion(sqlStates, true, st, query);
    }

    public static void assertStatementErrorUnordered(String[] sqlStates, Statement st, String query) {
        BaseJDBCTestCase.assertStatementErrorMinion(sqlStates, false, st, query);
    }

    private static void assertStatementErrorMinion(String[] sqlStates, boolean orderedStates, Statement st, String query) {
        ArrayList<String> statesBag = null;
        if (!orderedStates) {
            statesBag = new ArrayList<String>(Arrays.asList(sqlStates));
        }
        try {
            boolean haveRS = st.execute(query);
            BaseJDBCTestCase.fetchAndDiscardAllResults(st, haveRS);
            Object errorMsg = "Expected error(s) '";
            for (int i = 0; i < sqlStates.length; ++i) {
                errorMsg = (String)errorMsg + " " + sqlStates[i];
            }
            errorMsg = (String)errorMsg + "' but no error was thrown.";
            BaseJDBCTestCase.fail((String)errorMsg);
        }
        catch (SQLException se) {
            int count = 0;
            do {
                if (orderedStates) {
                    BaseJDBCTestCase.assertSQLState(sqlStates[count], se);
                    continue;
                }
                String state = se.getSQLState();
                BaseJDBCTestCase.assertTrue((String)("Unexpected state: " + state), (boolean)statesBag.remove(state));
                BaseJDBCTestCase.assertSQLState(state, se);
            } while ((se = se.getNextException()) != null && ++count < sqlStates.length);
            BaseJDBCTestCase.assertEquals((String)("Got " + count + " exceptions. Expected at least" + sqlStates.length), (int)count, (int)sqlStates.length);
        }
    }

    public static void assertStatementError(String sqlState, Statement st, String query) {
        BaseJDBCTestCase.assertStatementError(new String[]{sqlState}, st, query);
    }

    public static void assertCommitError(String sqlState, Connection c) {
        try {
            c.commit();
            BaseJDBCTestCase.fail();
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState(sqlState, e);
        }
    }

    public static void assertStatementError(String sqlState, int errorCode, Statement st, String query) {
        try {
            boolean haveRS = st.execute(query);
            BaseJDBCTestCase.fetchAndDiscardAllResults(st, haveRS);
            BaseJDBCTestCase.fail((String)("Expected error '" + sqlState + "' but no error was thrown."));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
            BaseJDBCTestCase.assertErrorCode(errorCode, se);
        }
    }

    public static void assertPreparedStatementError(String sqlState, PreparedStatement ps) {
        try {
            boolean haveRS = ps.execute();
            BaseJDBCTestCase.fetchAndDiscardAllResults(ps, haveRS);
            BaseJDBCTestCase.fail((String)("Expected error '" + sqlState + "' but no error was thrown."));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public static void assertStatementError(String sqlState, PreparedStatement pSt) {
        try {
            boolean haveRS = pSt.execute();
            BaseJDBCTestCase.fetchAndDiscardAllResults(pSt, haveRS);
            BaseJDBCTestCase.fail((String)("Expected error '" + sqlState + "' but no error was thrown."));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public void assertCallError(String expectedSE, String callSQL) throws SQLException {
        try {
            CallableStatement cs = this.prepareCall(callSQL);
            cs.execute();
            BaseJDBCTestCase.fail((String)"FAIL - SQL expected to throw exception");
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(expectedSE, se);
        }
    }

    public static void assertNextError(String sqlState, ResultSet rs) {
        try {
            rs.next();
            BaseJDBCTestCase.fail((String)"Expected error on next()");
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public static void assertGetIntError(int position, String sqlState, ResultSet rs) {
        try {
            rs.getInt(position);
            BaseJDBCTestCase.fail((String)("Expected exception " + sqlState));
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
        }
    }

    public static void assertUpdateCount(Statement st, int expectedRC, String sql) throws SQLException {
        BaseJDBCTestCase.assertEquals((String)"Update count does not match:", (int)expectedRC, (int)st.executeUpdate(sql));
    }

    public static void assertUpdateCount(PreparedStatement pSt, int expectedRC) throws SQLException {
        BaseJDBCTestCase.assertEquals((String)"Update count does not match:", (int)expectedRC, (int)pSt.executeUpdate());
    }

    public SQLException getLastSQLException(SQLException sqle) {
        SQLException current = sqle;
        for (SQLException next = sqle.getNextException(); next != null; next = next.getNextException()) {
            current = next;
        }
        return current;
    }

    private static void fetchAndDiscardAllResults(Statement st, boolean haveRS) throws SQLException {
        Object rs = null;
        while (haveRS || st.getUpdateCount() != -1) {
            if (haveRS) {
                JDBC.assertDrainResults(st.getResultSet(), -1);
            }
            haveRS = st.getMoreResults();
        }
    }

    public static void assertSQLExceptionEquals(SQLException se1, SQLException se2) {
        BaseJDBCTestCase.assertNotNull((String)"Passed-in SQLException se1 cannot be null", (Object)se1);
        BaseJDBCTestCase.assertNotNull((String)"Passed-in SQLException se2 cannot be null", (Object)se2);
        BaseJDBCTestCase.assertEquals((String)"SQLException class types are different", (String)se1.getClass().getName(), (String)se2.getClass().getName());
        BaseJDBCTestCase.assertEquals((String)"Detailed messages of the SQLException's are different", (String)se1.getMessage(), (String)se2.getMessage());
        Throwable se1Cause = se1.getCause();
        Throwable se2Cause = se2.getCause();
        if (se1Cause == null) {
            BaseJDBCTestCase.assertNull((Object)se2Cause);
        } else {
            BaseJDBCTestCase.assertThrowableEquals(se1Cause, se2Cause);
        }
        if (se1.getNextException() == null) {
            BaseJDBCTestCase.assertNull((Object)se2.getNextException());
        } else {
            BaseJDBCTestCase.assertSQLExceptionEquals(se1.getNextException(), se2.getNextException());
        }
    }

    public static void assertEquivalentDataType(int expectedType, int type) {
        if (expectedType == type) {
            return;
        }
        if (expectedType == 3 && type == 2) {
            return;
        }
        if (expectedType == 2 && type == 3) {
            return;
        }
        if (expectedType == 8 && type == 6) {
            return;
        }
        if (expectedType == 6 && type == 8) {
            return;
        }
        BaseJDBCTestCase.fail((String)("types:" + expectedType + " and " + type + " are not equivalent"));
    }

    public static int getClientTransactionID(Connection conn) throws SQLException {
        try {
            Method m = conn.getClass().getMethod("getTransactionID", new Class[0]);
            return (Integer)m.invoke((Object)conn, new Object[0]);
        }
        catch (Exception e) {
            SQLException se = new SQLException(e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    public static void checkEstimatedRowCount(Connection conn, double expectedCount) throws SQLException {
        if (!(conn instanceof EmbedConnection)) {
            return;
        }
        EmbedConnection econn = (EmbedConnection)conn;
        LanguageConnectionContext lcc = (LanguageConnectionContext)BaseJDBCTestCase.getLanguageConnectionContext((Connection)econn);
        RunTimeStatistics rts = lcc.getRunTimeStatisticsObject();
        BaseJDBCTestCase.assertNotNull((String)" RuntimeStatistics is null. Did you call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)?", (Object)rts);
        BaseJDBCTestCase.assertEquals((long)((long)expectedCount), (long)((long)rts.getEstimatedRowCount()));
    }

    protected void checkAllConsistency(Connection conn) throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select schemaname, tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename) from sys.systables a,  sys.sysschemas b where a.schemaid = b.schemaid");
        int table_count = 0;
        while (rs.next()) {
            ++table_count;
            if (rs.getInt(3) == 1) continue;
            BaseJDBCTestCase.assertEquals((String)("Bad return from consistency check of " + rs.getString(1) + "." + rs.getString(2)), (int)1, (int)rs.getInt(3));
        }
        BaseJDBCTestCase.assertTrue((String)("Something wrong with consistency check query, found only " + table_count + " tables."), (table_count >= 5 ? 1 : 0) != 0);
        rs.close();
        s.close();
        conn.commit();
    }

    protected static void dumpRs(ResultSet s, PrintStream out) throws SQLException {
        if (s == null) {
            out.println("<NULL>");
            return;
        }
        ResultSetMetaData rsmd = s.getMetaData();
        int numCols = rsmd.getColumnCount();
        if (numCols <= 0) {
            out.println("(no columns!)");
            return;
        }
        StringBuilder heading = new StringBuilder("\t ");
        StringBuilder underline = new StringBuilder("\t ");
        for (int i = 1; i <= numCols; ++i) {
            if (i > 1) {
                heading.append(",");
                underline.append(" ");
            }
            int len = heading.length();
            heading.append(rsmd.getColumnLabel(i));
            for (int j = len = heading.length() - len; j > 0; --j) {
                underline.append("-");
            }
        }
        out.println(heading.toString());
        out.println(underline.toString());
        StringBuilder row = new StringBuilder();
        while (s.next()) {
            row.append("\t{");
            for (int i = 1; i <= numCols; ++i) {
                if (i > 1) {
                    row.append(",");
                }
                row.append(s.getString(i));
            }
            row.append("}\n");
        }
        out.println(row.toString());
        s.close();
    }

    public static void dumpRs(ResultSet s) throws SQLException {
        BaseJDBCTestCase.dumpRs(s, System.out);
    }

    protected void goodStatement(Connection conn, String command) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, command);
        ps.execute();
        ps.close();
    }

    protected void goodUpdate(Connection conn, String update, int expectedRowCount) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, update);
        int actualRowCount = ps.executeUpdate();
        ps.close();
        BaseJDBCTestCase.println("Expecting to touch " + expectedRowCount + " rows.");
        BaseJDBCTestCase.assertEquals((int)expectedRowCount, (int)actualRowCount);
    }

    protected void assertResults(Connection conn, String query, String[][] rows, boolean trimResults) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, query);
        ResultSet rs = ps.executeQuery();
        this.assertResults(rs, rows, trimResults);
        rs.close();
        ps.close();
    }

    protected void assertResults(ResultSet rs, String[][] rows, boolean trimResults) throws SQLException {
        for (String[] row : rows) {
            int columnCount = row.length;
            BaseJDBCTestCase.assertTrue((boolean)rs.next());
            for (int j = 0; j < columnCount; ++j) {
                String expectedValue = row[j];
                String actualValue = null;
                int column = j + 1;
                actualValue = rs.getString(column);
                if (rs.wasNull()) {
                    actualValue = null;
                }
                if (actualValue != null && trimResults) {
                    actualValue = actualValue.trim();
                }
                BaseJDBCTestCase.assertEquals((expectedValue == null ? 1 : 0) != 0, (boolean)rs.wasNull());
                if (expectedValue == null) {
                    BaseJDBCTestCase.assertNull((Object)actualValue);
                    continue;
                }
                BaseJDBCTestCase.assertEquals((String)expectedValue, (String)actualValue);
            }
        }
        BaseJDBCTestCase.assertFalse((boolean)rs.next());
    }

    protected static ResultSet executeQuery(Statement stmt, String text) throws SQLException {
        BaseJDBCTestCase.println("Executing '" + text + "'");
        return stmt.executeQuery(text);
    }

    protected PreparedStatement chattyPrepare(Connection conn, String text) throws SQLException {
        BaseJDBCTestCase.println("Preparing statement:\n\t" + text);
        return conn.prepareStatement(text);
    }

    protected CallableStatement chattyPrepareCall(Connection conn, String text) throws SQLException {
        BaseJDBCTestCase.println("Preparing callable statement:\n\t" + text);
        return conn.prepareCall(text);
    }

    protected void expectCompilationError(String sqlState, String query) {
        BaseJDBCTestCase.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        this.assertCompileError(sqlState, query);
    }

    protected void expectCompilationError(Connection conn, String sqlState, String query) {
        BaseJDBCTestCase.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(query);
        }
        catch (SQLException se) {
            BaseJDBCTestCase.assertSQLState(sqlState, se);
            return;
        }
        BaseJDBCTestCase.fail((String)("Expected SQL state: " + sqlState));
    }

    protected void expectExecutionError(Connection conn, String sqlState, String query) throws Exception {
        BaseJDBCTestCase.println("\nExpecting " + sqlState + " when executing:\n\t");
        PreparedStatement ps = this.chattyPrepare(conn, query);
        BaseJDBCTestCase.assertStatementError(sqlState, ps);
        ps.close();
    }

    private static Object getLanguageConnectionContext(Connection conn) {
        final EmbedConnection econn = (EmbedConnection)conn;
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                return econn.getLanguageConnection();
            }
        });
    }
}

