/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.corruptio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.SyncFailedException;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derbyTesting.functionTests.util.corruptio.CorruptFile;

abstract class CorruptBaseStorageFactory
implements WritableStorageFactory {
    protected WritableStorageFactory realStorageFactory;

    CorruptBaseStorageFactory() {
    }

    public void init(String home, String databaseName, String tempDirName, String uniqueName) throws IOException {
        this.realStorageFactory = this.getRealStorageFactory();
        this.realStorageFactory.init(home, databaseName, tempDirName, uniqueName);
    }

    public void shutdown() {
        this.realStorageFactory.shutdown();
    }

    public String getCanonicalName() throws IOException {
        return this.realStorageFactory.getCanonicalName();
    }

    public void setCanonicalName(String name) {
        this.realStorageFactory.setCanonicalName(name);
    }

    public StorageFile newStorageFile(String path) {
        return new CorruptFile(this.realStorageFactory.newStorageFile(path));
    }

    public StorageFile newStorageFile(String directoryName, String fileName) {
        return new CorruptFile(this.realStorageFactory.newStorageFile(directoryName, fileName));
    }

    public StorageFile newStorageFile(StorageFile directoryName, String fileName) {
        StorageFile realDirFile = ((CorruptFile)directoryName).getRealFileInstance();
        return new CorruptFile(this.realStorageFactory.newStorageFile(realDirFile, fileName));
    }

    public char getSeparator() {
        return this.realStorageFactory.getSeparator();
    }

    public StorageFile getTempDir() {
        return new CorruptFile(this.realStorageFactory.getTempDir());
    }

    public boolean isFast() {
        return this.realStorageFactory.isFast();
    }

    public boolean isReadOnlyDatabase() {
        return this.realStorageFactory.isReadOnlyDatabase();
    }

    public boolean supportsRandomAccess() {
        return this.realStorageFactory.supportsRandomAccess();
    }

    public int getStorageFactoryVersion() {
        return this.realStorageFactory.getStorageFactoryVersion();
    }

    public void sync(OutputStream stream, boolean metaData) throws IOException, SyncFailedException {
        this.realStorageFactory.sync(stream, metaData);
    }

    public boolean supportsWriteSync() {
        return this.realStorageFactory.supportsWriteSync();
    }

    abstract WritableStorageFactory getRealStorageFactory();

    public StorageFile createTemporaryFile(String prefix, String suffix) throws IOException {
        return new CorruptFile(this.realStorageFactory.createTemporaryFile(prefix, suffix));
    }
}

