/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class RecoveryTest
extends BaseJDBCTestCase {
    public RecoveryTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("RecoveryTest");
        suite.addTest(RecoveryTest.decorateTest());
        return suite;
    }

    private static Test decorateTest() {
        CleanDatabaseTestSetup test = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(RecoveryTest.class));
        return test;
    }

    public void testBasicRecovery() throws Exception {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        Statement st = this.createStatement();
        st.executeUpdate("create table t( i int )");
        c.commit();
        TestConfiguration.getCurrent().shutdownDatabase();
        st.close();
        c.close();
        RecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.RecoveryTest.launchRecoveryInsert");
        st = this.createStatement();
        ResultSet rs = st.executeQuery("select i from t");
        JDBC.assertFullResultSet(rs, new String[][]{{"1956"}});
    }

    public void launchRecoveryInsert() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        Statement st = this.createStatement();
        st.executeUpdate("insert into t(i) values (1956)");
        c.commit();
        st.executeUpdate("insert into t(i) values (2011)");
    }
}

