/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class OnlineBackup
implements Runnable {
    private String dbName;
    private boolean beginBackup = false;
    private boolean endBackup = false;
    private boolean backupFailed = false;
    private Throwable backupError = null;
    private String backupPath;

    OnlineBackup(String dbName, String backupPath) {
        this.dbName = dbName;
        this.backupPath = backupPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.backupFailed = false;
        try {
            this.performBackup();
        }
        catch (Throwable error) {
            OnlineBackup onlineBackup = this;
            synchronized (onlineBackup) {
                this.backupFailed = true;
                this.backupError = error;
                this.notifyAll();
            }
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)error);
            error.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performBackup() throws SQLException {
        Connection conn = TestUtil.getConnection(this.dbName, "");
        CallableStatement backupStmt = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        backupStmt.setString(1, this.backupPath);
        OnlineBackup onlineBackup = this;
        synchronized (onlineBackup) {
            this.beginBackup = true;
            this.endBackup = false;
            this.notifyAll();
        }
        backupStmt.execute();
        backupStmt.close();
        conn.close();
        onlineBackup = this;
        synchronized (onlineBackup) {
            this.beginBackup = false;
            this.endBackup = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBackupToBegin() throws Exception {
        OnlineBackup onlineBackup = this;
        synchronized (onlineBackup) {
            while (!this.beginBackup) {
                if (this.backupFailed) {
                    throw new Exception("BACKUP FAILED:" + this.backupError.getMessage());
                }
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBackupToEnd() throws Exception {
        OnlineBackup onlineBackup = this;
        synchronized (onlineBackup) {
            if (!this.endBackup) {
                if (!this.beginBackup) {
                    System.out.println("BACKUP IS NOT STARTED BY THE TEST YET");
                } else {
                    while (!this.endBackup) {
                        if (this.backupFailed) {
                            throw new Exception("BACKUP FAILED:" + this.backupError.getMessage());
                        }
                        this.wait();
                    }
                }
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.beginBackup;
    }

    public void createFromBackup(String newDbName) throws SQLException {
        Connection conn = TestUtil.getConnection(newDbName, "createFrom=" + this.backupPath + "/" + this.dbName);
        conn.close();
    }

    public void restoreFromBackup() throws SQLException {
        Connection conn = TestUtil.getConnection(this.dbName, "restoreFrom=" + this.backupPath + "/" + this.dbName);
        conn.close();
    }
}

