/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class KillSlave
extends BaseJDBCTestCase {
    private static ReplicationRun repRun = new ReplicationRun("KillSlave");
    private static String slaveServerHost = null;
    private static int slaveServerPort = -1;

    public KillSlave(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        System.out.println("**** KillSlave.suite()");
        System.out.println("'KillSlave' can not be run outside the 'ReplicationRun' framework.");
        BaseTestSuite suite = new BaseTestSuite("KillSlave");
        String masterHostName = System.getProperty("test.serverHost", "localhost");
        int masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        repRun.initEnvironment();
        slaveServerHost = ReplicationRun.slaveServerHost;
        slaveServerPort = ReplicationRun.slaveServerPort;
        suite.addTest(KillSlave.suite(masterHostName, masterPortNo));
        return suite;
    }

    public static Test suite(String serverHost, int serverPort) {
        System.out.println("*** KillSlave.suite(serverHost,serverPort)");
        Test t = TestConfiguration.existingServerSuite(KillSlave.class, false, serverHost, serverPort);
        System.out.println("*** Done TestConfiguration.defaultExistingServerSuite(KillSlave.class,false,serverHost,serverPort)");
        return t;
    }

    public void testKillSlave() throws SQLException, IOException, InterruptedException {
        System.out.println("**** KillSlave.testKillSlave() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table t (i integer primary key, vc varchar(20))");
        PreparedStatement pSt = this.prepareStatement("insert into t values (?,?)");
        for (int i = 0; i < 1000; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, "i" + i);
            pSt.execute();
            System.out.println("i: " + i);
            if (i != 500) continue;
            repRun.killSlave(slaveServerHost, slaveServerPort);
        }
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }
}

