/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.Set;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;

public class ManagementMBeanTest
extends MBeanTest {
    private static final String MANAGEMENT = "Management";
    private static final String VERSION = "Version";
    private static final int EXPECTED_BEAN_COUNT = 6;
    private static final String[] MBEAN_TYPES = new String[]{"NetworkServer", "Management", "JDBC", "Version"};

    public ManagementMBeanTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MBeanTest.suite(ManagementMBeanTest.class, "ManagementMBeanTest");
    }

    public void testStartStopManagementFromApplication() throws Exception {
        ObjectName appMgmtBean = this.getApplicationManagementMBean();
        this.startStopManagement(appMgmtBean);
    }

    private void startStopManagement(ObjectName mbean) throws Exception {
        this.assertBooleanAttribute(true, mbean, "ManagementActive");
        StatsTuple originalStats = this.getCurrentStats("Original");
        ManagementMBeanTest.assertTrue((String)("DerbyMBeanCount:" + originalStats.getBeanCount()), (originalStats.getBeanCount() >= 6 ? 1 : 0) != 0);
        this.invokeOperation(mbean, "startManagement");
        this.assertBooleanAttribute(true, mbean, "ManagementActive");
        StatsTuple nopStats = this.getCurrentStats("NOP");
        this.compareStats(originalStats, nopStats);
        this.invokeOperation(mbean, "stopManagement");
        this.assertBooleanAttribute(false, mbean, "ManagementActive");
        StatsTuple afterStopping = this.getCurrentStats("After Stopping");
        int[] expectedCounts = new int[MBEAN_TYPES.length];
        for (int i = 0; i < MBEAN_TYPES.length; ++i) {
            int expectedDifference = 1;
            if (MANAGEMENT.equals(MBEAN_TYPES[i])) {
                expectedDifference = 0;
            } else if (VERSION.equals(MBEAN_TYPES[i])) {
                expectedDifference = 2;
            }
            expectedCounts[i] = originalStats.typeCounts[i] - expectedDifference;
        }
        StatsTuple expectedStats = new StatsTuple(null, expectedCounts);
        this.compareStats(expectedStats, afterStopping);
        this.invokeOperation(mbean, "startManagement");
        this.assertBooleanAttribute(true, mbean, "ManagementActive");
        StatsTuple afterRestarting = this.getCurrentStats("After Restarting");
        this.compareStats(originalStats, afterRestarting);
    }

    private StatsTuple getCurrentStats(String tag) throws Exception {
        Set<ObjectName> beanNames = this.getDerbyDomainMBeans();
        StatsTuple retval = new StatsTuple(beanNames, this.countMBeanTypes(beanNames));
        ManagementMBeanTest.println(tag + " bean count = " + retval.getBeanCount());
        return retval;
    }

    private void compareStats(StatsTuple expected, StatsTuple actual) throws Exception {
        ManagementMBeanTest.assertEquals((int)expected.getBeanCount(), (int)actual.getBeanCount());
        for (int i = 0; i < MBEAN_TYPES.length; ++i) {
            ManagementMBeanTest.assertEquals((String)MBEAN_TYPES[i], (int)expected.typeCounts[i], (int)actual.typeCounts[i]);
        }
    }

    private int[] countMBeanTypes(Set<ObjectName> names) throws Exception {
        int[] retval = new int[MBEAN_TYPES.length];
        for (ObjectName name : names) {
            String beanType = name.getKeyProperty("type");
            for (int i = 0; i < MBEAN_TYPES.length; ++i) {
                if (!MBEAN_TYPES[i].equals(beanType)) continue;
                int n = i;
                retval[n] = retval[n] + 1;
            }
        }
        return retval;
    }

    private static final class StatsTuple {
        Set<ObjectName> beanNames;
        int[] typeCounts;

        public StatsTuple(Set<ObjectName> beanNames, int[] typeCounts) {
            this.beanNames = beanNames;
            this.typeCounts = typeCounts;
        }

        public int getBeanCount() {
            int total = 0;
            for (int i = 0; i < this.typeCounts.length; ++i) {
                total += this.typeCounts[i];
            }
            return total;
        }
    }
}

