/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.net.MalformedURLException;
import javax.management.remote.JMXServiceURL;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.JMXConnectionGetter;
import org.apache.derbyTesting.functionTests.tests.management.PlatformConnectionGetter;
import org.apache.derbyTesting.functionTests.tests.management.RemoteConnectionGetter;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

class JMXConnectionDecorator
extends BaseTestSetup {
    private final boolean remote;
    private JMXConnectionGetter oldGetter;

    static Test remoteNoSecurity(Test test) {
        return new JMXConnectionDecorator(test, true);
    }

    static Test platformMBeanServer(Test test) {
        return new JMXConnectionDecorator(test, false);
    }

    private JMXConnectionDecorator(Test test, boolean remote) {
        super(test);
        this.remote = remote;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.oldGetter = JMXConnectionGetter.mbeanServerConnector.get();
        JMXConnectionGetter getter = this.remote ? new RemoteConnectionGetter(this.getJmxUrl()) : new PlatformConnectionGetter();
        JMXConnectionGetter.mbeanServerConnector.set(getter);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JMXConnectionGetter.mbeanServerConnector.set(this.oldGetter);
        this.oldGetter = null;
    }

    private JMXServiceURL getJmxUrl() throws MalformedURLException {
        String hostname = TestConfiguration.getCurrent().getHostName();
        int jmxPort = TestConfiguration.getCurrent().getJmxPort();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + hostname + ":" + jmxPort + "/jmxrmi");
        return url;
    }
}

