/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OrderByAndSortAvoidance
extends BaseJDBCTestCase {
    public OrderByAndSortAvoidance(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("OrderByAndSortAvoidance");
        suite.addTest(OrderByAndSortAvoidance.makeSuite());
        suite.addTest(TestConfiguration.clientServerDecorator(OrderByAndSortAvoidance.makeSuite()));
        return suite;
    }

    private static Test makeSuite() {
        return new CleanDatabaseTestSetup((Test)new BaseTestSuite(OrderByAndSortAvoidance.class)){

            @Override
            protected void decorateSQL(Statement st) throws SQLException {
                st.executeUpdate("create table a(col1 int, col2 int)");
                st.executeUpdate("insert into a values(1,1),(1,1)");
                st.executeUpdate("create table b(col1 int, col2 int)");
                st.executeUpdate("insert into b values(2,2),(2,2)");
                st.executeUpdate("create table c(col1 int, col2 int)");
                st.executeUpdate("insert into c values(3,3),(3,3)");
                st.executeUpdate("create TABLE table1 (id BIGINT NOT NULL, PRIMARY KEY(id))");
                st.executeUpdate("CREATE INDEX key1 ON table1(id)");
                st.executeUpdate("CREATE TABLE table2 (id BIGINT NOT NULL, name VARCHAR(40) NOT NULL, value VARCHAR(1024), PRIMARY KEY(id, name))");
                st.executeUpdate("CREATE UNIQUE INDEX key2 ON table2(id, name)");
                st.executeUpdate("CREATE INDEX key3 ON table2(value)");
                OrderByAndSortAvoidance.populateTestTables(this.getConnection());
                st.executeUpdate("CREATE TABLE test1 (id BIGINT NOT NULL, name VARCHAR(255), PRIMARY KEY (id))");
                st.executeUpdate("CREATE TABLE test2 (entity_id BIGINT, rel_id BIGINT)");
                st.executeUpdate("CREATE INDEX idx_test2 ON test2 (entity_id)");
                st.executeUpdate("INSERT INTO test1 (id, name) VALUES (102, 'Tom')");
                st.executeUpdate("INSERT INTO test1 (id, name) VALUES (1, null)");
                st.executeUpdate("INSERT INTO test1 (id, name) VALUES (103, 'Jerry')");
                st.executeUpdate("INSERT INTO test1 (id, name) VALUES (101, 'Pupy')");
                st.executeUpdate("INSERT INTO test2 (entity_id, rel_id) VALUES (1, 102)");
                st.executeUpdate("INSERT INTO test2 (entity_id, rel_id) VALUES (1, 101)");
                st.executeUpdate("INSERT INTO test2 (entity_id, rel_id) VALUES (1, 103)");
                st.executeUpdate("CREATE TABLE REPOSITORIES ( ID INT CONSTRAINT REPOSITORIES_PRIMARY_ID PRIMARY KEY GENERATED ALWAYS AS IDENTITY, PATH VARCHAR(32672) CONSTRAINT REPOSITORIES_PATH UNIQUE NOT NULL)");
                st.executeUpdate("CREATE TABLE FILES ( ID INT CONSTRAINT FILES_PRIMARY_ID PRIMARY KEY GENERATED ALWAYS AS IDENTITY, PATH VARCHAR(32672) NOT NULL, REPOSITORY INT NOT NULL REFERENCES REPOSITORIES ON DELETE CASCADE, CONSTRAINT FILES_REPOSITORY_PATH UNIQUE (REPOSITORY, PATH))");
                st.executeUpdate("CREATE TABLE AUTHORS ( ID INT CONSTRAINT AUTHORS_PRIMARY_ID PRIMARY KEY GENERATED ALWAYS AS IDENTITY, REPOSITORY INT NOT NULL REFERENCES REPOSITORIES ON DELETE CASCADE, NAME VARCHAR(32672) NOT NULL, CONSTRAINT AUTHORS_REPOSITORY_NAME UNIQUE (REPOSITORY, NAME))");
                st.executeUpdate("CREATE TABLE CHANGESETS ( ID INT CONSTRAINT CHANGESETS_PRIMARY_ID PRIMARY KEY GENERATED ALWAYS AS IDENTITY, REPOSITORY INT NOT NULL REFERENCES REPOSITORIES ON DELETE CASCADE, REVISION VARCHAR(1024) NOT NULL, AUTHOR INT NOT NULL REFERENCES AUTHORS ON DELETE CASCADE, TIME TIMESTAMP NOT NULL, MESSAGE VARCHAR(32672) NOT NULL, CONSTRAINT CHANGESETS_REPOSITORY_REVISION UNIQUE (REPOSITORY, REVISION))");
                st.executeUpdate("CREATE UNIQUE INDEX IDX_CHANGESETS_ID_DESC ON CHANGESETS(ID DESC)");
                st.executeUpdate("CREATE TABLE FILECHANGES ( ID INT CONSTRAINT FILECHANGES_PRIMARY_ID PRIMARY KEY GENERATED ALWAYS AS IDENTITY, FILE INT NOT NULL REFERENCES FILES ON DELETE CASCADE, CHANGESET INT NOT NULL REFERENCES CHANGESETS ON DELETE CASCADE, CONSTRAINT FILECHANGES_FILE_CHANGESET UNIQUE (FILE, CHANGESET))");
                st.executeUpdate("insert into repositories(path) values '/var/tmp/source5923202038296723704opengrok/mercurial'");
                st.executeUpdate("insert into files(path, repository) values ('/mercurial/Makefile', 1), ('/mercurial/main.c', 1), ('/mercurial/header.h', 1), ('/mercurial/.hgignore', 1)");
                st.executeUpdate("insert into authors(repository, name) values (1, 'Trond Norbye <trond.norbye@sun.com>')");
                st.executeUpdate("insert into changesets(repository, revision, author, time, message) values (1,'0:816b6279ae9c',1,'2008-08-12 22:00:00.0','Add .hgignore file'),(1,'1:f24a5fd7a85d',1,'2008-08-12 22:03:00.0','Created a small dummy program'),(1,'2:585a1b3f2efb',1,'2008-08-12 22:13:00.0','Add lint make target and fix lint warnings')");
                st.executeUpdate("insert into filechanges(file, changeset) values (4,1),(1,2),(3,2),(2,2),(1,3),(2,3)");
            }
        };
    }

    private static void insertTable1(PreparedStatement ps, long id) throws SQLException {
        ps.setLong(1, id);
        ps.executeUpdate();
    }

    private static void insertTable2(PreparedStatement ps, long id, String name, String value) throws SQLException {
        ps.setLong(1, id);
        ps.setString(2, name);
        ps.setString(3, value);
        ps.executeUpdate();
    }

    private static void updateTable2(PreparedStatement ps, long id) throws SQLException {
        ps.setLong(1, id);
        ps.executeUpdate();
    }

    /*
     * Opcode count of 14836 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void populateTestTables(Connection conn) throws SQLException {
        PreparedStatement it1 = conn.prepareStatement("INSERT INTO table1 VALUES (?)");
        PreparedStatement it2 = conn.prepareStatement("INSERT INTO table2 VALUES (?,?,?)");
        PreparedStatement ut2 = conn.prepareStatement("UPDATE table2 SET value='true' WHERE id=? AND name='has_address'");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "DocumentSortingValues", "______21855__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "CommunicationOrderId", "21865");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "PostComponentId", "21855");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "EnvelopSortingValue", "BE1180___testOlivier001-0001___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "AddressG1", "testOlivier001-0001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000002L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "DocumentSortingValues", "______21855__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "CommunicationOrderId", "21865");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "PostComponentId", "21855");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "EnvelopSortingValue", "BE1180___testOlivier001-0001___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "AddressG1", "testOlivier001-0001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000003L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "DocumentSortingValues", "______21856__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "CommunicationOrderId", "21866");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "PostComponentId", "21856");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "EnvelopSortingValue", "BE1180___testOlivier001-0002___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "AddressG1", "testOlivier001-0002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000004L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "DocumentSortingValues", "______21856__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "CommunicationOrderId", "21866");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "PostComponentId", "21856");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "EnvelopSortingValue", "BE1180___testOlivier001-0002___________Bla bla bla bla bl,a bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "AddressG1", "testOlivier001-0002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000005L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "DocumentSortingValues", "______21857__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "CommunicationOrderId", "21867");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "PostComponentId", "21857");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "EnvelopSortingValue", "BE1180___testOlivier002-0003___________Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "AddressG1", "testOlivier002-0003");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000006L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "DocumentSortingValues", "______21857__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "CommunicationOrderId", "21867");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "PostComponentId", "21857");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "EnvelopSortingValue", "BE1180___testOlivier002-0003___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "AddressG1", "testOlivier002-0003");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000007L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "DocumentSortingValues", "______21858__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "CommunicationOrderId", "21868");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "PostComponentId", "21858");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "EnvelopSortingValue", "BE1180___testOlivier002-0004___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "AddressG1", "testOlivier002-0004");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000008L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "DocumentSortingValues", "______21858__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "CommunicationOrderId", "21868");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "PostComponentId", "21858");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "EnvelopSortingValue", "BE1180___testOlivier002-0004___________Boulevard du Souverain, 23____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddressG2", "Boulevard du Souverain, 23");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "AddressG1", "testOlivier002-0004");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000009L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "DocumentSortingValues", "______21859__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "CommunicationOrderId", "21869");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "PostComponentId", "21859");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "EnvelopSortingValue", "BE1000___testOlivier003-0005___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "AddressG1", "testOlivier003-0005");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x8000000AL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "DocumentSortingValues", "______21859__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "CommunicationOrderId", "21869");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "PostComponentId", "21859");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "EnvelopSortingValue", "BE1000___testOlivier003-0005___________rue dubroker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "AddressG1", "testOlivier003-0005");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x8000000BL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "DocumentSortingValues", "______21860__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "CommunicationOrderId", "21870");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "PostComponentId", "21860");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "EnvelopSortingValue", "BE1000___testOlivier003-0006___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "AddressG1", "testOlivier003-0006");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x8000000CL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "DocumentSortingValues", "______21860__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "CommunicationOrderId", "21870");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "PostComponentId", "21860");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "EnvelopSortingValue", "BE1000___testOlivier003-0006___________rue dubroker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "AddressG1", "testOlivier003-0006");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x8000000DL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "DocumentSortingValues", "______21861__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "CommunicationOrderId", "21871");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "PostComponentId", "21861");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "EnvelopSortingValue", "BE1180___testOlivier004-0007___________Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "AddressG1", "testOlivier004-0007");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x8000000EL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "DocumentSortingValues", "______21861__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "CommunicationOrderId", "21871");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "PostComponentId", "21861");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "EnvelopSortingValue", "BE1180___testOlivier004-0007___________Boulevard du Souverain, 23____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "AddressG1", "testOlivier004-0007");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x8000000FL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "DocumentSortingValues", "______21862__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "CommunicationOrderId", "21872");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "PostComponentId", "21862");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "EnvelopSortingValue", "BE1180___testOlivier004-0008___________Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "AddressG1", "testOlivier004-0008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000010L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "DocumentSortingValues", "______21862__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "CommunicationOrderId", "21872");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "PostComponentId", "21862");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "EnvelopSortingValue", "BE1180___testOlivier004-0008___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "AddressG1", "testOlivier004-0008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000011L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "DocumentSortingValues", "______21863__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "CommunicationOrderId", "21873");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "PostComponentId", "21863");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "EnvelopSortingValue", "BE1180___testOlivier005-0009___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "AddressG1", "testOlivier005-0009");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483666L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "DocumentSortingValues", "______21863__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "CommunicationOrderId", "21873");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "PostComponentId", "21863");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "EnvelopSortingValue", "BE1180___testOlivier005-0009___________Boulevard du Souverain, 23____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "AddressG1", "testOlivier005-0009");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483667L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "DocumentSortingValues", "______21864__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "CommunicationOrderId", "21874");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "PostComponentId", "21864");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "EnvelopSortingValue", "BE1180___testOlivier005-0010___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "AddressG1", "testOlivier005-0010");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483668L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "DocumentSortingValues", "______21864__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "CommunicationOrderId", "21874");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "PostComponentId", "21864");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "EnvelopSortingValue", "BE1180___testOlivier005-0010___________Boulevard du Souverain, 23____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddressG2", "Boulevard du Souverain, 23");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "AddressG1", "testOlivier005-0010");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483669L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "DocumentSortingValues", "______21865__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "CommunicationOrderId", "21875");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "PostComponentId", "21865");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "EnvelopSortingValue", "BE1000___testOlivier006-0011___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "AddressG1", "testOlivier006-0011");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483670L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "DocumentSortingValues", "______21865__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "CommunicationOrderId", "21875");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "PostComponentId", "21865");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "EnvelopSortingValue", "BE1000___testOlivier006-0011___________rue dubroker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "AddressG1", "testOlivier006-0011");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483671L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "DocumentSortingValues", "______21866__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "CommunicationOrderId", "21876");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "PostComponentId", "21866");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "EnvelopSortingValue", "BE1000___testOlivier006-0012___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "AddressG1", "testOlivier006-0012");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000018L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "DocumentSortingValues", "______21866__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "CommunicationOrderId", "21876");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "PostComponentId", "21866");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "EnvelopSortingValue", "BE1000___testOlivier006-0012___________rue dubroker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "AddressG1", "testOlivier006-0012");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483673L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "DocumentSortingValues", "______21867__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "CommunicationOrderId", "21877");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "PostComponentId", "21867");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "EnvelopSortingValue", "BE1180___testOlivier007-0013___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "AddressG1", "testOlivier007-0013");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483674L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "DocumentSortingValues", "______21867__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "CommunicationOrderId", "21877");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "PostComponentId", "21867");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "EnvelopSortingValue", "BE1180___testOlivier007-0013___________Boulevard du Souverain, 23____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "AddressG1", "testOlivier007-0013");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483675L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "DocumentSortingValues", "______21868__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "CommunicationOrderId", "21878");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "PostComponentId", "21868");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "EnvelopSortingValue", "BE1180___testOlivier007-0014___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "AddressG1", "testOlivier007-0014");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483676L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "DocumentSortingValues", "______21868__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "CommunicationOrderId", "21878");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "PostComponentId", "21868");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "EnvelopSortingValue", "BE1180___testOlivier007-0014___________Boulevard du Souverain, 23____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddressG2", "Boulevard du Souverain, 23");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "AddressG1", "testOlivier007-0014");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483677L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "DocumentSortingValues", "______21869__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "CommunicationOrderId", "21879");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "PostComponentId", "21869");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "EnvelopSortingValue", "BE1180___testOlivier008-0015___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "AddressG1", "testOlivier008-0015");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483678L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "DocumentSortingValues", "______21869__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "CommunicationOrderId", "21879");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "PostComponentId", "21869");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "EnvelopSortingValue", "BE1180___testOlivier008-0015___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "AddressG1", "testOlivier008-0015");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483679L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "DocumentSortingValues", "______21870__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "CommunicationOrderId", "21880");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "PostComponentId", "21870");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "EnvelopSortingValue", "BE1180___testOlivier008-0016___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "AddressG1", "testOlivier008-0016");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000020L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "DocumentSortingValues", "______21870__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "CommunicationOrderId", "21880");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "PostComponentId", "21870");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "EnvelopSortingValue", "BE1180___testOlivier008-0016___________Boulevard du Souverain, 23____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "AddressG1", "testOlivier008-0016");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483681L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "DocumentSortingValues", "______21871__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "CommunicationOrderId", "21881");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "PostComponentId", "21871");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "EnvelopSortingValue", "BE1000___testOlivier009-0017___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "AddressG1", "testOlivier009-0017");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000022L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "DocumentSortingValues", "______21871__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "CommunicationOrderId", "21881");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "PostComponentId", "21871");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "EnvelopSortingValue", "BE1000___testOlivier009-0017___________rue dubroker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "AddressG1", "testOlivier009-0017");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483683L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "DocumentSortingValues", "______21872__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "CommunicationOrderId", "21882");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "PostComponentId", "21872");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "EnvelopSortingValue", "BE1000___testOlivier009-0018___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "AddressG1", "testOlivier009-0018");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483684L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "DocumentSortingValues", "______21872__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "CommunicationOrderId", "21882");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "PostComponentId", "21872");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "EnvelopSortingValue", "BE1000___testOlivier009-0018___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "AddressG1", "testOlivier009-0018");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483685L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "DocumentSortingValues", "______21873__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "CommunicationOrderId", "21883");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "PostComponentId", "21873");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "EnvelopSortingValue", "BE1180___testOlivier010-0019___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "AddressG1", "testOlivier010-0019");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483686L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "DocumentSortingValues", "______21873__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "CommunicationOrderId", "21883");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "PostComponentId", "21873");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "EnvelopSortingValue", "BE1180___testOlivier010-0019___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "AddressG1", "testOlivier010-0019");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483687L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "DocumentSortingValues", "______21874__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "CommunicationOrderId", "21884");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "PostComponentId", "21874");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "EnvelopSortingValue", "BE1180___testOlivier010-0020___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "AddressG1", "testOlivier010-0020");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000028L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "SC2", "LaPosteSortPlan=B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddressG3", "1180, Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "DocumentSortingValues", "______21874__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "SubBatchSortingValue", "BE_B-W3-S2___");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "SC1", "Country=BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "CommunicationOrderId", "21884");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "BatchTypeId", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "SortPlan", "B-W3-S2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "PostComponentId", "21874");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "BatchTypeLabel", "Paper");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "EnvelopSortingValue", "BE1180___testOlivier010-0020___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "AddressG1", "testOlivier010-0020");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483689L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "DocumentSortingValues", "______21875__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "CommunicationOrderId", "21885");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "PostComponentId", "21875");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "EnvelopSortingValue", "BE1180___testOlivier011-0021___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "AddressG1", "testOlivier011-0021");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483690L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "DocumentSortingValues", "______21875__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "CommunicationOrderId", "21885");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "PostComponentId", "21875");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "EnvelopSortingValue", "BE1180___testOlivier011-0021___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "AddressG1", "testOlivier011-0021");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483691L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "DocumentSortingValues", "______21876__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "CommunicationOrderId", "21886");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "PostComponentId", "21876");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "EnvelopSortingValue", "BE1180___testOlivier011-0022___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "AddressG1", "testOlivier011-0022");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483692L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "DocumentSortingValues", "______21876__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "CommunicationOrderId", "21886");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "PostComponentId", "21876");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "EnvelopSortingValue", "BE1180___testOlivier011-0022___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "AddressG1", "testOlivier011-0022");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483693L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "DocumentSortingValues", "______21877__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "CommunicationOrderId", "21887");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "PostComponentId", "21877");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "EnvelopSortingValue", "BE1000___testOlivier012-0023___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "AddressG1", "testOlivier012-0023");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483694L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "DocumentSortingValues", "______21877__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "CommunicationOrderId", "21887");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "PostComponentId", "21877");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "EnvelopSortingValue", "BE1000___testOlivier012-0023___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "AddressG1", "testOlivier012-0023");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 2147483695L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "DocumentSortingValues", "______21878__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "CommunicationOrderId", "21888");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "PostComponentId", "21878");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "EnvelopSortingValue", "BE1000___testOlivier012-0024___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "AddressG1", "testOlivier012-0024");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable1(it1, 0x80000030L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "SC2", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "IsIdenticalToDocumentAddress", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddressG3", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "DocumentSortingValues", "______21878__1__1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "ItemSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "BatchTypeInstructions", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "SubBatchSortingValue", "Une info b");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "logo", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "InternalAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "InternalAddressBringer", "false");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddresseeSeq", "1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "SC1", "DeliveryInformation=Une info bidon");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "CommunicationOrderId", "21888");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "BatchTypeId", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "location", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "Enveloping", "C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "PostComponentId", "21878");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "BatchTypeLabel", "BROKER NET");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "city", "Broker ville");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "StapleNbr", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "TLEBundle", "Niveau2");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "header", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "EnvelopSortingValue", "BE1000___testOlivier012-0024___________rue du broker_________________");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddressG2", "rue du broker");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "DiversionReason", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "TLEBinder", "Niveau1");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "AddressG1", "testOlivier012-0024");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "postCode", "1000");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "GenerationTime", "Wed Oct 22 14:12:10 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "DocumentID", "21865/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000001L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "GenerationTime", "Wed Oct 22 14:12:10 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "DocumentID", "21865/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000002L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000002L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "GenerationTime", "Wed Oct 22 14:12:10 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "DocumentID", "21866/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000003L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000003L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "GenerationTime", "Wed Oct 22 14:12:10 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "DocumentID", "21866/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000004L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000004L);
        OrderByAndSortAvoidance.insertTable1(it1, 0x100000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "IsIdenticalToDocumentAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "DocumentSortingValues", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "ItemSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddresseeSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "CommunicationOrderId", "21867");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "PostComponentId", "21857");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "StapleNbr", "NO");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "EnvelopSortingValue", "BE1180___testOlivier002-0003___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "AddressG1", "testOlivier002-0003");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "env_type", "I");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "PaperLayout", "ADDINT");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "GenerationTime", "Wed Oct 22 14:12:10 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "DocumentID", "21867/0/0//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "cover_page", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x100000001L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x100000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "GenerationTime", "Wed Oct 22 14:12:10 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "DocumentID", "21867/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000005L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000005L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "GenerationTime", "Wed Oct 22 14:12:10 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "DocumentID", "21867/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "PageSequenceId", "000003");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000006L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000006L);
        OrderByAndSortAvoidance.insertTable1(it1, 0x180000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "IsIdenticalToDocumentAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "DocumentSortingValues", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "ItemSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddresseeSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "CommunicationOrderId", "21868");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "PostComponentId", "21858");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "StapleNbr", "NO");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "EnvelopSortingValue", "BE1180___testOlivier002-0004___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "AddressG1", "testOlivier002-0004");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "env_type", "I");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "PaperLayout", "ADDINT");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "DocumentID", "21868/0/0//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "cover_page", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x180000001L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x180000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "DocumentID", "21868/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000007L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000007L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "DocumentID", "21868/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "PageSequenceId", "000003");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000008L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000008L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "DocumentID", "21869/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000009L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000009L);
        OrderByAndSortAvoidance.insertTable1(it1, 0x200000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "IsIdenticalToDocumentAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "DocumentSortingValues", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "ItemSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddresseeSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "CommunicationOrderId", "21873");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "PostComponentId", "21863");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "StapleNbr", "NO");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "EnvelopSortingValue", "BE1180___testOlivier005-0009___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "AddressG1", "testOlivier005-0009");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "env_type", "I");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "DocumentID", "21869/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000AL, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x8000000AL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "DocumentID", "21870/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000BL, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x8000000BL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "DocumentID", "21870/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000CL, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x8000000CL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "DocumentID", "21871/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000DL, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x8000000DL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "DocumentID", "21871/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000EL, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x8000000EL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "DocumentID", "21872/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x8000000FL, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x8000000FL);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "DocumentID", "21872/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000010L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000010L);
        OrderByAndSortAvoidance.insertTable1(it1, 10737418241L);
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "IsIdenticalToDocumentAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "DocumentSortingValues", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "ItemSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddresseeSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "CommunicationOrderId", "21874");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "PostComponentId", "21864");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "StapleNbr", "NO");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "EnvelopSortingValue", "BE1180___testOlivier005-0010___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "AddressG1", "testOlivier005-0010");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "env_type", "I");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "PaperLayout", "ADDINT");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "DocumentID", "21873/0/0//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "cover_page", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x200000001L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x200000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "DocumentID", "21873/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000011L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000011L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "DocumentID", "21873/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "PageSequenceId", "000003");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483666L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483666L);
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "PaperLayout", "ADDINT");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "DocumentID", "21874/0/0//");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "cover_page", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 10737418241L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 10737418241L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "DocumentID", "21874/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483667L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483667L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "DocumentID", "21874/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "PageSequenceId", "000003");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483668L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483668L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "DocumentID", "21875/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483669L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483669L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "DocumentID", "21875/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483670L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483670L);
        OrderByAndSortAvoidance.insertTable1(it1, 0x300000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "IsIdenticalToDocumentAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "DocumentSortingValues", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "ItemSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddresseeSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "CommunicationOrderId", "21879");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "PostComponentId", "21869");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "StapleNbr", "NO");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "EnvelopSortingValue", "BE1180___testOlivier008-0015___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "AddressG1", "testOlivier008-0015");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "env_type", "I");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "DocumentID", "21876/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483671L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483671L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "DocumentID", "21876/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000018L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000018L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "DocumentID", "21877/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483673L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483673L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "DocumentID", "21877/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483674L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483674L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "DocumentID", "21878/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483675L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483675L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "GenerationTime", "Wed Oct 22 14:12:11 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "DocumentID", "21878/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483676L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483676L);
        OrderByAndSortAvoidance.insertTable1(it1, 15032385537L);
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "IsIdenticalToDocumentAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "DocumentSortingValues", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "ItemSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddresseeSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "CommunicationOrderId", "21880");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "PostComponentId", "21870");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "StapleNbr", "NO");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "EnvelopSortingValue", "BE1180___testOlivier008-0016___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "AddressG1", "testOlivier008-0016");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "env_type", "I");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "PaperLayout", "ADDINT");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "DocumentID", "21879/0/0//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "cover_page", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x300000001L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x300000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "DocumentID", "21879/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483677L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483677L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "DocumentID", "21879/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "PageSequenceId", "000003");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483678L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483678L);
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "PaperLayout", "ADDINT");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "DocumentID", "21880/0/0//");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "cover_page", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 15032385537L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 15032385537L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "DocumentID", "21880/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483679L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483679L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "DocumentID", "21880/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "PageSequenceId", "000003");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000020L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000020L);
        OrderByAndSortAvoidance.insertTable1(it1, 0x400000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "IsIdenticalToDocumentAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "DocumentSortingValues", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "ItemSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddresseeSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "CommunicationOrderId", "21885");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "PostComponentId", "21875");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "StapleNbr", "NO");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "EnvelopSortingValue", "BE1180___testOlivier011-0021___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "AddressG1", "testOlivier011-0021");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "env_type", "I");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "DocumentID", "21881/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483681L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483681L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "DocumentID", "21881/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000022L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000022L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "DocumentID", "21882/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483683L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483683L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "DocumentID", "21882/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483684L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483684L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "DocumentID", "21883/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483685L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483685L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "DocumentID", "21883/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483686L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483686L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "DocumentID", "21884/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483687L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483687L);
        OrderByAndSortAvoidance.insertTable1(it1, 19327352833L);
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "SC2", "PostCode=1180");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddressG4", "BELGIQUE");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "IsIdenticalToDocumentAddress", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddressG3", "1180 Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "DocumentSortingValues", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "ItemSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "BatchTypeInstructions", "Ne pas jeter ces documents.  Ils ont \u00e9t\u00e9 faits pour quelque chose.");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "Plex", "S");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "SC3", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "has_address", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "SubBatchSortingValue", "ddch257___1180______");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "Language", "FR");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "SC4", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "InternalAddress", "233/621");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddressG6", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "InternalAddressBringer", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddresseeSeq", "0");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "SC1", "Requester=ddch257");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "CommunicationOrderId", "21886");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "BatchTypeId", "233-621-001");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "location", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "SortPlan", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "Enveloping", "N");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "PostComponentId", "21876");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "BatchTypeLabel", "Diversion pour test");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "city", "Bruxelles");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddressG7", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "CopyMention", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "StapleNbr", "NO");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddressG8", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddressG5", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "EnvelopSortingValue", "BE1180___testOlivier011-0022___________Bla bla bla bla bla bla 99____");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "GroupedWith", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddressG2", "Bla bla bla bla bla bla 99");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "DiversionReason", "001");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "Pliable", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "country", "BE");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "AddressG1", "testOlivier011-0022");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "MentionCode", "");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "postCode", "1180");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "SC5", "=");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "env_type", "I");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "Branding", "1C");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "DocumentID", "21884/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000028L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000028L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "PaperLayout", "ADDINT");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "DocumentID", "21885/0/0//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "cover_page", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 0x400000001L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x400000001L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "DocumentID", "21885/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483689L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483689L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "GenerationTime", "Wed Oct 22 14:12:12 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "DocumentID", "21885/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "PageSequenceId", "000003");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483690L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483690L);
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "PaperLayout", "ADDINT");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "GenerationTime", "Wed Oct 22 14:12:13 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "DocumentID", "21886/0/0//");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "cover_page", "true");
        OrderByAndSortAvoidance.insertTable2(it2, 19327352833L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 19327352833L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "GenerationTime", "Wed Oct 22 14:12:13 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "DocumentID", "21886/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483691L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483691L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "GenerationTime", "Wed Oct 22 14:12:13 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "DocumentID", "21886/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "PageSequenceId", "000003");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483692L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483692L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "GenerationTime", "Wed Oct 22 14:12:13 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "DocumentID", "21887/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483693L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483693L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "GenerationTime", "Wed Oct 22 14:12:13 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "DocumentID", "21887/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483694L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483694L);
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "GenerationTime", "Wed Oct 22 14:12:13 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "DocumentID", "21888/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "PageSequenceId", "000001");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 2147483695L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 2147483695L);
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "PaperLayout", "LETTER");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "GenerationTime", "Wed Oct 22 14:12:13 CEST 2008");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "DocumentID", "21888/1/1//");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "PageSequenceId", "000002");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "PhysicalID", "No");
        OrderByAndSortAvoidance.insertTable2(it2, 0x80000030L, "Staple", "No");
        OrderByAndSortAvoidance.updateTable2(ut2, 0x80000030L);
        it1.close();
        it2.close();
        ut2.close();
    }

    public void testDerby4331() throws SQLException {
        String[][] desc_result = new String[][]{{"3"}, {"3"}, {"2"}, {"2"}, {"2"}, {"1"}};
        String[][] asc_result = new String[][]{{"1"}, {"2"}, {"2"}, {"2"}, {"3"}, {"3"}};
        String sql1 = "SELECT CS.ID FROM CHANGESETS CS, FILECHANGES FC, REPOSITORIES R, FILES F, AUTHORS A WHERE R.PATH = '/var/tmp/source5923202038296723704opengrok/mercurial' AND F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 WHERE F2.ID = FC.FILE AND F2.REPOSITORY = R.ID AND F2.PATH LIKE '/%' ESCAPE '#') ORDER BY CS.ID DESC";
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED \nCHANGESETS CS, FILECHANGES FC, REPOSITORIES R, FILES F, AUTHORS A WHERE R.PATH = '/var/tmp/source5923202038296723704opengrok/mercurial' AND F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 WHERE F2.ID = FC.FILE AND F2.REPOSITORY = R.ID AND F2.PATH LIKE '/%' ESCAPE '#') ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED  \nREPOSITORIES R -- DERBY-PROPERTIES constraint=REPOSITORIES_PATH \n,FILES F -- DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \n,FILECHANGES FC -- DERBY-PROPERTIES constraint=FILECHANGES_FILE_CHANGESET \n, AUTHORS A -- DERBY-PROPERTIES constraint=AUTHORS_REPOSITORY_NAME \n, CHANGESETS CS -- DERBY-PROPERTIES constraint=CHANGESETS_PRIMARY_ID \nWHERE R.PATH = '/var/tmp/source5923202038296723704opengrok/mercurial' AND F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 WHERE F2.ID = FC.FILE AND F2.REPOSITORY = R.ID AND F2.PATH LIKE '/%' ESCAPE '#') ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM  CHANGESETS CS, FILECHANGES FC, REPOSITORIES R, FILES F, AUTHORS A WHERE R.PATH = '/var/tmp/source5923202038296723704opengrok/mercurial' AND F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 WHERE F2.REPOSITORY = 1) ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED \nREPOSITORIES R, FILES F, FILECHANGES FC, AUTHORS A, CHANGESETS CS WHERE R.PATH = '/var/tmp/source5923202038296723704opengrok/mercurial' AND F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 WHERE F2.ID = FC.FILE AND F2.REPOSITORY = R.ID AND F2.PATH LIKE '/%' ESCAPE '#') ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED \nREPOSITORIES R --DERBY-PROPERTIES constraint=REPOSITORIES_PATH \n, FILES F --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \n, FILECHANGES FC --DERBY-PROPERTIES constraint=FILECHANGES_FILE_CHANGESET \n, AUTHORS A --DERBY-PROPERTIES constraint=AUTHORS_REPOSITORY_NAME \n, CHANGESETS CS --DERBY-PROPERTIES constraint=CHANGESETS_PRIMARY_ID \nWHERE R.PATH = '/var/tmp/source5923202038296723704opengrok/mercurial' AND F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \nWHERE F2.ID = FC.FILE AND F2.REPOSITORY = R.ID AND F2.PATH LIKE '/%' ESCAPE '#') ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED \nREPOSITORIES R --DERBY-PROPERTIES constraint=REPOSITORIES_PATH \n, FILES F --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \n, FILECHANGES FC --DERBY-PROPERTIES constraint=FILECHANGES_FILE_CHANGESET \n, AUTHORS A --DERBY-PROPERTIES constraint=AUTHORS_REPOSITORY_NAME \n, CHANGESETS CS --DERBY-PROPERTIES constraint=CHANGESETS_PRIMARY_ID \nWHERE R.PATH = '/var/tmp/source5923202038296723704opengrok/mercurial' AND F.REPOSITORY = R.ID AND A.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND A.ID = CS.AUTHOR AND EXISTS ( SELECT 1 FROM FILES F2 --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \nWHERE F2.ID = FC.FILE )ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED \nREPOSITORIES R --DERBY-PROPERTIES constraint=REPOSITORIES_PATH \n, FILES F --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \n, FILECHANGES FC --DERBY-PROPERTIES constraint=FILECHANGES_FILE_CHANGESET \n, CHANGESETS CS --DERBY-PROPERTIES constraint=CHANGESETS_PRIMARY_ID \nWHERE R.PATH = '/var/tmp/source5923202038296723704opengrok/mercurial' AND F.REPOSITORY = R.ID AND CS.REPOSITORY = R.ID AND CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND EXISTS (SELECT 1 FROM FILES F2 --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \nWHERE F2.ID = FC.FILE) ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED \nFILES F --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \n, FILECHANGES FC --DERBY-PROPERTIES constraint=FILECHANGES_FILE_CHANGESET \n, CHANGESETS CS --DERBY-PROPERTIES constraint=CHANGESETS_PRIMARY_ID \nWHERE CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND EXISTS ( SELECT 1 FROM FILES F2 --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \nWHERE F2.ID = FC.FILE) ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED \nFILES F --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \n, FILECHANGES FC --DERBY-PROPERTIES constraint=FILECHANGES_FILE_CHANGESET \n, CHANGESETS CS --DERBY-PROPERTIES constraint=CHANGESETS_PRIMARY_ID \nWHERE CS.ID = FC.CHANGESET AND F.ID = FC.FILE AND EXISTS ( SELECT 1 FROM FILES F2 --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \nWHERE F2.ID = FC.FILE) ORDER BY CS.ID";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, asc_result);
        sql1 = "SELECT CS.ID FROM --DERBY-PROPERTIES joinOrder=FIXED \nFILES F --DERBY-PROPERTIES constraint=FILES_REPOSITORY_PATH \n, FILECHANGES FC --DERBY-PROPERTIES constraint=FILECHANGES_FILE_CHANGESET \n, CHANGESETS CS --DERBY-PROPERTIES constraint=CHANGESETS_PRIMARY_ID \nWHERE CS.ID = FC.CHANGESET AND F.ID = FC.FILE ORDER BY CS.ID DESC";
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, desc_result);
    }

    public void testDerby4240OrderByCase() throws SQLException {
        String sql1 = "SELECT t1.id, t1.name FROM test2 t2 INNER JOIN test1 t1 ON t2.rel_id = t1.id WHERE t2.entity_id = 1 ORDER BY t1.id ASC";
        Statement s = this.createStatement();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet rs = s.executeQuery(sql1);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.whatSortingRequired());
        rs = s.executeQuery(sql1);
        String[][] result = new String[][]{{"101", "Pupy"}, {"102", "Tom"}, {"103", "Jerry"}};
        JDBC.assertFullResultSet(rs, result);
    }

    public void testAdditionalOrderByCases() throws SQLException {
        Statement s = this.createStatement();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        String sql1 = "select a.col1, b.col2, c.col2 from a, b, c where c.col1=3 order by a.col1, c.col1";
        ResultSet rs = s.executeQuery(sql1);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.whatSortingRequired());
        rs = s.executeQuery(sql1);
        String[][] result = new String[][]{{"1", "2", "3"}, {"1", "2", "3"}, {"1", "2", "3"}, {"1", "2", "3"}, {"1", "2", "3"}, {"1", "2", "3"}, {"1", "2", "3"}, {"1", "2", "3"}};
        JDBC.assertFullResultSet(rs, result);
        sql1 = "select a.col1, b.col2, c.col2 from a, b, c where a.col1=1 and b.col1 = 2 and c.col1=3 order by a.col1, b.col1, c.col1";
        rs = s.executeQuery(sql1);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndSortAvoidance.assertFalse((boolean)rtsp.whatSortingRequired());
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, result);
        sql1 = "select c.col1, b.col1, a.col1 from a, b, c where a.col1=1 and b.col1 = 2 and c.col1=3 order by c.col1, b.col1, a.col1";
        result = new String[][]{{"3", "2", "1"}, {"3", "2", "1"}, {"3", "2", "1"}, {"3", "2", "1"}, {"3", "2", "1"}, {"3", "2", "1"}, {"3", "2", "1"}, {"3", "2", "1"}};
        rs = s.executeQuery(sql1);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndSortAvoidance.assertFalse((boolean)rtsp.whatSortingRequired());
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, result);
        sql1 = "select c.col1, b.col1, a.col1 from a, b, c where a.col1=1 and b.col1 = 2 and c.col1=3 order by c.col2, b.col2, a.col2";
        rs = s.executeQuery(sql1);
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.whatSortingRequired());
        rs = s.executeQuery(sql1);
        JDBC.assertFullResultSet(rs, result);
    }

    public void testForceSortWithOptimizerOverrides() throws SQLException {
        Statement s = this.createStatement();
        String sql1 = "SELECT table1.id, m0.value, m1.value FROM  --DERBY-PROPERTIES joinOrder=FIXED \ntable2  m0, table2 m1, table1 WHERE table1.id=m0.id AND m0.name='PageSequenceId' AND table1.id=m1.id AND m1.name='PostComponentId' AND m1.value='21857' ORDER BY m0.value";
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet rs = s.executeQuery(sql1);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.usedTableScan("TABLE2"));
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.whatSortingRequired());
        rs = s.executeQuery(sql1);
        String[][] result = new String[][]{{"4294967297", "000001", "21857"}, {"2147483653", "000002", "21857"}, {"2147483654", "000003", "21857"}};
        JDBC.assertFullResultSet(rs, result);
    }

    public void testWithNoOptimizerOverrides() throws SQLException {
        Statement s = this.createStatement();
        String sql1 = "SELECT table1.id, m0.value, m1.value FROM table1, table2 m0, table2 m1 WHERE table1.id=m0.id AND m0.name='PageSequenceId' AND table1.id=m1.id AND m1.name='PostComponentId' AND m1.value='21857' ORDER BY m0.value";
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet rs = s.executeQuery(sql1);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TABLE2", "KEY3"));
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.whatSortingRequired());
        rs = s.executeQuery(sql1);
        String[][] result = new String[][]{{"4294967297", "000001", "21857"}, {"2147483653", "000002", "21857"}, {"2147483654", "000003", "21857"}};
        JDBC.assertFullResultSet(rs, result);
    }

    public void testForcedIndexUseForWrongOrder() throws SQLException {
        Statement s = this.createStatement();
        String sql1 = "SELECT table1.id, m0.value, m1.value \nFROM  --DERBY-PROPERTIES joinOrder=FIXED \ntable2  m1 -- DERBY-PROPERTIES index=key3 \n,  table2 m0 -- DERBY-PROPERTIES index=key3 \n, table1 WHERE table1.id=m0.id AND m0.name='PageSequenceId' AND table1.id=m1.id AND m1.name='PostComponentId' AND  m1.value='21857' ORDER BY m0.value";
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet rs = s.executeQuery(sql1);
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("TABLE2", "KEY3"));
        OrderByAndSortAvoidance.assertTrue((boolean)rtsp.whatSortingRequired());
        rs = s.executeQuery(sql1);
        String[][] result = new String[][]{{"4294967297", "000001", "21857"}, {"2147483653", "000002", "21857"}, {"2147483654", "000003", "21857"}};
        JDBC.assertFullResultSet(rs, result);
    }

    public void testDerby6148() throws SQLException {
        Statement s = this.createStatement();
        this.createTablesForDerby6148(s);
        this.insertDataForDerby6148();
        this.createIndexesForDerby6148(s);
        String brokenQuery = "SELECT t.id, t.item, title     FROM d6148_tests t         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                              constraint = d6148_tests_1\n       , d6148_item_usage u         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                             constraint = d6148_item_usage_1\n    WHERE username = 'MICKEY' AND           u.item = t.item ORDER BY t.item, title";
        String goodQuery1 = "SELECT t.id, t.item, title     FROM d6148_item_usage u         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                             constraint = d6148_item_usage_1\n       , d6148_tests t         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                              constraint = d6148_tests_1\n    WHERE username = 'MICKEY' AND           u.item = t.item ORDER BY t.item, title";
        String goodQuery2 = "SELECT t.id, t.item, title     FROM d6148_tests t         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                              constraint = d6148_tests_1\n       , d6148_item_usage u         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                             constraint = d6148_item_usage_1\n    WHERE username = 'MICKEY' AND           u.item = t.item ORDER BY u.item, title";
        String[][] expectedRows = this.getExpectedRowsDerby6148();
        JDBC.assertFullResultSet(s.executeQuery("SELECT t.id, t.item, title     FROM d6148_tests t         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                              constraint = d6148_tests_1\n       , d6148_item_usage u         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                             constraint = d6148_item_usage_1\n    WHERE username = 'MICKEY' AND           u.item = t.item ORDER BY t.item, title"), expectedRows);
        JDBC.assertFullResultSet(s.executeQuery("SELECT t.id, t.item, title     FROM d6148_item_usage u         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                             constraint = d6148_item_usage_1\n       , d6148_tests t         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                              constraint = d6148_tests_1\n    WHERE username = 'MICKEY' AND           u.item = t.item ORDER BY t.item, title"), expectedRows);
        JDBC.assertFullResultSet(s.executeQuery("SELECT t.id, t.item, title     FROM d6148_tests t         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                              constraint = d6148_tests_1\n       , d6148_item_usage u         -- DERBY-PROPERTIES joinStrategy = NESTEDLOOP,                             constraint = d6148_item_usage_1\n    WHERE username = 'MICKEY' AND           u.item = t.item ORDER BY u.item, title"), expectedRows);
    }

    private String[][] getExpectedRowsDerby6148() {
        return new String[][]{{"15", "60001", "Test 15         "}, {"19", "60001", "Test 19         "}, {"25", "60001", "Test 25         "}, {"27", "60001", "Test 27         "}, {"28", "60001", "Test 28         "}, {"10", "61303", "Test 10         "}, {"11", "61303", "Test 11         "}, {"13", "61303", "Test 13         "}, {"14", "61303", "Test 14         "}, {"21", "61303", "Test 21         "}, {"35", "61303", "Test 35         "}, {"9", "61303", "Test 9          "}, {"26", "7205731", "Test 26         "}, {"32", "7205731", "Test 32         "}, {"4", "7205731", "Test 4          "}, {"5", "7205731", "Test 5          "}, {"6", "7205731", "Test 6          "}, {"7", "7205731", "Test 7          "}, {"8", "7205731", "Test 8          "}, {"1", "XY101", "Test 1          "}, {"12", "XY101", "Test 12         "}, {"16", "XY101", "Test 16         "}, {"17", "XY101", "Test 17         "}, {"18", "XY101", "Test 18         "}, {"2", "XY101", "Test 2          "}, {"22", "XY101", "Test 22         "}, {"23", "XY101", "Test 23         "}, {"24", "XY101", "Test 24         "}, {"3", "XY101", "Test 3          "}, {"31", "XY101", "Test 31         "}};
    }

    private void createTablesForDerby6148(Statement s) throws SQLException {
        s.executeUpdate("create table d6148_tests (    id integer not null generated always as identity         (start with 1, increment by 1),     item varchar(15) not null,     title varchar(255) not null)");
        s.executeUpdate("create table d6148_item_usage (    username varchar(15) not null,     item varchar(15) not null,     value smallint default 0)");
        s.executeUpdate("create table d6148_items (    item varchar(15) not null,     name varchar(255) not null,     special char(1) default null)");
        s.executeUpdate("create table d6148_users (    username varchar(15) not null,     surname varchar(255) not null)");
    }

    private void createIndexesForDerby6148(Statement s) throws SQLException {
        s.executeUpdate("alter table d6148_items add constraint     d6148_items_pk primary key (item)");
        s.executeUpdate("alter table d6148_item_usage add constraint     d6148_item_usage_pk primary key (username, item)");
        s.executeUpdate("alter table d6148_users add constraint     users_pk primary key (username)");
        s.executeUpdate("alter table d6148_tests add constraint     d6148_tests_pk primary key (id)");
        s.executeUpdate("alter table d6148_tests add constraint     d6148_tests_1 unique (item, title)");
        s.executeUpdate("alter table d6148_item_usage add constraint     d6148_item_usage_2 foreign key (item) references     d6148_items (item) on delete cascade on update no action");
        s.executeUpdate("alter table d6148_item_usage add constraint     d6148_item_usage_1 foreign key (username) references     d6148_users (username) on delete cascade on update no action");
        s.executeUpdate("alter table d6148_tests add constraint     d6148_tests_2 foreign key (item) references     d6148_items (item) on delete cascade on update no action");
    }

    private void insertDataForDerby6148() throws SQLException {
        String[][] users = new String[][]{{"ADMIN", "Administrator"}, {"MINNIE", "MOUSE"}, {"MICKEY", "MOUSE"}, {"TEST", "Test"}, {"PIED", "Piper"}, {"WINNIE", "Pooh"}, {"DONALD", "Duck"}, {"CLARK", "Kent"}, {"VARG", "Veum"}, {"TOMMY", "Tiger"}, {"USER1", "?????"}, {"DEMO", "Demo"}, {"BRAM", "Stoker"}, {"USER2", "???????"}, {"USER3", "?????"}};
        PreparedStatement ps = this.prepareStatement("insert into d6148_users values (?,?)");
        for (String[] u : users) {
            ps.setString(1, u[0]);
            ps.setString(2, u[1]);
            ps.executeUpdate();
        }
        String[][] items = new String[][]{{"XY101", "XY101", null}, {"61303", "61303", null}, {"7205731", "7205731", null}, {"60001", "60001", null}, {"60001B", "60001B", null}, {"61108", "61108", null}};
        ps = this.prepareStatement("insert into d6148_items values (?,?,?)");
        for (String[] i : items) {
            ps.setString(1, i[0]);
            ps.setString(2, i[1]);
            ps.setString(3, i[2]);
            ps.executeUpdate();
        }
        String[][] tests = new String[][]{{"XY101", "Test 1          "}, {"XY101", "Test 2          "}, {"XY101", "Test 3          "}, {"7205731", "Test 4          "}, {"7205731", "Test 5          "}, {"7205731", "Test 6          "}, {"7205731", "Test 7          "}, {"7205731", "Test 8          "}, {"61303", "Test 9          "}, {"61303", "Test 10         "}, {"61303", "Test 11         "}, {"XY101", "Test 12         "}, {"61303", "Test 13         "}, {"61303", "Test 14         "}, {"60001", "Test 15         "}, {"XY101", "Test 16         "}, {"XY101", "Test 17         "}, {"XY101", "Test 18         "}, {"60001", "Test 19         "}, {"60001B", "Test 20         "}, {"61303", "Test 21         "}, {"XY101", "Test 22         "}, {"XY101", "Test 23         "}, {"XY101", "Test 24         "}, {"60001", "Test 25         "}, {"7205731", "Test 26         "}, {"60001", "Test 27         "}, {"60001", "Test 28         "}, {"60001B", "Test 29         "}, {"60001B", "Test 30         "}, {"XY101", "Test 31         "}, {"7205731", "Test 32         "}, {"60001B", "Test 33         "}, {"60001B", "Test 34         "}, {"61303", "Test 35         "}};
        ps = this.prepareStatement("insert into d6148_tests values (default,?,?)");
        for (String[] t : tests) {
            ps.setString(1, t[0]);
            ps.setString(2, t[1]);
            ps.executeUpdate();
        }
        String[][] item_usage = new String[][]{{"MINNIE", "XY101", "4"}, {"MICKEY", "XY101", "4"}, {"MICKEY", "61303", "4"}, {"MICKEY", "7205731", "4"}, {"PIED", "61303", "2"}, {"TOMMY", "60001", "1"}, {"USER1", "60001", "0"}, {"BRAM", "60001", "2"}, {"WINNIE", "7205731", "1"}, {"MICKEY", "60001", "4"}, {"DONALD", "60001", "2"}, {"PIED", "60001", "2"}, {"VARG", "60001", "2"}, {"CLARK", "60001", "2"}, {"TEST", "60001B", "0"}, {"DEMO", "61303", "0"}, {"DONALD", "61303", "2"}, {"DONALD", "60001B", "4"}, {"DEMO", "XY101", "0"}, {"USER2", "61303", "0"}, {"USER3", "61303", "0"}, {"MICKEY", "61108", "4"}, {"MINNIE", "60001B", "0"}};
        ps = this.prepareStatement("insert into d6148_item_usage values (?,?,?)");
        for (String[] iu : item_usage) {
            ps.setString(1, iu[0]);
            ps.setString(2, iu[1]);
            ps.setString(3, iu[2]);
            ps.executeUpdate();
        }
    }
}

