/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MiscErrorsTest
extends BaseJDBCTestCase {
    public MiscErrorsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(MiscErrorsTest.class);
    }

    public void testLexicalError() {
        String sql = "select @#^%*&! from swearwords";
        this.assertCompileError("42X02", sql);
    }

    public void testDuplicateTableCreation() throws SQLException {
        String sql = "create table a (one int)";
        Statement st = this.createStatement();
        st.executeUpdate(sql);
        sql = "create table a (one int, two int)";
        MiscErrorsTest.assertStatementError("X0Y32", st, sql);
        sql = "create table a (one int)";
        MiscErrorsTest.assertStatementError("X0Y32", st, sql);
        this.dropTable("a");
        sql = "create table a (one int, two int, three int)";
        st.executeUpdate(sql);
        sql = "insert into a values (1,2,3)";
        MiscErrorsTest.assertEquals((int)1, (int)st.executeUpdate(sql));
        sql = "select * from a";
        JDBC.assertUnorderedResultSet(st.executeQuery(sql), new String[][]{{"1", "2", "3"}});
        this.dropTable("a");
    }

    public void testStatementCache() throws SQLException {
        String sql = "values 1";
        Statement st = this.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), "1");
        sql = "select SQL_TEXT from syscs_diag.statement_cache where CAST(SQL_TEXT AS LONG VARCHAR) LIKE '%values 1%'";
        JDBC.assertUnorderedResultSet(st.executeQuery(sql), new String[][]{{sql}, {"values 1"}});
        sql = "select SQL_TEXT from syscs_diag.statement_cache where CAST(SQL_TEXT AS LONG VARCHAR) LIKE '%932432%'";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), sql);
        sql = "VALUES FRED932432";
        this.assertCompileError("42X04", sql);
        sql = "SELECT * FROM BILL932432";
        this.assertCompileError("42X05", sql);
        sql = "SELECT 932432";
        this.assertCompileError("42X01", sql);
        sql = "select SQL_TEXT from syscs_diag.statement_cache where CAST(SQL_TEXT AS LONG VARCHAR) LIKE '%932432%'";
        JDBC.assertSingleValueResultSet(st.executeQuery(sql), sql);
    }
}

