/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.util.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LuceneSupportTest
extends BaseJDBCTestCase {
    private static final String ILLEGAL_CHARACTER = "42XBD";

    public LuceneSupportTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("LuceneSupportTest");
        Test baseTest = TestConfiguration.embeddedSuite(LuceneSupportTest.class);
        TestSetup singleUseTest = TestConfiguration.singleUseDatabaseDecorator(baseTest);
        LocaleTestSetup localizedTest = new LocaleTestSetup((Test)singleUseTest, new Locale("en", "US"));
        suite.addTest(SecurityManagerSetup.noSecurityManager((Test)localizedTest));
        return suite;
    }

    public void testCreateAndQueryIndex() throws Exception {
        Statement s = this.createStatement();
        this.getConnection().prepareStatement("create function getDatabaseLocale() returns varchar( 20 )\nlanguage java parameter style java reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest.getDatabaseLocale()'\n").executeUpdate();
        JDBC.assertFullResultSet(s.executeQuery("values ( substr( getDatabaseLocale(), 1, 2 ) )"), new String[][]{{"en"}});
        this.getConnection().prepareStatement("drop function getDatabaseLocale").executeUpdate();
        CallableStatement cSt = this.prepareCall("call LuceneSupport.createIndex('lucenetest','titles','title', null )");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
        String[][] expectedRows = new String[][]{{"1", "0", "0.8048013"}, {"3", "2", "0.643841"}};
        JDBC.assertFullResultSet(s.executeQuery("select * from table ( lucenetest.titles__title( 'grapes', 1000, null ) ) luceneResults"), expectedRows);
        expectedRows = new String[][]{{"3", "2", "0.643841"}};
        JDBC.assertFullResultSet(s.executeQuery("select * from table ( lucenetest.titles__title( 'grapes', 1000, .75 ) ) luceneResults"), expectedRows);
        JDBC.assertEmpty(s.executeQuery("select * from table ( lucenetest.titles__title( 'grapes',  1000, 0.5) ) luceneResults"));
        expectedRows = new String[][]{{"The Grapes Of Wrath", "John Steinbeck", "The Viking Press", "0"}, {"Vines, Grapes, and Wines", "Jancis Robinson", "Alfred A. Knopf", "2"}};
        JDBC.assertFullResultSet(s.executeQuery("select title, author, publisher, documentID\nfrom lucenetest.titles t, table ( lucenetest.titles__title( 'grapes', 1000, null ) ) l\nwhere t.id = l.id\n"), expectedRows);
        cSt = this.prepareCall("call LuceneSupport.dropIndex('lucenetest','titles','title')");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
    }

    public void testUpdateIndex() throws Exception {
        Statement s = this.createStatement();
        CallableStatement cSt = this.prepareCall("call LuceneSupport.createIndex('lucenetest','titles','title', null)");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
        JDBC.assertEmpty(s.executeQuery("select *\nfrom table ( lucenetest.titles__title( 'mice', 1000, null ) ) luceneResults\n"));
        cSt = this.prepareCall("update TITLES SET TITLE='Of Mice and Men' WHERE ID=1");
        LuceneSupportTest.assertUpdateCount(cSt, 1);
        JDBC.assertEmpty(s.executeQuery("select *\nfrom table ( lucenetest.titles__title( 'mice', 1000, null ) ) luceneResults\n"));
        cSt = this.prepareCall("call LuceneSupport.updateIndex('lucenetest','titles','title', null)");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
        String[][] expectedRows = new String[][]{{"1", "0", "1.058217"}};
        JDBC.assertFullResultSet(s.executeQuery("select *\nfrom table ( lucenetest.titles__title( 'mice', 1000, null ) ) luceneResults\n"), expectedRows);
        cSt = this.prepareCall("call LuceneSupport.dropIndex('lucenetest','titles','title')");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
    }

    public void testListIndex() throws Exception {
        Statement s = this.createStatement();
        CallableStatement cSt = this.prepareCall("call LuceneSupport.createIndex('lucenetest','titles','title', null)");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
        cSt = this.prepareCall("call LuceneSupport.createIndex('lucenetest','titles','author', null)");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
        String[][] expectedRows = new String[][]{{"LUCENETEST", "TITLES", "AUTHOR"}, {"LUCENETEST", "TITLES", "TITLE"}};
        JDBC.assertFullResultSet(s.executeQuery("select schemaname, tablename, columnname from table ( LuceneSupport.listIndexes() ) listindexes order by schemaname, tablename, columnname"), expectedRows);
        cSt = this.prepareCall("call LuceneSupport.dropIndex('lucenetest','titles','title')");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
        expectedRows = new String[][]{{"LUCENETEST", "TITLES", "AUTHOR"}};
        JDBC.assertFullResultSet(s.executeQuery("select schemaname, tablename, columnname from table ( LuceneSupport.listIndexes() ) listindexes order by schemaname, tablename, columnname"), expectedRows);
        cSt = this.prepareCall("call LuceneSupport.dropIndex('lucenetest','titles','author')");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
        JDBC.assertEmpty(s.executeQuery("select schemaname, tablename, columnname from table ( LuceneSupport.listIndexes() ) listindexes"));
    }

    public void testDropIndexBadCharacters() throws Exception {
        this.assertCallError(ILLEGAL_CHARACTER, "call LuceneSupport.dropIndex('../','','')");
        this.assertCallError(ILLEGAL_CHARACTER, "call LuceneSupport.dropIndex('','../','')");
        this.assertCallError(ILLEGAL_CHARACTER, "call LuceneSupport.dropIndex('','','../')");
    }

    public void testMultipleFields() throws SQLException {
        LuceneSupportTest.println("Running multi-field test.");
        Statement s = this.createStatement();
        s.execute("create table multifield(id int primary key, c clob)");
        s.execute("insert into multifield values (1, '<document><secret/>No one must know!</document>'), (2, '<document>No secret here!</document>')");
        s.execute("call lucenesupport.createindex('lucenetest', 'multifield', 'c', '" + ((Object)((Object)this)).getClass().getName() + ".makeMultiFieldIndexDescriptor')");
        PreparedStatement ps = this.prepareStatement("select id from table(multifield__c(?, 100, null)) t");
        String[][] bothRows = new String[][]{{"1"}, {"2"}};
        ps.setString(1, "text:secret");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "2");
        ps.setString(1, "tags:secret");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        ps.setString(1, "secret");
        JDBC.assertUnorderedResultSet(ps.executeQuery(), bothRows);
    }

    public static LuceneIndexDescriptor makeMultiFieldIndexDescriptor() {
        return new MultiFieldIndexDescriptor();
    }

    public static QueryParser createXMLQueryParser(Version version, String[] fields, Analyzer analyzer) {
        return new MultiFieldQueryParser(version, fields, (Analyzer)new StandardAnalyzer(version));
    }

    private static Document parseXMLDocument(Reader reader) {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(reader));
            reader.close();
        }
        catch (Exception e) {
            LuceneSupportTest.fail("Failed to parse XML document", e);
        }
        return doc;
    }

    private static List<String> getAllXMLTags(Node node) {
        ArrayList<String> list = new ArrayList<String>();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            list.add(n.getNodeName());
            list.addAll(LuceneSupportTest.getAllXMLTags(n));
        }
        return list;
    }

    private static void getAllText(Node node, StringBuilder sb) {
        if (node.getNodeType() == 3) {
            sb.append(node.getNodeValue());
        } else {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                LuceneSupportTest.getAllText(nl.item(i), sb);
            }
        }
    }

    protected void setUp() throws SQLException {
        Statement st = this.createStatement();
        try {
            st.executeUpdate("create schema lucenetest");
        }
        catch (Exception exception) {
            // empty catch block
        }
        st.executeUpdate("set schema lucenetest");
        st.executeUpdate("create table titles (ID int generated always as identity primary key, ISBN varchar(16), PRINTISBN varchar(16), title varchar(1024), subtitle varchar(1024), author varchar(1024), series varchar(1024), publisher varchar(1024), collections varchar(128), collections2 varchar(128))");
        st.executeUpdate("insert into titles (ISBN, PRINTISBN, TITLE, SUBTITLE, AUTHOR, SERIES, PUBLISHER, COLLECTIONS, COLLECTIONS2) values ('9765087650324','9765087650324','The Grapes Of Wrath','The Great Depression in Oklahoma','John Steinbeck','Noble Winners','The Viking Press','National Book Award','Pulitzer Prize')");
        st.executeUpdate("insert into titles (ISBN, PRINTISBN, TITLE, SUBTITLE, AUTHOR, SERIES, PUBLISHER, COLLECTIONS, COLLECTIONS2) values ('6754278542987','6754278542987','Identical: Portraits of Twins','Best Photo Book 2012 by American Photo Magazine','Martin Schoeller','Portraits','teNeues','Photography','')");
        st.executeUpdate("insert into titles (ISBN, PRINTISBN, TITLE, SUBTITLE, AUTHOR, SERIES, PUBLISHER, COLLECTIONS, COLLECTIONS2) values ('2747583475882','2747583475882','Vines, Grapes, and Wines','The wine drinker''s guide to grape varieties','Jancis Robinson','Reference','Alfred A. Knopf','Wine','')");
        st.executeUpdate("insert into titles (ISBN, PRINTISBN, TITLE, SUBTITLE, AUTHOR, SERIES, PUBLISHER, COLLECTIONS, COLLECTIONS2) values ('4356123483483','4356123483483','A Tale of Two Cities','A fictional account of events leading up to the French revolution','Charles Dickens','Classics','Chapman & Hall','Fiction','Social Criticism')");
        CallableStatement cSt = this.prepareCall("call syscs_util.syscs_register_tool('luceneSupport',true)");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
    }

    @Override
    protected void tearDown() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("drop table titles");
        CallableStatement cSt = this.prepareCall("call syscs_util.syscs_register_tool('luceneSupport',false)");
        LuceneSupportTest.assertUpdateCount(cSt, 0);
        super.tearDown();
    }

    public static class MultiFieldIndexDescriptor
    implements LuceneIndexDescriptor {
        public String[] getFieldNames() {
            return new String[]{"tags", "text"};
        }

        public Analyzer getAnalyzer() {
            return new XMLAnalyzer();
        }

        public QueryParser getQueryParser() {
            Version version = LuceneUtils.currentVersion();
            return new MultiFieldQueryParser(version, this.getFieldNames(), (Analyzer)new StandardAnalyzer(version));
        }
    }

    private static class XMLTagsTokenizer
    extends AbstractTokenizer {
        XMLTagsTokenizer(Reader in) {
            super(in);
        }

        @Override
        Iterable<String> getTokens() {
            return LuceneSupportTest.getAllXMLTags(LuceneSupportTest.parseXMLDocument(this.input));
        }
    }

    private static class XMLTextTokenizer
    extends AbstractTokenizer {
        XMLTextTokenizer(Reader in) {
            super(in);
        }

        @Override
        Iterable<String> getTokens() {
            StringBuilder text = new StringBuilder();
            LuceneSupportTest.getAllText(LuceneSupportTest.parseXMLDocument(this.input), text);
            return Arrays.asList(text.toString().split("[ \r\n\t]"));
        }
    }

    private static abstract class AbstractTokenizer
    extends Tokenizer {
        Iterator<String> tokens;
        final CharTermAttribute charTermAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        final PositionIncrementAttribute posIncrAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

        AbstractTokenizer(Reader reader) {
            super(reader);
        }

        public boolean incrementToken() throws IOException {
            if (this.tokens == null) {
                this.tokens = this.getTokens().iterator();
            }
            if (this.tokens.hasNext()) {
                this.charTermAttr.setEmpty();
                this.charTermAttr.append(this.tokens.next());
                this.posIncrAttr.setPositionIncrement(1);
                return true;
            }
            return false;
        }

        public void reset() throws IOException {
            this.tokens = null;
            super.reset();
        }

        abstract Iterable<String> getTokens();
    }

    public static class XMLAnalyzer
    extends Analyzer {
        public XMLAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            if (fieldName.equals("text")) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new XMLTextTokenizer(reader));
            }
            if (fieldName.equals("tags")) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new XMLTagsTokenizer(reader));
            }
            Assert.fail((String)("unknown field name: " + fieldName));
            return null;
        }
    }
}

