/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class DB2IsolationLevelsTest
extends BaseJDBCTestCase {
    public DB2IsolationLevelsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("DB2IsolationLevelsTest Test");
        suite.addTest(TestConfiguration.defaultSuite(DB2IsolationLevelsTest.class));
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createStatement().executeUpdate("create table t1(c1 int not null constraint asdf primary key)");
    }

    @Override
    public void tearDown() throws Exception {
        this.createStatement().executeUpdate("drop table t1");
        super.tearDown();
    }

    public void test_DB2IsolationLevelsTest() throws Exception {
        Statement st = this.createStatement();
        PreparedStatement ps = this.prepareStatement("values current isolation");
        this.setAutoCommit(false);
        st.executeUpdate("call syscs_util.syscs_set_runtimestatistics(1)");
        st.executeUpdate("insert into t1 values 1");
        this.assertQueryResult(st.executeQuery("select * from t1"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at read committed isolation level using instantaneous share row locking chosen by the optimizer");
        this.assertIsolation(ps, "CS");
        st.executeUpdate("set isolation RR");
        this.assertIsolation(ps, "RR");
        this.rollback();
        this.assertQueryResult(st.executeQuery("select * from t1"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at serializable isolation level using share table locking chosen by the optimizer");
        st.executeUpdate("set isolation reset");
        this.assertIsolation(ps, " ");
        st.executeUpdate("set isolation read committed");
        this.assertIsolation(ps, "CS");
        this.rollback();
        this.assertQueryResult(st.executeQuery("select * from t1"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at read committed isolation level using instantaneous share row locking chosen by the optimizer");
        st.executeUpdate("set isolation to reset");
        this.assertIsolation(ps, " ");
        st.executeUpdate("set current isolation = RS");
        this.assertIsolation(ps, "RS");
        this.rollback();
        this.assertQueryResult(st.executeQuery("select * from t1"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at repeatable read isolation level using share row locking chosen by the optimizer");
        st.executeUpdate("set isolation reset");
        this.assertIsolation(ps, " ");
        st.executeUpdate("set isolation = dirty read");
        this.assertIsolation(ps, "UR");
        this.rollback();
        this.assertQueryResult(st.executeQuery("select * from t1"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at read uncommitted isolation level using share row locking chosen by the optimizer");
        st.executeUpdate("set isolation serializable");
        this.assertIsolation(ps, "RR");
        this.assertQueryResult(st.executeQuery("select * from t1 with CS"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at read committed isolation level using instantaneous share row locking chosen by the optimizer");
        st.executeUpdate("set isolation cursor stability");
        this.assertIsolation(ps, "CS");
        this.assertQueryResult(st.executeQuery("select * from t1 with RR"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at serializable isolation level using share table locking chosen by the optimizer");
        st.executeUpdate("set isolation serializable");
        this.assertIsolation(ps, "RR");
        this.assertQueryResult(st.executeQuery("select * from t1 with RS"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at repeatable read isolation level using share row locking chosen by the optimizer");
        st.executeUpdate("set current isolation to read committed");
        this.assertIsolation(ps, "CS");
        this.assertQueryResult(st.executeQuery("select * from t1 with ur"));
        this.assertPlan(st, "Index Scan ResultSet for T1 using constraint ASDF at read uncommitted isolation level using share row locking chosen by the optimizer");
        String e = "42X01";
        DB2IsolationLevelsTest.assertStatementError("42X01", st, "select * from t1 with rw");
        DB2IsolationLevelsTest.assertStatementError("42X01", st, "select * from t1 with dirty read");
        DB2IsolationLevelsTest.assertStatementError("42X01", st, "select * from t1 with read uncommitted");
        DB2IsolationLevelsTest.assertStatementError("42X01", st, "select * from t1 with read committed");
        DB2IsolationLevelsTest.assertStatementError("42X01", st, "select * from t1 with cursor stability");
        DB2IsolationLevelsTest.assertStatementError("42X01", st, "select * from t1 with repeatable read");
        DB2IsolationLevelsTest.assertStatementError("42X01", st, "select * from t1 with serializable");
        st.executeUpdate("create table db2iso(cs int, rr int, ur int, rs int)");
        ResultSet rs = st.executeQuery("select cs, rr, ur, rs from db2iso");
        JDBC.assertEmpty(rs);
        this.rollback();
    }

    private void assertQueryResult(ResultSet rs) throws SQLException {
        JDBC.assertColumnNames(rs, "C1");
        JDBC.assertFullResultSet(rs, (Object[][])new String[][]{{"1"}}, true);
        rs.close();
    }

    private void assertPlan(Statement s, String expected) throws SQLException {
        SQLUtilities.getRuntimeStatisticsParser(s).assertSequence(new String[]{expected});
    }

    private void assertIsolation(PreparedStatement p, String expected) throws SQLException {
        ResultSet rs = p.executeQuery();
        JDBC.assertColumnNames(rs, "1");
        JDBC.assertFullResultSet(rs, (Object[][])new String[][]{{expected}}, true);
        rs.close();
    }
}

