/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.SQLException;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AuthenticationTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XADSAuthenticationTest
extends AuthenticationTest {
    public XADSAuthenticationTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("");
        }
        BaseTestSuite suite = new BaseTestSuite("XADSAuthenticationTest");
        suite.addTest(XADSAuthenticationTest.baseSuite("XADSAuthenticationTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(XADSAuthenticationTest.baseSuite("XADSAuthenticationTest:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite("XADSAuthenticationTest");
        XADSAuthenticationTest test = new XADSAuthenticationTest("testConnectShutdownAuthentication");
        XADSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new XADSAuthenticationTest("testUserFunctions");
        XADSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new XADSAuthenticationTest("testNotFullAccessUsers");
        XADSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new XADSAuthenticationTest("testChangePasswordAndDatabasePropertiesOnly");
        XADSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new XADSAuthenticationTest("testGreekCharacters");
        XADSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new XADSAuthenticationTest("testSystemShutdown");
        XADSAuthenticationTest.setBaseProps(suite, (Test)test);
        return TestConfiguration.singleUseDatabaseDecorator((Test)suite);
    }

    @Override
    protected void assertConnectionOK(String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        xads.getXAConnection(user, password).close();
    }

    @Override
    protected void assertConnectionWOUPOK(String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "user", user);
        JDBCDataSource.setBeanProperty(xads, "password", password);
        xads.getXAConnection().close();
    }

    @Override
    protected void assertConnectionFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        try {
            xads.getXAConnection(user, password);
            XADSAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sqle) {
            XADSAuthenticationTest.assertSQLState(expectedSqlState, sqle);
        }
    }

    @Override
    protected void assertConnectionWOUPFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "user", user);
        JDBCDataSource.setBeanProperty(xads, "password", password);
        try {
            xads.getXAConnection();
            XADSAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertShutdownUsingSetShutdownOK(String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "shutdownDatabase", "shutdown");
        try {
            xads.getXAConnection(user, password);
            XADSAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState("08006", e);
        }
    }

    @Override
    protected void assertShutdownUsingConnAttrsOK(String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "connectionAttributes", "shutdown=true");
        try {
            xads.getXAConnection(user, password);
            XADSAuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState("08006", e);
        }
    }

    @Override
    protected void assertShutdownWOUPOK(String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xads, "user", user);
        JDBCDataSource.setBeanProperty(xads, "password", password);
        try {
            xads.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState("08006", e);
        }
    }

    @Override
    protected void assertShutdownFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        try {
            xads.getXAConnection(user, password);
            XADSAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertShutdownWOUPFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "user", user);
        JDBCDataSource.setBeanProperty(xads, "password", password);
        try {
            xads.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertSystemShutdownOK(String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "user", user);
        JDBCDataSource.setBeanProperty(xads, "password", password);
        try {
            xads.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected system shutdown resulting in XJ015 error");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState("XJ015", e);
        }
    }

    @Override
    protected void assertSystemShutdownFail(String expectedError, String dbName, String user, String password) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xads, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(xads, "user", user);
        JDBCDataSource.setBeanProperty(xads, "password", password);
        try {
            xads.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState(expectedError, e);
        }
    }

    @Override
    public void assertConnectionFail(String dbName) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        if (XADSAuthenticationTest.usingDerbyNetClient()) {
            JDBCDataSource.setBeanProperty(xads, "user", "APP");
        } else {
            JDBCDataSource.clearStringBeanProperty(xads, "user");
        }
        JDBCDataSource.clearStringBeanProperty(xads, "password");
        JDBCDataSource.setBeanProperty(xads, "databaseName", dbName);
        try {
            xads.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected connection to fail");
        }
        catch (SQLException e) {
            XADSAuthenticationTest.assertSQLState("08004", e);
        }
    }
}

