/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.c3AsciiStream;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.c3Reader;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CharacterStreamsTest
extends BaseJDBCTestCase {
    private static final String ASCII_VALUE = "Lieberman ran with Gore";
    private static final int LEN_ASCII_VALUE = 23;
    private static final String CHAR_VALUE1 = "A Mississippi Republican";
    private static final int LEN_CHAR_VALUE1 = 24;
    private static final String CHAR_VALUE2 = "Lott has apologized";
    private static final int LEN_CHAR_VALUE2 = 19;

    public static Test suite() {
        return TestConfiguration.embeddedSuite(CharacterStreamsTest.class);
    }

    public CharacterStreamsTest(String name) {
        super(name);
    }

    public void testSetAsciiStreamIntoChar() throws Exception {
        this.runTestSetAsciiStream(1);
    }

    public void testSetAsciiStreamIntoVarchar() throws Exception {
        this.runTestSetAsciiStream(2);
    }

    public void testSetAsciiStreamIntoLongVarchar() throws Exception {
        this.runTestSetAsciiStream(3);
    }

    public void testSetAsciiStreamIntoClob() throws Exception {
        this.runTestSetAsciiStream(4);
    }

    public void testSetCharacterStreamIntoChar() throws Exception {
        this.runTestSetCharacterStream(1);
    }

    public void testSetCharacterStreamIntoVarchar() throws Exception {
        this.runTestSetCharacterStream(2);
    }

    public void testSetCharacterStreamIntoLongVarchar() throws Exception {
        this.runTestSetCharacterStream(3);
    }

    public void testSetCharacterStreamIntoClob() throws Exception {
        this.runTestSetCharacterStream(4);
    }

    public void testSetAsciiStreamLongValues() throws Exception {
        this.runTestSetAsciiStreamLongValues();
    }

    public void testSetCharacterStreamLongValues() throws Exception {
        this.runTestSetCharacterStreamLongValues();
    }

    private void runTestSetAsciiStream(int col) throws Exception {
        PreparedStatement psi = this.prepareStatement("insert into charstream(c, vc, lvc, lob) values(?,?,?,?)");
        PreparedStatement psq = this.prepareStatement("select id, c, {fn length(c)} AS CLEN, cast (vc as varchar(25)) AS VC, {fn length(vc)} AS VCLEN, cast (lvc as varchar(25)) AS LVC, {fn length(lvc)} AS LVCLEN, cast (lob as varchar(25)) AS LOB, {fn length(lob)} AS LOBLEN from charstream where id > ? order by 1");
        CharacterStreamsTest.println("\nTest setAsciiStream into CHAR");
        psi.setString(1, null);
        psi.setString(2, null);
        psi.setString(3, null);
        psi.setString(4, null);
        int maxid = this.getMaxId();
        this.setAscii(psi, col);
        psq.setInt(1, maxid);
        this.verifyAsciiStreamResults(psq.executeQuery(), col);
        PreparedStatement psStreams = this.prepareStatement("SELECT id, c, vc, lvc, lob FROM charstream where id > ? order by 1");
        psStreams.setInt(1, maxid);
        this.verifyResultsUsingAsciiStream(psStreams.executeQuery(), col);
        this.verifyResultsUsingCharacterStream(psStreams.executeQuery(), col);
        this.verifyResultsUsingCharacterStreamBlock(psStreams.executeQuery(), col);
        psStreams.close();
        psi.close();
        psq.close();
    }

    private void runTestSetCharacterStream(int col) throws Exception {
        PreparedStatement psi = this.prepareStatement("insert into charstream(c, vc, lvc, lob) values(?,?,?,?)");
        PreparedStatement psq = this.prepareStatement("select id, c, {fn length(c)} AS CLEN, cast (vc as varchar(25)) AS VC, {fn length(vc)} AS VCLEN, cast (lvc as varchar(25)) AS LVC, {fn length(lvc)} AS LVCLEN, cast (lob as varchar(25)) AS LOB, {fn length(lob)} AS LOBLEN from charstream where id > ? order by 1");
        CharacterStreamsTest.println("\nTest setCharacterStream into CHAR");
        psi.setString(1, null);
        psi.setString(2, null);
        psi.setString(3, null);
        psi.setString(4, null);
        int maxid = this.getMaxId();
        this.setCharacter(psi, col);
        psq.setInt(1, maxid);
        this.verifyCharStreamResults(psq.executeQuery(), col);
        psi.close();
        psq.close();
    }

    private void runTestSetAsciiStreamLongValues() throws Exception {
        PreparedStatement psi = this.prepareStatement("insert into charstream(c, vc, lvc, lob) values(?,?,?,?)");
        PreparedStatement psDel = this.prepareStatement("DELETE FROM charstream");
        PreparedStatement psq2 = this.prepareStatement("select c, vc, lvc, lob from charstream");
        CharacterStreamsTest.println("setAsciiStream(LONG ASCII STREAMS)");
        this.checkAsciiStreams(psDel, psi, psq2, 18, 104, 67, 67);
        this.checkAsciiStreams(psDel, psi, psq2, 25, 16732, 14563, 14563);
        this.checkAsciiStreams(psDel, psi, psq2, 1, 32433, 32673, 32673);
        this.checkAsciiStreams(psDel, psi, psq2, 0, 32532, 32700, 32700);
        psi.close();
        psDel.close();
        psq2.close();
    }

    private void runTestSetCharacterStreamLongValues() throws Exception {
        PreparedStatement psi = this.prepareStatement("insert into charstream(c, vc, lvc, lob) values(?,?,?,?)");
        PreparedStatement psDel = this.prepareStatement("DELETE FROM charstream");
        PreparedStatement psqSQLLength = this.prepareStatement("select length(c), length(vc), length(lvc), length(lob) from charstream");
        PreparedStatement psq2 = this.prepareStatement("select c, vc, lvc, lob from charstream");
        CharacterStreamsTest.println("setCharacterStream(LONG CHARACTER STREAMS WITH UNICODE)");
        this.checkCharacterStreams(psDel, psi, psq2, psqSQLLength, 14, 93, 55, 55, 0);
        this.checkCharacterStreams(psDel, psi, psq2, psqSQLLength, 21, 10887, 10887, 10887, 3);
        this.checkCharacterStreams(psDel, psi, psq2, psqSQLLength, 25, 19332, 18733, 18733, 0);
        this.checkCharacterStreams(psDel, psi, psq2, psqSQLLength, 1, 32433, 32673, 32673, 0);
        this.checkCharacterStreams(psDel, psi, psq2, psqSQLLength, 0, 32532, 32700, 32700, 0);
        psi.close();
        psDel.close();
        psq2.close();
    }

    private int getMaxId() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select max(id) from charstream");
        rs.next();
        int maxid = rs.getInt(1);
        rs.close();
        stmt.close();
        return maxid;
    }

    private void setAscii(PreparedStatement ps, int targetCol) throws Exception {
        byte[] asciiBytes = null;
        CharacterStreamsTest.println("CORRECT NUMBER OF BYTES IN STREAM");
        asciiBytes = ASCII_VALUE.getBytes("US-ASCII");
        ps.setAsciiStream(targetCol, (InputStream)new ByteArrayInputStream(asciiBytes), 23);
        ps.executeUpdate();
        CharacterStreamsTest.println("MORE BYTES IN STREAM THAN PASSED IN VALUE");
        try {
            asciiBytes = "against Republicans George W. Bush ".getBytes("US-ASCII");
            ps.setAsciiStream(targetCol, (InputStream)new ByteArrayInputStream(asciiBytes), 19);
            ps.executeUpdate();
            CharacterStreamsTest.fail((String)"FAIL - MORE BYTES IN ASCII STREAM THAN SPECIFIED LENGTH");
        }
        catch (SQLException sqle) {
            CharacterStreamsTest.assertSQLState("XJ001", sqle);
        }
        CharacterStreamsTest.println("LESS BYTES IN STREAM THAN PASSED IN VALUE");
        try {
            asciiBytes = "and Dick Cheney.".getBytes("US-ASCII");
            ps.setAsciiStream(targetCol, (InputStream)new ByteArrayInputStream(asciiBytes), 17);
            ps.executeUpdate();
            CharacterStreamsTest.fail((String)"FAIL - LESS BYTES IN ASCII STREAM THAN SPECIFIED LENGTH");
        }
        catch (SQLException sqle) {
            CharacterStreamsTest.assertSQLState("XJ001", sqle);
        }
        CharacterStreamsTest.println("NULL ASCII STREAM");
        ps.setAsciiStream(targetCol, (InputStream)null, 1);
        ps.executeUpdate();
    }

    private void setCharacter(PreparedStatement ps, int targetCol) throws Exception {
        StringReader reader = null;
        reader = new StringReader(CHAR_VALUE1);
        ps.setCharacterStream(targetCol, (Reader)reader, 24);
        ps.executeUpdate();
        reader = new StringReader(CHAR_VALUE2);
        ps.setCharacterStream(targetCol, (Reader)reader, 19);
        ps.executeUpdate();
        try {
            reader = new StringReader("for comments he made at");
            ps.setCharacterStream(targetCol, (Reader)reader, 20);
            ps.executeUpdate();
            CharacterStreamsTest.fail((String)"FAIL - MORE CHARACTERS IN READER THAN SPECIFIED LENGTH");
        }
        catch (SQLException sqle) {
            CharacterStreamsTest.assertSQLState("XJ001", sqle);
        }
        try {
            reader = new StringReader("a birthday party");
            ps.setCharacterStream(targetCol, (Reader)reader, 17);
            ps.executeUpdate();
            CharacterStreamsTest.fail((String)"FAIL - LESS CHARACTERS IN READER THAN SPECIFIED LENGTH");
        }
        catch (SQLException sqle) {
            CharacterStreamsTest.assertSQLState("XJ001", sqle);
        }
        ps.setCharacterStream(targetCol, (Reader)null, 1);
        ps.executeUpdate();
    }

    private void verifyAsciiStreamResults(ResultSet rs, int col) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        String value = rs.getString(col * 2);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)rs.wasNull());
        int length = rs.getInt(col * 2 + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - length should not be null", (boolean)rs.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), (String)ASCII_VALUE, (String)value.trim());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + col), (int)23, (int)length);
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        value = rs.getString(col * 2);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)rs.wasNull());
        length = rs.getInt(col * 2 + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - length should be null", (boolean)rs.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), null, (String)value);
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + col), (int)0, (int)length);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)rs.next());
    }

    private void verifyCharStreamResults(ResultSet rs, int col) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        String value = rs.getString(col * 2);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)rs.wasNull());
        int length = rs.getInt(col * 2 + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - length should not be null", (boolean)rs.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), (String)CHAR_VALUE1, (String)value.trim());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + col), (int)24, (int)length);
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        value = rs.getString(col * 2);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)rs.wasNull());
        length = rs.getInt(col * 2 + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - length should not be null", (boolean)rs.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), (String)CHAR_VALUE2, (String)value.trim());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + col), (int)19, (int)length);
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        value = rs.getString(col * 2);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)rs.wasNull());
        length = rs.getInt(col * 2 + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - length should be null", (boolean)rs.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), null, (String)value);
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + col), (int)0, (int)length);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)rs.next());
        rs.close();
    }

    private void verifyResultsUsingAsciiStream(ResultSet rs, int col) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        InputStream valueStream = rs.getAsciiStream(col + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)rs.wasNull());
        byte[] valueBytes = new byte[23];
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length read from stream", (int)23, (int)valueStream.read(valueBytes));
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), (String)ASCII_VALUE, (String)new String(valueBytes, "US-ASCII"));
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        String value = rs.getString(col + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)rs.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), null, (String)value);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)rs.next());
        rs.close();
    }

    private void verifyResultsUsingCharacterStream(ResultSet rs, int col) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        Reader valueReader = rs.getCharacterStream(col + 1);
        StringBuffer sb = new StringBuffer();
        int c = 0;
        while ((c = valueReader.read()) != -1) {
            sb.append((char)c);
        }
        String value = sb.toString().trim();
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length read from stream", (int)23, (int)value.length());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), (String)ASCII_VALUE, (String)value);
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        value = rs.getString(col + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)rs.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), null, (String)value);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)rs.next());
        rs.close();
    }

    private void verifyResultsUsingCharacterStreamBlock(ResultSet rs, int col) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        Reader valueReader = rs.getCharacterStream(col + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)rs.wasNull());
        char[] valueChars = new char[23];
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length read from stream", (int)23, (int)valueReader.read(valueChars));
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), (String)ASCII_VALUE, (String)new String(valueChars));
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        String value = rs.getString(col + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)rs.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + col), null, (String)value);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)rs.next());
        rs.close();
    }

    private void checkAsciiStreams(PreparedStatement psDel, PreparedStatement psi, PreparedStatement psq2, int cl, int vcl, int lvcl, int lob) throws SQLException, IOException {
        psDel.executeUpdate();
        psi.setAsciiStream(1, (InputStream)new c3AsciiStream(cl), cl);
        psi.setAsciiStream(2, (InputStream)new c3AsciiStream(vcl), vcl);
        psi.setAsciiStream(3, (InputStream)new c3AsciiStream(lvcl), lvcl);
        psi.setAsciiStream(4, (InputStream)new c3AsciiStream(lob), lob);
        psi.executeUpdate();
        ResultSet rs = psq2.executeQuery();
        rs.next();
        InputStream is = rs.getAsciiStream(1);
        this.checkAsciiStream(is, cl, 25);
        is = rs.getAsciiStream(2);
        this.checkAsciiStream(is, vcl, -1);
        is = rs.getAsciiStream(3);
        this.checkAsciiStream(is, lvcl, -1);
        is = rs.getAsciiStream(4);
        this.checkAsciiStream(is, lob, -1);
        rs.close();
        rs = psq2.executeQuery();
        rs.next();
        Reader r = rs.getCharacterStream(1);
        this.checkAsciiStream(r, cl, 25);
        r = rs.getCharacterStream(2);
        this.checkAsciiStream(r, vcl, -1);
        r = rs.getCharacterStream(3);
        this.checkAsciiStream(r, lvcl, -1);
        r = rs.getCharacterStream(4);
        this.checkAsciiStream(r, lob, -1);
        rs.close();
        rs = psq2.executeQuery();
        rs.next();
        r = new StringReader(rs.getString(1));
        this.checkAsciiStream(r, cl, 25);
        r = new StringReader(rs.getString(2));
        this.checkAsciiStream(r, vcl, -1);
        r = new StringReader(rs.getString(3));
        this.checkAsciiStream(r, lvcl, -1);
        r = new StringReader(rs.getString(4));
        this.checkAsciiStream(r, lob, -1);
        rs.close();
    }

    private Reader getSourceStream(int length, int bytesPerChar) {
        switch (bytesPerChar) {
            case 0: {
                return new c3Reader(length);
            }
            case 1: {
                return new LoopingAlphabetReader((long)length, CharAlphabet.modernLatinLowercase());
            }
            case 2: {
                return new LoopingAlphabetReader((long)length, CharAlphabet.tamil());
            }
            case 3: {
                return new LoopingAlphabetReader((long)length, CharAlphabet.cjkSubset());
            }
        }
        CharacterStreamsTest.fail((String)("Illegal value of bytesPerChar: " + bytesPerChar));
        return null;
    }

    private void checkCharacterStreams(PreparedStatement psDel, PreparedStatement psi, PreparedStatement psq2, PreparedStatement psqSQLLength, int cl, int vcl, int lvcl, int lob, int bytesPerChar) throws SQLException, IOException {
        psDel.executeUpdate();
        psi.setCharacterStream(1, this.getSourceStream(cl, bytesPerChar), cl);
        psi.setCharacterStream(2, this.getSourceStream(vcl, bytesPerChar), vcl);
        psi.setCharacterStream(3, this.getSourceStream(lvcl, bytesPerChar), lvcl);
        psi.setCharacterStream(4, this.getSourceStream(lob, bytesPerChar), lob);
        psi.executeUpdate();
        ResultSet rsLength = psqSQLLength.executeQuery();
        CharacterStreamsTest.assertTrue((boolean)rsLength.next());
        CharacterStreamsTest.assertEquals((int)25, (int)rsLength.getInt(1));
        CharacterStreamsTest.assertEquals((int)vcl, (int)rsLength.getInt(2));
        CharacterStreamsTest.assertEquals((int)lvcl, (int)rsLength.getInt(3));
        CharacterStreamsTest.assertEquals((int)lob, (int)rsLength.getInt(4));
        CharacterStreamsTest.assertFalse((boolean)rsLength.next());
        rsLength.close();
        ResultSet rs = psq2.executeQuery();
        rs.next();
        InputStream is = rs.getAsciiStream(1);
        this.checkCharStream(is, cl, 25, bytesPerChar);
        is = rs.getAsciiStream(2);
        this.checkCharStream(is, vcl, -1, bytesPerChar);
        is = rs.getAsciiStream(3);
        this.checkCharStream(is, lvcl, -1, bytesPerChar);
        is = rs.getAsciiStream(4);
        this.checkCharStream(is, lob, -1, bytesPerChar);
        rs.close();
        rs = psq2.executeQuery();
        rs.next();
        Reader r = rs.getCharacterStream(1);
        this.checkCharStream(r, cl, 25, bytesPerChar);
        r = rs.getCharacterStream(2);
        this.checkCharStream(r, vcl, -1, bytesPerChar);
        r = rs.getCharacterStream(3);
        this.checkCharStream(r, lvcl, -1, bytesPerChar);
        r = rs.getCharacterStream(4);
        this.checkCharStream(r, lob, -1, bytesPerChar);
        rs.close();
        rs = psq2.executeQuery();
        rs.next();
        String suv = rs.getString(1);
        r = new StringReader(suv);
        this.checkCharStream(r, cl, 25, bytesPerChar);
        suv = rs.getString(2);
        r = new StringReader(suv);
        this.checkCharStream(r, vcl, -1, bytesPerChar);
        suv = rs.getString(3);
        r = new StringReader(suv);
        this.checkCharStream(r, lvcl, -1, bytesPerChar);
        suv = rs.getString(4);
        r = new StringReader(suv);
        this.checkCharStream(r, lob, -1, bytesPerChar);
        rs.close();
    }

    private void checkAsciiStream(InputStream is, int length, int fixedLen) throws IOException {
        c3AsciiStream orig = new c3AsciiStream(length);
        int count = 0;
        while (true) {
            int o = orig == null ? (count == fixedLen ? -2 : 32) : ((InputStream)orig).read();
            int c = is.read();
            if (o == -1) {
                orig = null;
                if (fixedLen != -1 && fixedLen != length) {
                    o = 32;
                }
            }
            if (o == -2) {
                o = -1;
            }
            CharacterStreamsTest.assertEquals((String)("FAIL - wrong value at position " + count), (int)o, (int)c);
            if (orig == null && fixedLen == -1 || c == -1 && fixedLen != -1) break;
            ++count;
        }
        if (fixedLen != -1) {
            length = fixedLen;
        }
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length", (int)length, (int)count);
        is.close();
    }

    private void checkAsciiStream(Reader r, int length, int fixedLen) throws IOException {
        c3AsciiStream orig = new c3AsciiStream(length);
        int count = 0;
        while (true) {
            int o = orig == null ? (count == fixedLen ? -2 : 32) : ((InputStream)orig).read();
            int c = r.read();
            if (o == -1) {
                orig = null;
                if (fixedLen != -1 && fixedLen != length) {
                    o = 32;
                }
            }
            if (o == -2) {
                o = -1;
            }
            CharacterStreamsTest.assertEquals((String)"FAIL - wrong value", (int)o, (int)c);
            if (orig == null && fixedLen == -1 || c == -1 && fixedLen != -1) break;
            ++count;
        }
        if (fixedLen != -1) {
            length = fixedLen;
        }
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length", (int)length, (int)count);
        r.close();
    }

    private void checkCharStream(InputStream is, int length, int fixedLen, int bytesPerChar) throws IOException {
        Reader orig = this.getSourceStream(length, bytesPerChar);
        int count = 0;
        while (true) {
            int o = orig == null ? (count == fixedLen ? -2 : 32) : orig.read();
            int c = is.read();
            if (o == -1) {
                orig = null;
                if (fixedLen != -1 && fixedLen != length) {
                    o = 32;
                }
            }
            if (o == -2) {
                o = -1;
            }
            if (o != -1) {
                o = o <= 255 ? (o &= 0xFF) : 63;
            }
            CharacterStreamsTest.assertEquals((String)"FAIL - wrong value", (int)o, (int)c);
            if (orig == null && fixedLen == -1 || c == -1 && fixedLen != -1) break;
            ++count;
        }
        if (fixedLen != -1) {
            length = fixedLen;
        }
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length", (int)length, (int)count);
        is.close();
    }

    private void checkCharStream(Reader r, int length, int fixedLen, int bytesPerChar) throws IOException {
        Reader orig = this.getSourceStream(length, bytesPerChar);
        int count = 0;
        while (true) {
            int o = orig == null ? (count == fixedLen ? -2 : 32) : orig.read();
            int c = r.read();
            if (o == -1) {
                orig = null;
                if (fixedLen != -1 && fixedLen != length) {
                    o = 32;
                }
            }
            if (o == -2) {
                o = -1;
            }
            CharacterStreamsTest.assertEquals((String)"FAIL - wrong value", (int)o, (int)c);
            if (orig == null && fixedLen == -1 || c == -1 && fixedLen != -1) break;
            ++count;
        }
        if (fixedLen != -1) {
            length = fixedLen;
        }
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length", (int)length, (int)count);
        r.close();
    }

    protected void setUp() throws Exception {
        this.createStatement().executeUpdate("create table charstream(id int GENERATED ALWAYS AS IDENTITY primary key, c char(25), vc varchar(32532), lvc long varchar, lob clob(300K))");
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.createStatement().executeUpdate("DROP TABLE charstream");
        this.commit();
        super.tearDown();
    }
}

