/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SSLTest
extends BaseJDBCTestCase {
    public SSLTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("SSLTest");
        if (!TestConfiguration.loadingFromJars()) {
            return suite;
        }
        if (!Derby.hasServer()) {
            return suite;
        }
        suite.addTest(SSLTest.decorateTest("testSSLBasicDSConnect"));
        suite.addTest(SSLTest.decorateTest("testSSLBasicDSPlainConnect"));
        return suite;
    }

    private static Test decorateTest(String testName) {
        SSLTest sslTest = new SSLTest(testName);
        String[] startupProperties = SSLTest.getStartupProperties();
        String[] startupArgs = new String[]{};
        NetworkServerTestSetup networkServerTestSetup = new NetworkServerTestSetup((Test)sslTest, startupProperties, startupArgs, true);
        Object testSetup = SecurityManagerSetup.noSecurityManager((Test)networkServerTestSetup);
        testSetup = new SupportFilesSetup((Test)testSetup, null, new String[]{"functionTests/tests/derbynet/SSLTestServerKey.key"}, null, new String[]{"SSLTestServerKey.key"});
        Test test = TestConfiguration.defaultServerDecorator(testSetup);
        test = TestConfiguration.changeSSLDecorator(test, "basic");
        return test;
    }

    private static String[] getStartupProperties() {
        return new String[]{"javax.net.ssl.keyStore=extinout/SSLTestServerKey.key", "javax.net.ssl.keyStorePassword=qwerty"};
    }

    public void testSSLBasicDSConnect() throws Exception {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        JDBCDataSource.setBeanProperty(ds, "ssl", "basic");
        Connection c1 = ds.getConnection();
        c1.close();
    }

    public void testSSLBasicDSPlainConnect() throws Exception {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        try {
            Connection c2 = ds.getConnection();
            c2.close();
            SSLTest.fail();
        }
        catch (SQLException e) {
            SSLTest.assertSQLState("08006", e);
        }
    }
}

