/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.io.File;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.derbyTesting.functionTests.tests.compatibility.VersionCombinationConfigurator;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClientCompatibilityRunControl
extends BaseJDBCTestCase {
    static final String LOB_TESTING_PROP = "derby.tests.compat.testLOBs";
    private final String realName;
    private final DerbyDistribution clientDist;
    private final DerbyVersion serverVersion;
    private final String testingPath;

    public ClientCompatibilityRunControl(DerbyDistribution client, String testingPath, DerbyVersion serverVersion) {
        super("testClient");
        this.clientDist = client;
        this.testingPath = testingPath;
        this.serverVersion = serverVersion;
        this.realName = "combination(client " + client.getVersion().toString() + " <> server " + serverVersion.toString() + ")";
    }

    public String getName() {
        return this.realName;
    }

    public void testClient() throws Exception {
        boolean testLOBs = Boolean.parseBoolean(ClientCompatibilityRunControl.getSystemProperty(LOB_TESTING_PROP));
        String classpath = this.clientDist.getDerbyClientJarPath() + File.pathSeparator + this.testingPath + File.pathSeparator + ClientCompatibilityRunControl.getJUnitPath();
        if (testLOBs) {
            classpath = classpath + File.pathSeparator + this.clientDist.getDerbyEngineJarPath();
        }
        String[] cmd = new String[]{"-Dderby.tests.compat.expectedClient=" + this.clientDist.getVersion().toString(), "-Dderby.tests.compat.expectedServer=" + this.serverVersion.toString(), "-Dderby.tests.compat.testLOBs=" + testLOBs, "-Dderby.tests.basePort=" + TestConfiguration.getBasePort(), "junit.textui.TestRunner", "org.apache.derbyTesting.functionTests.tests.compatibility.ClientCompatibilitySuite"};
        Process proc = ClientCompatibilityRunControl.execJavaCmd(null, classpath, cmd, null);
        SpawnedProcess spawned = new SpawnedProcess(proc, this.realName);
        int exitCode = spawned.complete(1800000L);
        ClientCompatibilityRunControl.assertTrue((String)spawned.getFailMessage("client VM failed: "), (exitCode == 0 ? 1 : 0) != 0);
        ClientCompatibilityRunControl.println(spawned.getFullServerOutput());
    }

    private static String getJUnitPath() {
        URI uri = VersionCombinationConfigurator.getClassURI(TestCase.class);
        return new File(uri).getPath();
    }
}

