/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derbyTesting.functionTests.harness.RunTest;

public class UnJar {
    public static void main(String[] args) throws Exception {
        UnJar uj = new UnJar();
        UnJar.unjar(args[0], null, true);
    }

    public static void unjar(String jarname, String outputdir, boolean useprocess) throws ClassNotFoundException, IOException {
        int len;
        InputStream is;
        if (outputdir == null) {
            outputdir = System.getProperty("user.dir");
        }
        if ((is = RunTest.loadTestResource("upgrade/" + jarname)) == null) {
            System.out.println("File not found: " + jarname);
            System.exit(1);
        }
        File jarFile = new File(new File(outputdir, jarname).getCanonicalPath());
        FileOutputStream fos = new FileOutputStream(jarFile);
        byte[] data = new byte[1024];
        while ((len = is.read(data)) != -1) {
            fos.write(data, 0, len);
        }
        fos.close();
        String jarCmd = "jar xf " + jarFile.getPath();
        if (useprocess) {
            Process pr = null;
            try {
                pr = Runtime.getRuntime().exec(jarCmd);
                pr.waitFor();
                pr.destroy();
            }
            catch (Throwable t) {
                System.out.println("Process exception: " + t.getMessage());
                if (pr != null) {
                    pr.destroy();
                    pr = null;
                }
            }
        } else {
            System.out.println("Jar not implemented yet with useprocess=false");
        }
    }
}

