/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class OrderByColumn
extends OrderedColumn {
    private ResultColumn resultCol;
    private boolean ascending = true;
    private boolean nullsOrderedLow = false;
    private ValueNode expression;
    private OrderByList list;
    private int addedColumnOffset = -1;

    OrderByColumn(ValueNode expression, ContextManager cm) {
        super(cm);
        this.expression = expression;
    }

    @Override
    public String toString() {
        return "nullsOrderedLow: " + this.nullsOrderedLow + "\nascending; " + this.ascending + "\naddedColumnOffset: " + this.addedColumnOffset + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.expression != null) {
            this.printLabel(depth, "expression: ");
            this.expression.treePrint(depth + 1);
        }
        if (this.resultCol != null) {
            this.printLabel(depth, "resultCol: ");
            this.resultCol.treePrint(depth + 1);
        }
    }

    void setDescending() {
        this.ascending = false;
    }

    @Override
    boolean isAscending() {
        return this.ascending;
    }

    void setNullsOrderedLow() {
        this.nullsOrderedLow = true;
    }

    @Override
    boolean isNullsOrderedLow() {
        return this.nullsOrderedLow;
    }

    ResultColumn getResultColumn() {
        return this.resultCol;
    }

    ValueNode getNonRedundantExpression() {
        ColumnReference colref = null;
        ResultColumn rc = this.resultCol;
        while (rc.isRedundant()) {
            ValueNode value = rc.getExpression();
            if (value instanceof ColumnReference) {
                colref = (ColumnReference)value;
            } else {
                SanityManager.THROWASSERT("value should be a ColumnReference, but is a " + value.getClass().getName());
            }
            rc = colref.getSource();
        }
        return rc.getExpression();
    }

    void bindOrderByColumn(ResultSetNode target, OrderByList oblist) throws StandardException {
        this.list = oblist;
        if (this.expression instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this.expression;
            this.resultCol = this.resolveColumnReference(target, cr);
            this.columnPosition = this.resultCol.getColumnPosition();
            if (this.addedColumnOffset >= 0 && target instanceof SelectNode && ((SelectNode)target).hasDistinct()) {
                throw StandardException.newException("42879", cr.getColumnName());
            }
        } else if (OrderByColumn.isReferedColByNum(this.expression)) {
            ResultColumnList targetCols = target.getResultColumns();
            this.columnPosition = (Integer)this.expression.getConstantValueAsObject();
            this.resultCol = targetCols.getOrderByColumn(this.columnPosition);
            if (this.resultCol == null || this.resultCol.getColumnPosition() > targetCols.visibleSize()) {
                throw StandardException.newException("42X77", String.valueOf(this.columnPosition));
            }
        } else {
            if (this.list.isTableValueCtorOrdering()) {
                throw StandardException.newException("4287B", new Object[0]);
            }
            if (this.addedColumnOffset >= 0 && target instanceof SelectNode && ((SelectNode)target).hasDistinct() && !this.expressionMatch(target)) {
                CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
                this.expression.accept(collectNodesVisitor);
                for (ColumnReference cr1 : collectNodesVisitor.getList()) {
                    String col = cr1.getColumnName();
                    boolean match = this.columnMatchFound(target, cr1);
                    if (match) continue;
                    throw StandardException.newException("42879", col);
                }
            }
            SanityManager.ASSERT(this.addedColumnOffset >= 0, "Order by expression was not pulled into the result column list");
            this.resolveAddedColumn(target);
            if (this.resultCol == null) {
                throw StandardException.newException("42878", new Object[0]);
            }
        }
        this.resultCol.verifyOrderable();
    }

    private boolean expressionMatch(ResultSetNode target) throws StandardException {
        ResultColumnList rcl = target.getResultColumns();
        for (int i = 1; i <= rcl.visibleSize(); ++i) {
            if (!rcl.getResultColumn(i).isEquivalent(this.resultCol)) continue;
            return true;
        }
        return false;
    }

    private boolean columnMatchFound(ResultSetNode target, ColumnReference crOfExpression) throws StandardException {
        ResultColumnList rcl = target.getResultColumns();
        for (int i = 1; i <= rcl.visibleSize(); ++i) {
            ColumnReference cr2;
            ValueNode exp = rcl.getResultColumn(i).getExpression();
            if (!(exp instanceof ColumnReference) || !crOfExpression.isEquivalent(cr2 = (ColumnReference)exp)) continue;
            return true;
        }
        return false;
    }

    private void resolveAddedColumn(ResultSetNode target) {
        ResultColumnList targetCols = target.getResultColumns();
        this.columnPosition = targetCols.visibleSize() + this.addedColumnOffset + 1;
        this.resultCol = targetCols.getResultColumn(this.columnPosition);
    }

    void pullUpOrderByColumn(ResultSetNode target) throws StandardException {
        ResultColumnList targetCols = target.getResultColumns();
        if (this.expression instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this.expression;
            this.resultCol = targetCols.findResultColumnForOrderBy(cr.getColumnName(), cr.getQualifiedTableName());
            if (this.resultCol == null) {
                this.resultCol = new ResultColumn(cr.getColumnName(), (ValueNode)cr, this.getContextManager());
                targetCols.addResultColumn(this.resultCol);
                this.addedColumnOffset = targetCols.getOrderBySelect();
                targetCols.incOrderBySelect();
            }
        } else if (!OrderByColumn.isReferedColByNum(this.expression)) {
            this.resultCol = new ResultColumn((String)null, this.expression, this.getContextManager());
            targetCols.addResultColumn(this.resultCol);
            this.addedColumnOffset = targetCols.getOrderBySelect();
            targetCols.incOrderBySelect();
        }
    }

    void resetToSourceRC() {
        if (!(this.resultCol.getExpression() instanceof VirtualColumnNode)) {
            SanityManager.THROWASSERT("resultCol.getExpression() expected to be instanceof VirtualColumnNode , not " + this.resultCol.getExpression().getClass().getName());
        }
        this.resultCol = this.resultCol.getExpression().getSourceResultColumn();
    }

    boolean constantColumn(PredicateList whereClause) {
        ValueNode sourceExpr = this.resultCol.getExpression();
        return sourceExpr.constantExpression(whereClause);
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        this.resultCol.setExpression(this.resultCol.getExpression().remapColumnReferencesToExpressions());
    }

    private static boolean isReferedColByNum(ValueNode expression) throws StandardException {
        return expression instanceof NumericConstantNode && expression.getConstantValueAsObject() instanceof Integer;
    }

    private ResultColumn resolveColumnReference(ResultSetNode target, ColumnReference cr) throws StandardException {
        ResultColumnList targetCols;
        ResultColumn resCol;
        int sourceTableNumber = -1;
        if (target instanceof SetOperatorNode && cr.getTableName() != null) {
            String fullName = cr.getSQLColumnName();
            throw StandardException.newException("42877", fullName);
        }
        if (cr.getQualifiedTableName() != null) {
            TableName tableNameNode = cr.getQualifiedTableName();
            FromTable fromTable = target.getFromTableByName(tableNameNode.getTableName(), tableNameNode.hasSchema() ? tableNameNode.getSchemaName() : null, true);
            if (fromTable == null && (fromTable = target.getFromTableByName(tableNameNode.getTableName(), tableNameNode.hasSchema() ? tableNameNode.getSchemaName() : null, false)) == null) {
                String fullName = cr.getQualifiedTableName().toString();
                throw StandardException.newException("42X10", fullName);
            }
            sourceTableNumber = target instanceof SetOperatorNode ? ((FromTable)target).getTableNumber() : fromTable.getTableNumber();
        }
        if ((resCol = (targetCols = target.getResultColumns()).getOrderByColumnToBind(cr.getColumnName(), cr.getQualifiedTableName(), sourceTableNumber, this)) == null && this.addedColumnOffset >= 0) {
            this.resolveAddedColumn(target);
        }
        if (resCol == null || resCol.isNameGenerated()) {
            String errString = cr.getColumnName();
            throw StandardException.newException("42X78", errString);
        }
        return resCol;
    }

    void clearAddedColumnOffset() {
        this.list.closeGap(this.addedColumnOffset);
        this.addedColumnOffset = -1;
    }

    void collapseAddedColumnGap(int gap) {
        if (this.addedColumnOffset > gap) {
            --this.addedColumnOffset;
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.expression != null) {
            this.expression = (ValueNode)this.expression.accept(v);
        }
    }

    ValueNode getExpression() {
        return this.expression;
    }
}

