/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class DropIndexNode
extends DDLStatementNode {
    private ConglomerateDescriptor cd;
    private TableDescriptor td;

    DropIndexNode(TableName index, ContextManager cm) {
        super(index, cm);
    }

    @Override
    String statementToString() {
        return "DROP INDEX";
    }

    @Override
    public void bindStatement() throws StandardException {
        ConstraintDescriptor conDesc;
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        SchemaDescriptor sd = this.getSchemaDescriptor();
        if (sd.getUUID() != null) {
            this.cd = dd.getConglomerateDescriptor(this.getRelativeName(), sd, false);
        }
        if (this.cd == null) {
            throw StandardException.newException("42X65", this.getFullName());
        }
        this.td = this.getTableDescriptor(this.cd.getTableID());
        if (this.cd.isConstraint() && (conDesc = dd.getConstraintDescriptor(this.td, this.cd.getUUID())) != null) {
            String constraintName = conDesc.getConstraintName();
            throw StandardException.newException("42X84", this.getFullName(), constraintName);
        }
        cc.createDependency(this.td);
        cc.createDependency(this.cd);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropIndexConstantAction(this.getFullName(), this.getRelativeName(), this.getRelativeName(), this.getSchemaDescriptor().getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
    }
}

