/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class LocatedRow {
    private DataValueDescriptor[] _columnValues;
    private RowLocation _rowLocation;

    public LocatedRow(DataValueDescriptor[] columnValues, RowLocation rowLocation) {
        this._columnValues = columnValues;
        this._rowLocation = rowLocation;
    }

    public LocatedRow(DataValueDescriptor[] columnsAndRowLocation) {
        int idx;
        int columnCount = columnsAndRowLocation.length - 1;
        this._columnValues = new DataValueDescriptor[columnCount];
        for (idx = 0; idx < columnCount; ++idx) {
            this._columnValues[idx] = columnsAndRowLocation[idx];
        }
        this._rowLocation = (RowLocation)columnsAndRowLocation[idx];
    }

    public DataValueDescriptor[] columnValues() {
        return this._columnValues;
    }

    public DataValueDescriptor[] flatten() {
        return LocatedRow.flatten(this._columnValues, this._rowLocation);
    }

    public RowLocation rowLocation() {
        return this._rowLocation;
    }

    public static DataValueDescriptor[] flatten(DataValueDescriptor[] columnValues, RowLocation rowLocation) {
        DataValueDescriptor[] result = new DataValueDescriptor[columnValues.length + 1];
        for (int idx = 0; idx < columnValues.length; ++idx) {
            result[idx] = columnValues[idx];
        }
        result[idx] = rowLocation;
        return result;
    }
}

