/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.XADataSource;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.DataSourceConnector;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XADataSourceConnector
implements Connector {
    private TestConfiguration config;
    private XADataSource ds;

    @Override
    public void setConfiguration(TestConfiguration testConfiguration) {
        this.config = testConfiguration;
        this.ds = J2EEDataSource.getXADataSource(testConfiguration, null);
    }

    @Override
    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getXAConnection().getConnection();
        }
        catch (SQLException sQLException) {
            String string;
            String string2 = string = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!string.equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getXAConnection().getConnection();
        }
    }

    @Override
    public Connection openConnection(String string) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", string);
        try {
            return this.ds.getXAConnection().getConnection();
        }
        catch (SQLException sQLException) {
            String string2;
            String string3 = string2 = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!string2.equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            XADataSource xADataSource = this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config));
            JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
            return xADataSource.getXAConnection().getConnection();
        }
    }

    @Override
    public Connection openConnection(String string, String string2) throws SQLException {
        try {
            return this.ds.getXAConnection(string, string2).getConnection();
        }
        catch (SQLException sQLException) {
            if (!"XJ004".equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getXAConnection(string, string2).getConnection();
        }
    }

    @Override
    public Connection openConnection(String string, String string2, String string3) throws SQLException {
        return this.openConnection(string, string2, string3, null);
    }

    @Override
    public Connection openConnection(String string, String string2, String string3, Properties properties) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", string);
        try {
            return this.ds.getXAConnection(string2, string3).getConnection();
        }
        catch (SQLException sQLException) {
            if (!"XJ004".equals(sQLException.getSQLState())) {
                throw sQLException;
            }
            HashMap<String, Object> hashMap = DataSourceConnector.makeCreateDBAttributes(this.config);
            DataSourceConnector.copyProperties(properties, hashMap);
            XADataSource xADataSource = this.singleUseDS(hashMap);
            JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
            return xADataSource.getXAConnection(string2, string3).getConnection();
        }
    }

    @Override
    public void shutDatabase() throws SQLException {
        this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config)).getXAConnection().getConnection();
        this.config.waitForShutdownComplete(this.getDatabaseName());
    }

    @Override
    public void shutEngine(boolean bl) throws SQLException {
        Assert.fail((String)"shutdown engine not implemened");
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.ds.setLoginTimeout(n);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public String getDatabaseName() {
        String string = null;
        try {
            string = (String)JDBCDataSource.getBeanProperty(this.ds, "databaseName");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private XADataSource singleUseDS(HashMap hashMap) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource(this.config, hashMap);
        return xADataSource;
    }
}

