/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.derbyTesting.junit.Utilities;

public class RuntimeStatisticsParser {
    private int isolationLevel = 0;
    private boolean distinctScan = false;
    private boolean eliminatedDuplicates = false;
    private boolean tableScan = false;
    private final boolean indexScan;
    private final boolean indexRowToBaseRow;
    private final boolean lastKeyIndexScan;
    private String statistics = "";
    private boolean scrollInsensitive = false;
    private final HashSet<Qualifier> qualifiers;
    private String[] startPosition = new String[]{"None"};
    private String[] stopPosition = new String[]{"None"};

    public RuntimeStatisticsParser(String string) {
        this.statistics = string;
        if (string.indexOf(" at serializable isolation level ") != -1) {
            this.isolationLevel = 8;
        } else if (string.indexOf("at read uncommitted isolation level") != -1) {
            this.isolationLevel = 1;
        } else if (string.indexOf("at read committed isolation level") != -1) {
            this.isolationLevel = 2;
        } else if (string.indexOf("at repeatable read isolation level") != -1) {
            this.isolationLevel = 4;
        }
        if (string.indexOf("Distinct Scan ResultSet") > 0) {
            this.distinctScan = true;
        }
        if (string.indexOf("Table Scan ResultSet") > 0) {
            this.tableScan = true;
        }
        this.indexScan = string.indexOf("Index Scan ResultSet") >= 0;
        this.indexRowToBaseRow = string.indexOf("Index Row to Base Row ResultSet") >= 0;
        boolean bl = this.lastKeyIndexScan = string.indexOf("Last Key Index Scan ResultSet") >= 0;
        if (string.indexOf("Eliminate duplicates = true") > 0) {
            this.eliminatedDuplicates = true;
        }
        if (string.indexOf("Scroll Insensitive ResultSet:") > 0) {
            this.scrollInsensitive = true;
        }
        this.qualifiers = this.findQualifiers();
        this.startPosition = this.getStartPosition();
        this.stopPosition = this.getStopPosition();
    }

    private HashSet<Qualifier> findQualifiers() {
        HashSet<Qualifier> hashSet = new HashSet<Qualifier>();
        int n = this.statistics.indexOf("qualifiers:\n");
        if (n >= 0) {
            String string = this.statistics.substring(n + 12);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t ");
                if (!stringTokenizer2.nextToken().equals("Operator:")) continue;
                String string3 = stringTokenizer2.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                stringTokenizer2 = new StringTokenizer(string2, "\t ");
                String string4 = stringTokenizer2.nextToken();
                if (!string4.equals("Negate")) {
                    throw new AssertionError((Object)("Expected to find \"Negate comparison result\", found: " + string4));
                }
                stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                boolean bl = Boolean.valueOf(stringTokenizer2.nextToken());
                hashSet.add(new Qualifier(string3, bl));
            }
        }
        return hashSet;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean usedDistinctScan() {
        return this.distinctScan;
    }

    public boolean usedTableScan() {
        return this.tableScan;
    }

    public boolean usedTableScan(String string) {
        return this.statistics.indexOf("Table Scan ResultSet for " + string + " ") != -1;
    }

    public boolean usedSpecificIndexForIndexScan(String string, String string2) {
        return this.statistics.indexOf("Index Scan ResultSet for " + string + " using index " + string2 + " ") != -1;
    }

    public boolean usedIndexScan(String string) {
        return this.statistics.indexOf("Index Scan ResultSet for " + string + " ") != -1;
    }

    public boolean usedConstraintForIndexScan(String string) {
        return this.statistics.indexOf("Index Scan ResultSet for " + string + " using constraint") != -1;
    }

    public boolean usedIndexScan() {
        return this.indexScan;
    }

    public boolean usedLastKeyIndexScan() {
        return this.lastKeyIndexScan;
    }

    public boolean usedIndexRowToBaseRow() {
        return this.indexRowToBaseRow;
    }

    public boolean usedIndexRowToBaseRow(String string) {
        return this.statistics.indexOf("Index Row to Base Row ResultSet for " + string + ":") != -1;
    }

    public boolean usedDistinctScan(String string) {
        return this.statistics.indexOf("Distinct Scan ResultSet for " + string + " ") != -1;
    }

    public boolean eliminatedDuplicates() {
        return this.eliminatedDuplicates;
    }

    public boolean isScrollInsensitive() {
        return this.scrollInsensitive;
    }

    public boolean hasGreaterThanOrEqualQualifier() {
        return this.qualifiers.contains(new Qualifier("<", true));
    }

    public boolean hasLessThanQualifier() {
        return this.qualifiers.contains(new Qualifier("<", false));
    }

    public boolean hasEqualsQualifier() {
        return this.qualifiers.contains(new Qualifier("=", false));
    }

    public boolean hasNoQualifiers() {
        int n = this.statistics.indexOf("qualifiers:\n");
        if (n >= 0) {
            String string = this.statistics.substring(n + 12);
            if (string.indexOf("None") > 1) {
                return true;
            }
            System.out.println("statistics.substring: " + string);
            return false;
        }
        throw new AssertionError((Object)"Expected to find \"qualifiers: None\", but didn't even find 'qualifiers'");
    }

    public boolean rowsQualifiedEquals(int n) {
        return this.statistics.indexOf("Number of rows qualified=" + n + "\n") != -1;
    }

    public boolean usedHashJoin() {
        return this.statistics.indexOf("Hash Join ResultSet") != -1;
    }

    public boolean usedNLLeftOuterJoin() {
        return this.statistics.indexOf("Nested Loop Left Outer Join") != -1;
    }

    public boolean usedExistsJoin() {
        return this.statistics.indexOf("Exists Join ResultSet") != -1;
    }

    public boolean findString(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        String string2 = this.statistics;
        for (int i = 0; i < n && (n3 = string2.indexOf(string)) != -1; ++i) {
            ++n2;
            string2 = string2.substring(n3 + string.length());
        }
        return n2 >= n;
    }

    public boolean whatSortingRequired() {
        return this.statistics.indexOf("Sort information: ") != -1;
    }

    public boolean usedExternalSort() {
        return this.statistics.indexOf("Sort type=external") != -1;
    }

    public String toString() {
        return this.statistics;
    }

    public String[] getStartPosition() {
        int n = this.statistics.indexOf("start position:");
        int n2 = this.statistics.indexOf("stop position:");
        if (n >= 0 && n2 >= 0) {
            String string = this.statistics.substring(n, n2);
            return Utilities.split(string, '\n');
        }
        return null;
    }

    public String[] getStopPosition() {
        int n = this.statistics.indexOf("stop position:");
        int n2 = this.statistics.indexOf("qualifiers:");
        if (n >= 0 && n2 >= 0) {
            String string = this.statistics.substring(n, n2);
            return Utilities.split(string, '\n');
        }
        return null;
    }

    public void assertSequence(String[] stringArray) {
        int n;
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\n');
            for (n = 0; n < stringArray[i].length(); ++n) {
                if (stringArray[i].charAt(n) == '_') {
                    if (n < 15) {
                        stringBuffer.append('\t');
                        continue;
                    }
                    stringBuffer.append(stringArray[i].substring(n));
                    continue;
                }
                stringBuffer.append(stringArray[i].substring(n));
                break;
            }
            stringArray[i] = stringBuffer.toString();
        }
        String string = this.statistics;
        for (int i = 0; i < stringArray.length; ++i) {
            n = string.indexOf(stringArray[i]);
            if (n == -1) {
                throw new AssertionError((Object)("Sequence " + stringArray[i] + "not found in statistics"));
            }
            string = string.substring(n + 1);
        }
    }

    private static class Qualifier {
        String operator;
        boolean negated;

        Qualifier(String string, boolean bl) {
            this.operator = string;
            this.negated = bl;
        }

        public int hashCode() {
            if (this.negated) {
                return ~this.operator.hashCode();
            }
            return this.operator.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Qualifier) {
                Qualifier qualifier = (Qualifier)object;
                return this.negated == qualifier.negated && this.operator.equals(qualifier.operator);
            }
            return false;
        }

        public String toString() {
            return (this.negated ? "\u00ac" : "") + this.operator;
        }
    }
}

