/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjdoc;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.javacc.jjdoc.JJDoc;
import org.javacc.jjdoc.JJDocGlobals;
import org.javacc.jjdoc.JJDocOptions;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.JavaCCParser;
import org.javacc.parser.MetaParseException;
import org.javacc.parser.ParseException;

public class JJDocMain {
    static void help_message() {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        printWriter.println("    jjdoc option-settings - (to read from standard input)");
        printWriter.println("OR");
        printWriter.println("    jjdoc option-settings inputfile (to read from a file)");
        printWriter.println("");
        printWriter.println("WHERE");
        printWriter.println("    \"option-settings\" is a sequence of settings separated by spaces.");
        printWriter.println("");
        printWriter.println("Each option setting must be of one of the following forms:");
        printWriter.println("");
        printWriter.println("    -optionname=value (e.g., -TEXT=false)");
        printWriter.println("    -optionname:value (e.g., -TEXT:false)");
        printWriter.println("    -optionname       (equivalent to -optionname=true.  e.g., -TEXT)");
        printWriter.println("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOTEXT)");
        printWriter.println("");
        printWriter.println("Option settings are not case-sensitive, so one can say \"-nOtExT\" instead");
        printWriter.println("of \"-NOTEXT\".  Option values must be appropriate for the corresponding");
        printWriter.println("option, and must be either an integer, boolean or string value.");
        printWriter.println("");
        printWriter.println("The string valued options are:");
        printWriter.println("");
        printWriter.println("    OUTPUT_FILE");
        printWriter.println("");
        printWriter.println("The boolean valued options are:");
        printWriter.println("");
        printWriter.println("    ONE_TABLE              (default true)");
        printWriter.println("    TEXT                   (default false)");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("EXAMPLES:");
        printWriter.println("    jjdoc -ONE_TABLE=false mygrammar.jj");
        printWriter.println("    jjdoc - < mygrammar.jj");
        printWriter.println("");
        printWriter.println("ABOUT JJDoc:");
        printWriter.println("    JJDoc generates JavaDoc documentation from JavaCC grammar files.");
        printWriter.println("");
        printWriter.println("    For more information, ???");
    }

    public static void main(String[] stringArray) throws Exception {
        JavaCCGlobals.bannerLine("Documentation Generator", "0.1.4");
        JavaCCParser javaCCParser = null;
        if (stringArray.length == 0) {
            System.out.println("");
            JJDocMain.help_message();
            System.exit(1);
        } else {
            System.out.println("(type \"jjdoc\" with no arguments for help)");
        }
        JJDocOptions.init();
        if (JJDocOptions.isOption(stringArray[stringArray.length - 1])) {
            System.out.println("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename or \"-\".  ");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!JJDocOptions.isOption(stringArray[i])) {
                System.out.println("Argument \"" + stringArray[i] + "\" must be an option setting.  ");
                System.exit(1);
            }
            JJDocOptions.setCmdLineOption(stringArray[i]);
        }
        if (stringArray[stringArray.length - 1].equals("-")) {
            System.out.println("Reading from standard input . . .");
            javaCCParser = new JavaCCParser(new DataInputStream(System.in));
            JJDocGlobals.input_file = "standard input";
            JJDocGlobals.output_file = "standard output";
        } else {
            System.out.println("Reading from file " + stringArray[stringArray.length - 1] + " . . .");
            try {
                File file = new File(stringArray[stringArray.length - 1]);
                if (!file.exists()) {
                    System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
                    System.exit(1);
                }
                if (file.isDirectory()) {
                    System.out.println(stringArray[stringArray.length - 1] + " is a directory. Please use a valid file name.");
                    System.exit(1);
                }
                JJDocGlobals.input_file = file.getName();
                javaCCParser = new JavaCCParser(new FileReader(stringArray[stringArray.length - 1]));
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SecurityException securityException) {
                System.out.println("Security voilation while trying to open " + stringArray[stringArray.length - 1]);
                System.exit(1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
                System.exit(1);
            }
        }
        try {
            javaCCParser.javacc_input();
            JJDoc.start();
            if (JavaCCErrors.get_error_count() == 0) {
                if (JavaCCErrors.get_warning_count() == 0) {
                    System.out.println("Grammar documentation generated successfully in " + JJDocGlobals.output_file);
                } else {
                    System.out.println("Grammar documentation generated with 0 errors and " + JavaCCErrors.get_warning_count() + " warnings.");
                }
                System.exit(0);
            } else {
                System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
                System.exit(JavaCCErrors.get_error_count() == 0 ? 0 : 1);
            }
        }
        catch (MetaParseException metaParseException) {
            System.out.println(metaParseException.toString());
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            System.exit(1);
        }
        catch (ParseException parseException) {
            System.out.println(parseException.toString());
            System.out.println("Detected " + (JavaCCErrors.get_error_count() + 1) + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            System.exit(1);
        }
    }
}

