/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.mailjdbc.tasks;

import java.sql.Connection;
import org.apache.derbyTesting.system.mailjdbc.MailJdbc;
import org.apache.derbyTesting.system.mailjdbc.utils.DbTasks;
import org.apache.derbyTesting.system.mailjdbc.utils.LogFile;

public class Backup
extends Thread {
    private boolean isRunning = false;
    private DbTasks dbtasks = new DbTasks();
    private Connection conn = null;

    public Backup(String name) throws Exception {
        this.setName(name);
        this.conn = DbTasks.getConnection("REFRESH", "Refresh");
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.doWork();
                try {
                    Thread.sleep(150000L);
                }
                catch (InterruptedException ie) {
                    MailJdbc.logAct.logMsg("#### " + this.getName() + "...Interrupted");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailJdbc.logAct.logMsg(LogFile.ERROR + "Error while sleeping the thread in Backup: " + e.getMessage());
            return;
        }
    }

    private void doWork() {
        this.isRunning = true;
        try {
            this.DoCompress();
            this.DoBackup();
        }
        catch (Exception e) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + "Error while doing work with the thread in Backup: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void DoCompress() throws Exception {
        this.dbtasks.compressTable(this.conn, "INBOX", this.getName());
        this.dbtasks.compressTable(this.conn, "ATTACH", this.getName());
    }

    public void DoBackup() throws Exception {
        this.dbtasks.Backup(this.conn, this.getName());
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

