/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am.stmtcache;

import org.apache.derby.shared.common.sanity.SanityManager;

public class StatementKey {
    private final boolean isCallableStatement;
    private final String sql;
    private final String schema;
    private final int type;
    private final int concurrency;
    private final int holdability;
    private final int autogeneratedKeys;

    StatementKey(boolean isCallableStatement, String sql, String schema, int rsType, int rsConcurrency, int rsHoldability, int autogeneratedKeys) {
        if (schema == null) {
            throw new IllegalArgumentException("schema is <null>");
        }
        this.isCallableStatement = isCallableStatement;
        this.sql = sql;
        this.schema = schema;
        this.type = rsType;
        this.concurrency = rsConcurrency;
        this.holdability = rsHoldability;
        this.autogeneratedKeys = autogeneratedKeys;
        SanityManager.ASSERT(rsType == 1003 || rsType == 1004 || rsType == 1005, "Invalid result set type: " + rsType);
        SanityManager.ASSERT(rsConcurrency == 1007 || rsConcurrency == 1008, "Invalid result set concurrency: " + rsConcurrency);
        SanityManager.ASSERT(rsHoldability == 1 || rsHoldability == 2, "Invalid result set holdability: " + rsHoldability);
        SanityManager.ASSERT(autogeneratedKeys == 2 || autogeneratedKeys == 1, "Invalid autogenerated key value: " + autogeneratedKeys);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatementKey)) {
            return false;
        }
        StatementKey other = (StatementKey)obj;
        if (this.holdability != other.holdability) {
            return false;
        }
        if (this.autogeneratedKeys != other.autogeneratedKeys) {
            return false;
        }
        if (this.isCallableStatement != other.isCallableStatement) {
            return false;
        }
        if (!this.schema.equals(other.schema)) {
            return false;
        }
        if (this.sql == null && other.sql != null) {
            return false;
        }
        if (!this.sql.equals(other.sql)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.concurrency == other.concurrency;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.isCallableStatement ? 1 : 0);
        hash = 47 * hash + (this.sql == null ? 3 : this.sql.hashCode());
        hash = 47 * hash + this.schema.hashCode();
        hash = 47 * hash + this.type;
        hash = 47 * hash + this.concurrency;
        hash = 47 * hash + this.holdability;
        hash = 47 * hash + this.autogeneratedKeys;
        return hash;
    }

    public String toString() {
        return "'" + this.sql + "' in '" + this.schema + "', rsh = " + this.holdability + ", rst = " + this.type + ", rsc = " + this.concurrency + ", autogenKeys = " + this.autogeneratedKeys + ", isCallableStatement = " + this.isCallableStatement;
    }
}

