/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.drda.DRDAStatement;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.drda.PiggyBackedSessionData;
import org.apache.derby.impl.drda.Pkgnamcsn;

class Database {
    private String dbName;
    private String shortDbName;
    String attrString = "";
    protected int securityMechanism;
    protected String userId;
    protected String password;
    protected String decryptedUserId;
    protected String decryptedPassword;
    protected byte[] passwordSubstitute;
    protected boolean rdbAllowUpdates = true;
    protected int accessCount;
    protected byte[] secTokenIn;
    protected byte[] secTokenOut;
    protected byte[] crrtkn;
    protected String typDefNam;
    protected int byteOrder;
    protected int ccsidSBC;
    protected int ccsidDBC;
    protected int ccsidMBC;
    protected String ccsidSBCEncoding;
    protected String ccsidDBCEncoding;
    protected String ccsidMBCEncoding;
    protected boolean RDBUPDRM_sent = false;
    protected boolean sendTRGDFTRT = false;
    private EngineConnection conn;
    DRDAStatement defaultStatement;
    private DRDAStatement currentStatement;
    private Hashtable<Object, DRDAStatement> stmtTable;
    private boolean locatorSupport = false;
    private boolean locatorSupportChecked = false;
    private PiggyBackedSessionData pbsd_ = null;

    Database(String dbName) {
        this.setDatabaseName(dbName);
        this.stmtTable = new Hashtable();
        this.initializeDefaultStatement();
    }

    public void setDatabaseName(String dbName) {
        if (dbName != null) {
            int attrOffset = dbName.indexOf(59);
            if (attrOffset != -1) {
                this.attrString = dbName.substring(attrOffset, dbName.length());
                this.shortDbName = dbName.substring(0, attrOffset);
            } else {
                this.shortDbName = dbName;
            }
        }
        this.dbName = dbName;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public String getShortDbName() {
        return this.shortDbName;
    }

    private void initializeDefaultStatement() {
        this.defaultStatement = new DRDAStatement(this);
    }

    final void setConnection(EngineConnection conn) throws SQLException {
        if (this.conn != conn) {
            this.pbsd_ = null;
        }
        this.conn = conn;
        if (conn != null) {
            this.defaultStatement.setStatement(conn);
        }
    }

    final EngineConnection getConnection() {
        return this.conn;
    }

    protected DRDAStatement getCurrentStatement() {
        return this.currentStatement;
    }

    protected DRDAStatement getDefaultStatement() {
        this.currentStatement = this.defaultStatement;
        return this.defaultStatement;
    }

    protected DRDAStatement getDefaultStatement(Pkgnamcsn pkgnamcsn) {
        this.currentStatement = this.defaultStatement;
        this.currentStatement.setPkgnamcsn(pkgnamcsn);
        return this.currentStatement;
    }

    protected DRDAStatement newDRDAStatement(Pkgnamcsn pkgnamcsn) throws SQLException {
        DRDAStatement stmt = this.getDRDAStatement(pkgnamcsn);
        if (stmt != null) {
            stmt.close();
            stmt.reset();
        } else {
            stmt = new DRDAStatement(this);
            stmt.setPkgnamcsn(pkgnamcsn);
            this.storeStatement(stmt);
        }
        return stmt;
    }

    protected DRDAStatement getDRDAStatement(Pkgnamcsn pkgnamcsn) {
        DRDAStatement newStmt = this.stmtTable.get(pkgnamcsn.getStatementKey());
        if (newStmt != null) {
            this.currentStatement = newStmt;
            this.currentStatement.setCurrentDrdaResultSet(pkgnamcsn);
        }
        return newStmt;
    }

    void makeConnection(Properties p) throws SQLException {
        EngineConnection conn;
        p.put("user", this.userId);
        if (this.password != null) {
            p.put("password", this.password);
        }
        if ((conn = (EngineConnection)NetworkServerControlImpl.getDriver().connect("jdbc:derby:" + this.shortDbName + this.attrString, p)) != null) {
            conn.setAutoCommit(false);
        }
        this.setConnection(conn);
    }

    void makeDummyConnection() {
        try {
            EngineConnection conn = (EngineConnection)NetworkServerControlImpl.getDriver().connect("jdbc:derby:" + this.shortDbName + this.attrString, new Properties());
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    String appendAttrString(Properties p) {
        if (p == null) {
            return null;
        }
        Enumeration<?> pKeys = p.propertyNames();
        while (pKeys.hasMoreElements()) {
            String key = (String)pKeys.nextElement();
            this.attrString = this.attrString + ";" + key + "=" + p.getProperty(key);
        }
        return this.attrString;
    }

    protected void storeStatement(DRDAStatement stmt) throws SQLException {
        this.stmtTable.put(stmt.getPkgnamcsn().getStatementKey(), stmt);
    }

    protected void removeStatement(DRDAStatement stmt) throws SQLException {
        this.stmtTable.remove(stmt.getPkgnamcsn().getStatementKey());
        stmt.close();
    }

    protected void setCurrentStatement(DRDAStatement stmt) {
        this.currentStatement = stmt;
    }

    protected void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    protected void rollback() throws SQLException {
        if (this.conn != null) {
            this.conn.rollback();
        }
    }

    protected void close() throws SQLException {
        try {
            if (this.stmtTable != null) {
                Enumeration<DRDAStatement> e = this.stmtTable.elements();
                while (e.hasMoreElements()) {
                    e.nextElement().close();
                }
            }
            if (this.defaultStatement != null) {
                this.defaultStatement.close();
            }
            if (this.conn != null && !this.conn.isClosed()) {
                if (!this.conn.isInGlobalTransaction()) {
                    this.conn.rollback();
                }
                this.conn.close();
            }
        }
        finally {
            this.conn = null;
            this.currentStatement = null;
            this.defaultStatement = null;
            this.stmtTable = null;
        }
    }

    final void setDrdaID(String drdaID) {
        if (this.conn != null) {
            this.conn.setDrdaID(drdaID);
        }
    }

    final void setPrepareIsolation(int level) throws SQLException {
        this.conn.setPrepareIsolation(level);
    }

    final int getPrepareIsolation() throws SQLException {
        return this.conn.getPrepareIsolation();
    }

    protected String buildRuntimeInfo(String indent, LocalizedResource localLangUtil) {
        Hashtable<Object, DRDAStatement> statements = this.stmtTable;
        String s = indent + localLangUtil.getTextMessage("DRDA_RuntimeInfoDatabase.I", new Object[0]) + this.dbName + "\n" + localLangUtil.getTextMessage("DRDA_RuntimeInfoUser.I", new Object[0]) + this.userId + "\n" + localLangUtil.getTextMessage("DRDA_RuntimeInfoNumStatements.I", new Object[0]) + (statements == null ? 0 : statements.size()) + "\n";
        s = s + localLangUtil.getTextMessage("DRDA_RuntimeInfoPreparedStatementHeader.I", new Object[0]);
        if (statements != null) {
            Enumeration<DRDAStatement> e = statements.elements();
            while (e.hasMoreElements()) {
                s = s + e.nextElement().toDebugString(indent + "\t") + "\n";
            }
        }
        return s;
    }

    boolean supportsLocator() throws SQLException {
        if (!this.locatorSupportChecked) {
            ResultSet rs = this.getConnection().getMetaData().getProcedures(null, "SYSIBM", "BLOBTRUNCATE");
            this.locatorSupport = rs.next();
            rs.close();
            this.locatorSupportChecked = true;
        }
        return this.locatorSupport;
    }

    public void reset() {
        this.decryptedUserId = null;
        this.decryptedPassword = null;
        this.passwordSubstitute = null;
        this.secTokenIn = null;
        this.secTokenOut = null;
        this.userId = null;
        this.password = null;
        this.securityMechanism = 0;
    }

    public PiggyBackedSessionData getPiggyBackedSessionData(boolean createOnDemand) throws SQLException {
        this.pbsd_ = PiggyBackedSessionData.getInstance(this.pbsd_, this.conn, createOnDemand);
        return this.pbsd_;
    }
}

