/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.dump;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationService;
import org.apache.derby.impl.services.jce.JCECipherFactoryBuilder;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;
import org.apache.derby.vti.VTITemplate;

public class DataFileVTI
extends VTITemplate {
    public static final String SYSSCHEMAS_SIGNATURE = "( schemaID char(36), schemaname varchar(128), authorizationid varchar(128) )";
    public static final String SYSSCHEMAS_CONGLOMERATE_NAME = "cc0.dat";
    public static final String SYSTABLES_SIGNATURE = "( tableid char(36), tablename varchar(128), tabletype char(1), schemaid char(36), lockgranularity char(1) )";
    public static final String SYSTABLES_CONGLOMERATE_NAME = "c60.dat";
    public static final String SYS_SCHEMA_ID = "8000000d-00d0-fd77-3ed8-000a0a0b1900";
    public static final String SYSUSERS_SIGNATURE = "( username  varchar( 128 ), hashingscheme  varchar( 32672 ), password  varchar( 32672 ), lastmodified timestamp )";
    public static final String SYSUSERS_CONGLOMERATE_NAME = "c470.dat";
    public static final String PROPERTIES_SIGNATURE = "( keyname serializable, payload serializable )";
    public static final String PROPERTIES_CONGLOMERATE_NAME = "c10.dat";
    private static final String COMPILATION_DB = "dfv_compilation_db";
    private static final String DUMMY_TABLE_NAME = "dfv_dummy";
    private static final long READ_ALL_PAGES = -1L;
    public static final int CHECKSUM_SIZE = 8;
    public static final int SMALL_SLOT_SIZE = 2;
    public static final int LARGE_SLOT_SIZE = 4;
    public static final byte RECORD_HAS_FIRST_FIELD = 4;
    private DataFile _dataFile;
    private boolean _opened = false;
    private ArrayList<DataValueDescriptor[]> _rows;
    private int _rowIdx;
    private boolean _lastColumnWasNull;
    private Calendar _defaultCalendar = Calendar.getInstance();

    private DataFileVTI(String databaseDirectoryName, String dataFileName, String tableSignature, String encryptionProperties) throws Exception {
        Connection conn = this.getCompilerConnection();
        DataTypeDescriptor[] rowSignature = this.getTypeSignature(conn, tableSignature);
        this._dataFile = new DataFile(new File(databaseDirectoryName), dataFileName, encryptionProperties, rowSignature);
    }

    public DataFileVTI(String databaseDirectoryName, String dataFileName, String tableSignature, String encryptionProperties, String user, String password) throws Exception {
        this(databaseDirectoryName, dataFileName, tableSignature, encryptionProperties);
        this.authenticate(databaseDirectoryName, encryptionProperties, user, password);
    }

    private Connection getCompilerConnection() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:derby:memory:dfv_compilation_db;create=true");
        PreparedStatement ps = conn.prepareStatement("select count(*) from sys.sysaliases where alias = 'SERIALIZABLE'");
        ResultSet rs = ps.executeQuery();
        rs.next();
        boolean alreadyExists = rs.getInt(1) > 0;
        rs.close();
        ps.close();
        if (!alreadyExists) {
            conn.prepareStatement("create type serializable external name 'java.io.Serializable' language java").execute();
        }
        return conn;
    }

    private DataTypeDescriptor[] getTypeSignature(Connection conn, String tableSignature) throws Exception {
        String createTable = "create table dfv_dummy" + tableSignature;
        String dropTable = "drop table dfv_dummy";
        try {
            conn.prepareStatement(createTable).execute();
        }
        catch (SQLException se) {
            throw new Exception("Illegal table signature: " + tableSignature, se);
        }
        String select = "select c.columndatatype, c.columnnumber\nfrom sys.syscolumns c, sys.systables t\nwhere c.referenceid = t.tableid\nand t.tablename = ?\norder by c.columnnumber";
        PreparedStatement ps = conn.prepareStatement(select);
        ps.setString(1, DUMMY_TABLE_NAME.toUpperCase());
        ResultSet rs = ps.executeQuery();
        ArrayList<DataTypeDescriptor> list = new ArrayList<DataTypeDescriptor>();
        while (rs.next()) {
            list.add(DataTypeDescriptor.getType((TypeDescriptor)((TypeDescriptor)rs.getObject(1))));
        }
        rs.close();
        ps.close();
        DataTypeDescriptor[] result = new DataTypeDescriptor[list.size()];
        list.toArray(result);
        conn.prepareStatement(dropTable).execute();
        return result;
    }

    private static void skipBytes(DataInputStream dais, int bytesToSkip) throws IOException {
        int actualBytesSkipped = dais.skipBytes(bytesToSkip);
        if (actualBytesSkipped != bytesToSkip) {
            throw new IOException("Expected to skip " + bytesToSkip + " bytes but only skipped " + actualBytesSkipped + " bytes.");
        }
    }

    private static byte[] decryptPage(CipherProvider decryptionEngine, byte[] cipherText) throws IOException {
        try {
            int pageSize = cipherText.length;
            byte[] clearText = new byte[pageSize];
            int len = decryptionEngine.decrypt(cipherText, 0, pageSize, clearText, 0);
            if (len != pageSize) {
                throw new IOException("Expected to decrypt " + pageSize + " bytes but actually decrypted " + len + " bytes.");
            }
            System.arraycopy(clearText, 8, cipherText, 0, pageSize - 8);
            System.arraycopy(clearText, 0, cipherText, pageSize - 8, 8);
            return cipherText;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void authenticate(String databaseDirectoryName, String encryptionProperties, String user, String password) throws Exception {
        this.vetDBO(databaseDirectoryName, encryptionProperties, user);
        if (this.vetNative(databaseDirectoryName, encryptionProperties, user, password)) {
            return;
        }
        this.vetRawAuthentication(databaseDirectoryName, encryptionProperties, user, password);
    }

    private void vetDBO(String databaseDirectoryName, String encryptionProperties, String user) throws Exception {
        boolean isDBO = false;
        boolean foundSYSIBM = false;
        if (user != null) {
            String authorizationID = StringUtil.normalizeSQLIdentifier((String)user);
            DataFileVTI sysschemas = new DataFileVTI(databaseDirectoryName, SYSSCHEMAS_CONGLOMERATE_NAME, SYSSCHEMAS_SIGNATURE, encryptionProperties);
            while (sysschemas.next()) {
                if (!"SYSIBM".equals(sysschemas.getString(2))) continue;
                foundSYSIBM = true;
                if (!sysschemas.getString(3).equals(authorizationID)) break;
                isDBO = true;
                break;
            }
            sysschemas.close();
        }
        if (!foundSYSIBM) {
            throw new Exception("Could not read database at " + databaseDirectoryName + ". Maybe it is encrypted and the wrong encryption key was supplied.");
        }
        if (!isDBO) {
            throw new Exception(user + " is not the owner of the database at " + databaseDirectoryName);
        }
    }

    private boolean vetNative(String databaseDirectoryName, String encryptionProperties, String user, String password) throws Exception {
        String authorizationID = StringUtil.normalizeSQLIdentifier((String)user);
        DataFileVTI systables = new DataFileVTI(databaseDirectoryName, SYSTABLES_CONGLOMERATE_NAME, SYSTABLES_SIGNATURE, encryptionProperties);
        boolean sysusersExists = false;
        while (systables.next()) {
            if (!SYS_SCHEMA_ID.equals(systables.getString(4)) || !"SYSUSERS".equals(systables.getString(2))) continue;
            sysusersExists = true;
            break;
        }
        systables.close();
        if (!sysusersExists) {
            return false;
        }
        DataFileVTI sysusers = new DataFileVTI(databaseDirectoryName, SYSUSERS_CONGLOMERATE_NAME, SYSUSERS_SIGNATURE, encryptionProperties);
        boolean credentialsShouldBePresent = false;
        boolean credentialsMatch = false;
        while (sysusers.next()) {
            credentialsShouldBePresent = true;
            if (!sysusers.getString(1).equals(authorizationID)) continue;
            String hashingScheme = sysusers.getString(2);
            String actualPassword = sysusers.getString(3);
            PasswordHasher hasher = new PasswordHasher(hashingScheme);
            String candidatePassword = hasher.hashPasswordIntoString(authorizationID, password);
            credentialsMatch = actualPassword.equals(candidatePassword);
            break;
        }
        sysusers.close();
        if (!credentialsShouldBePresent) {
            return false;
        }
        if (credentialsMatch) {
            return true;
        }
        throw new Exception("Bad NATIVE credentials.");
    }

    private void vetRawAuthentication(String databaseDirectoryName, String encryptionProperties, String user, String password) throws Exception {
        Properties props = this.readDatabaseProperties(databaseDirectoryName, encryptionProperties);
        String requireAuthentication = props.getProperty("derby.connection.requireAuthentication");
        if (!Boolean.valueOf(requireAuthentication).booleanValue()) {
            return;
        }
        String provider = props.getProperty("derby.authentication.provider");
        if (provider == null) {
            return;
        }
        boolean authenticated = StringUtil.SQLEqualsIgnoreCase((String)provider, (String)"LDAP") ? this.vetLDAP(props, databaseDirectoryName, user, password) : (StringUtil.SQLEqualsIgnoreCase((String)provider, (String)"BUILTIN") ? this.vetBuiltin(props, user, password) : this.vetCustom(provider, databaseDirectoryName, user, password));
        if (!authenticated) {
            throw new Exception("Authentication failed using provider " + provider);
        }
    }

    private boolean vetLDAP(Properties dbProps, String databaseDirectoryName, String user, String password) throws Exception {
        LDAPService authenticator = new LDAPService(dbProps);
        authenticator.boot(false, dbProps);
        Properties userInfo = new Properties();
        userInfo.setProperty("user", user);
        userInfo.setProperty("password", password);
        return authenticator.authenticate(databaseDirectoryName, userInfo);
    }

    private boolean vetBuiltin(Properties props, String user, String password) throws Exception {
        String passwordProperty = "derby.user.".concat(user);
        String realPassword = props.getProperty(passwordProperty);
        if (realPassword != null) {
            PasswordHasher hasher = new PasswordHasher(realPassword);
            password = hasher.hashAndEncode(user, password);
        } else {
            realPassword = DataFileVTI.getSystemProperty(passwordProperty);
        }
        return realPassword != null && realPassword.equals(password);
    }

    private boolean vetCustom(String customProvider, String databaseDirectoryName, String user, String password) throws Exception {
        Class<?> clazz = Class.forName(customProvider);
        UserAuthenticator authenticator = (UserAuthenticator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        return authenticator.authenticateUser(user, password, databaseDirectoryName, new Properties());
    }

    private static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    private Properties readDatabaseProperties(String databaseDirectoryName, String encryptionProperties) throws Exception {
        Properties retval = new Properties();
        DataFileVTI pc = new DataFileVTI(databaseDirectoryName, PROPERTIES_CONGLOMERATE_NAME, PROPERTIES_SIGNATURE, encryptionProperties);
        while (pc.next()) {
            int col = 1;
            Object key = pc.getObject(col++);
            Object value = pc.getObject(col++);
            retval.put(key, value);
        }
        pc.close();
        return retval;
    }

    public static DataFileVTI dataFileVTI(String databaseDirectoryName, String dataFileName, String tableSignature, String encryptionProperties, String user, String password) throws Exception {
        return new DataFileVTI(databaseDirectoryName, dataFileName, tableSignature, encryptionProperties, user, password);
    }

    private SQLException wrap(Throwable t) {
        return new SQLException(t.getMessage(), t);
    }

    private SQLException wrap(String errorMessage) {
        String sqlState = "XJ001.U".substring(0, 5);
        return new SQLException(errorMessage, sqlState);
    }

    public boolean next() throws SQLException {
        if (this._dataFile == null) {
            return false;
        }
        try {
            if (!this._opened) {
                this._dataFile.openFile();
                this._opened = true;
                this.readNextPage();
            }
            while (this._rows != null) {
                ++this._rowIdx;
                if (this._rowIdx < this._rows.size()) {
                    return true;
                }
                this.readNextPage();
            }
            this.close();
            return false;
        }
        catch (Throwable t) {
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw this.wrap(t);
        }
    }

    private void readNextPage() throws Exception {
        this._rows = this._dataFile.readNextPage();
        this._rowIdx = -1;
    }

    public SQLWarning getWarnings() {
        SQLWarning firstWarning = null;
        ArrayList<SQLWarning> warnings = this._dataFile.getWarnings();
        if (warnings != null && warnings.size() > 0) {
            firstWarning = warnings.get(0);
            SQLWarning previous = null;
            for (SQLWarning warning : warnings) {
                if (previous != null) {
                    previous.setNextWarning(warning);
                }
                previous = warning;
            }
        }
        return firstWarning;
    }

    public void close() throws SQLException {
        try {
            if (this._dataFile != null) {
                this._dataFile.closeFile();
            }
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
        finally {
            this._dataFile = null;
            this._rows = null;
        }
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }

    private DataValueDescriptor getRawColumn(int idx) {
        DataValueDescriptor dvd = this._rows.get(this._rowIdx)[idx - 1];
        this._lastColumnWasNull = dvd.isNull();
        return dvd;
    }

    public boolean wasNull() {
        return this._lastColumnWasNull;
    }

    public String getString(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getString();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getBoolean();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public byte getByte(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getByte();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public short getShort(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getShort();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public int getInt(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getInt();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public long getLong(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getLong();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getFloat();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getDouble();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getBytes();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Date getDate(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getDate(this._defaultCalendar);
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getTime(this._defaultCalendar);
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getTimestamp(this._defaultCalendar);
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getObject();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            return (BigDecimal)this.getRawColumn(columnIndex).getObject();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getDate(cal);
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getTime(cal);
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getRawColumn(columnIndex).getTimestamp(cal);
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            return (Blob)this.getRawColumn(columnIndex).getObject();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public Clob getClob(int columnIndex) throws SQLException {
        try {
            return (Clob)this.getRawColumn(columnIndex).getObject();
        }
        catch (Throwable t) {
            throw this.wrap(t);
        }
    }

    public static final class WrapperInputStream
    extends InputStream {
        private InputStream _wrapped;
        private long _bytesRead;

        public WrapperInputStream(InputStream is) {
            this._wrapped = is;
            this._bytesRead = 0L;
        }

        @Override
        public int read() throws IOException {
            int retval = this._wrapped.read();
            if (retval >= 0) {
                ++this._bytesRead;
            }
            return retval;
        }

        public long getBytesRead() {
            return this._bytesRead;
        }
    }

    public static class OverflowStream
    extends InputStream {
        RandomAccessFile _raf;
        private CipherProvider _decryptionEngine;
        private SlotReader _slotReader;
        private byte[] _currentPageData;
        private long _overflowPage;
        private int _overflowID;
        private ArrayInputStream _pageStream;
        private MemByteHolder _bytes;

        public OverflowStream(RandomAccessFile raf, CipherProvider decryptionEngine, SlotReader slotReader) {
            this._raf = raf;
            this._decryptionEngine = decryptionEngine;
            this._slotReader = slotReader;
            this._pageStream = new ArrayInputStream();
            this._bytes = new MemByteHolder(this._slotReader.pageSize());
            this._currentPageData = new byte[this._slotReader.pageSize()];
        }

        public OverflowStream init(long overflowPage, int overflowID) throws IOException {
            this._overflowPage = overflowPage;
            this._overflowID = overflowID;
            this._bytes.clear();
            this.readExtents();
            return this;
        }

        @Override
        public int read() throws IOException {
            int retval = this._bytes.read();
            if (retval < 0) {
                this._bytes.clear();
            }
            return retval;
        }

        private void readExtents() throws IOException {
            while (this._overflowPage >= 0L) {
                this.readNextExtent();
            }
            this._bytes.startReading();
        }

        private void readNextExtent() throws IOException {
            this._raf.seek(this._overflowPage * (long)this._slotReader.pageSize());
            this._raf.readFully(this._currentPageData);
            if (this._decryptionEngine != null) {
                this._currentPageData = DataFileVTI.decryptPage(this._decryptionEngine, this._currentPageData);
            }
            this._pageStream.setData(this._currentPageData);
            PageHeader ph = PageHeader.readPageHeader(this._currentPageData);
            int recordCount = ph.getSlotsInUse();
            int slot = this.findRecordById(this._overflowID, 0, recordCount);
            StoredRecordHeader recordHeader = this._slotReader.getRecordHeader(slot, this._currentPageData);
            int offset = this._slotReader.getRecordOffset(slot, this._currentPageData);
            int numberFields = recordHeader.getNumberFields();
            this._pageStream.setPosition(offset + recordHeader.size());
            int fieldStatus = StoredFieldHeader.readStatus((ObjectInput)this._pageStream);
            int fieldDataLength = StoredFieldHeader.readFieldDataLength((ObjectInput)this._pageStream, (int)fieldStatus, (int)this._slotReader.slotFieldSize());
            this._bytes.write((InputStream)this._pageStream, (long)fieldDataLength);
            if (numberFields == 1) {
                this._overflowPage = -1L;
                this._overflowID = -1;
            } else {
                int firstFieldStatus = fieldStatus;
                fieldStatus = StoredFieldHeader.readStatus((ObjectInput)this._pageStream);
                fieldDataLength = StoredFieldHeader.readFieldDataLength((ObjectInput)this._pageStream, (int)fieldStatus, (int)this._slotReader.slotFieldSize());
                if (!StoredFieldHeader.isOverflow((int)fieldStatus)) {
                    throw new IOException("Corrupt overflow chain on page " + this._overflowPage);
                }
                this._overflowPage = CompressedNumber.readLong((InputStream)this._pageStream);
                this._overflowID = CompressedNumber.readInt((InputStream)this._pageStream);
            }
        }

        private int findRecordById(int recordId, int slotHint, int maxSlot) {
            if (slotHint == 0) {
                slotHint = recordId - 6;
            }
            if (slotHint > 0 && slotHint < maxSlot && recordId == this._slotReader.getRecordHeader(slotHint, this._currentPageData).getId()) {
                return slotHint;
            }
            for (int slot = 0; slot < maxSlot; ++slot) {
                if (recordId != this._slotReader.getRecordHeader(slot, this._currentPageData).getId()) continue;
                return slot;
            }
            return -1;
        }
    }

    public static class SlotReader {
        private int _pageSize;
        private int _slotTableOffsetToFirstEntry;
        private int _slotTableOffsetToFirstRecordLengthField;
        private int _slotTableOffsetToFirstReservedSpaceField;
        private int _slotFieldSize;
        private int _slotEntrySize;

        public SlotReader(int pageSize) {
            this._pageSize = pageSize;
            this._slotFieldSize = this.calculateSlotFieldSize(this._pageSize);
            this._slotEntrySize = 3 * this._slotFieldSize;
            this._slotTableOffsetToFirstEntry = this._pageSize - 8 - this._slotEntrySize;
            this._slotTableOffsetToFirstRecordLengthField = this._slotTableOffsetToFirstEntry + this._slotFieldSize;
            this._slotTableOffsetToFirstReservedSpaceField = this._slotTableOffsetToFirstEntry + 2 * this._slotFieldSize;
        }

        public int slotFieldSize() {
            return this._slotFieldSize;
        }

        public int pageSize() {
            return this._pageSize;
        }

        public int getRecordOffset(int slot, byte[] pageData) {
            byte[] data = pageData;
            int offset = this._slotTableOffsetToFirstEntry - slot * this._slotEntrySize;
            return this._slotFieldSize == 2 ? (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF : (data[offset++] & 0xFF) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
        }

        private StoredRecordHeader getRecordHeader(int slot, byte[] pageData) {
            return new StoredRecordHeader(pageData, this.getRecordOffset(slot, pageData));
        }

        private int calculateSlotFieldSize(int pageSize) {
            if (pageSize < 65536) {
                return 2;
            }
            return 4;
        }
    }

    public static final class PageHeader {
        private boolean _isOverFlowPage;
        private byte _pageStatus;
        private long _pageVersion;
        private int _slotsInUse;
        private int _nextRecordID;
        private int _pageGeneration;
        private int _previousGeneration;
        private long _beforeImagePageLocation;
        private int _deletedRowCount;

        private PageHeader(DataInputStream dais) throws IOException {
            this._isOverFlowPage = dais.readBoolean();
            this._pageStatus = dais.readByte();
            this._pageVersion = dais.readLong();
            this._slotsInUse = dais.readUnsignedShort();
            this._nextRecordID = dais.readInt();
            this._pageGeneration = dais.readInt();
            this._previousGeneration = dais.readInt();
            this._beforeImagePageLocation = dais.readLong();
            this._deletedRowCount = dais.readUnsignedShort();
            DataFileVTI.skipBytes(dais, 22);
        }

        public boolean isOverFlowPage() {
            return this._isOverFlowPage;
        }

        public byte getPageStatus() {
            return this._pageStatus;
        }

        public long getPageVersion() {
            return this._pageVersion;
        }

        public int getSlotsInUse() {
            return this._slotsInUse;
        }

        public int getNextRecordID() {
            return this._nextRecordID;
        }

        public int getPageGeneration() {
            return this._pageGeneration;
        }

        public int getPreviousGeneration() {
            return this._previousGeneration;
        }

        public long getBeforeImagePageLocation() {
            return this._beforeImagePageLocation;
        }

        public int getDeletedRowCount() {
            return this._deletedRowCount;
        }

        public static PageHeader readPageHeader(byte[] pageData) throws IOException {
            DataInputStream dais = new DataInputStream(new ByteArrayInputStream(pageData));
            int pageFormatableID = PageHeader.readPageFormatableID(dais);
            return PageHeader.readPageHeader(dais);
        }

        public static PageHeader readPageHeader(DataInputStream dais) throws IOException {
            PageHeader ph = new PageHeader(dais);
            return ph;
        }

        public static int readPageFormatableID(DataInputStream dais) throws IOException {
            int formatableID = FormatIdUtil.readFormatIdInteger((DataInput)dais);
            DataFileVTI.skipBytes(dais, 2);
            return formatableID;
        }
    }

    public static final class DataFile {
        private File _dbDirectory;
        private File _file;
        private DataTypeDescriptor[] _rowSignature;
        private CipherProvider _decryptionEngine;
        private FileInputStream _fis;
        private DataInputStream _dais;
        private long _pageCount;
        private byte[] _pageData;
        private int _pageSize;
        private SlotReader _slotReader;
        private OverflowStream _overflowStream;
        private ArrayList<SQLWarning> _warnings;

        public DataFile(File dbDirectory, String fileName, String encryptionProperties, DataTypeDescriptor[] rowSignature) throws Exception {
            this._dbDirectory = dbDirectory;
            this._file = new File(new File(this._dbDirectory, "seg0"), fileName);
            this._rowSignature = rowSignature;
            this._decryptionEngine = this.makeDecryptionEngine(encryptionProperties);
        }

        private CipherProvider makeDecryptionEngine(String encryptionProperties) throws Exception {
            if (encryptionProperties == null) {
                return null;
            }
            File serviceProperties = new File(this._dbDirectory, "service.properties");
            Properties properties = this.unpackEncryptionProperties(encryptionProperties);
            try (FileInputStream in = new FileInputStream(serviceProperties);){
                properties.load(in);
            }
            CipherFactory cipherFactory = new JCECipherFactoryBuilder().createCipherFactory(false, properties, false);
            return cipherFactory.createNewCipher(2);
        }

        private Properties unpackEncryptionProperties(String encryptionProperties) {
            String[] items;
            Properties retval = new Properties();
            for (String item : items = encryptionProperties.split(";")) {
                int equalsSignIdx = item.indexOf("=");
                if (equalsSignIdx <= 0) continue;
                String key = item.substring(0, equalsSignIdx);
                String value = item.substring(equalsSignIdx + 1, item.length());
                retval.setProperty(key, value);
            }
            return retval;
        }

        public void openFile() throws Exception {
            this._pageCount = 0L;
            this._fis = new FileInputStream(this._file);
            WrapperInputStream wis = new WrapperInputStream(this._fis);
            this._dais = new DataInputStream(wis);
            this.readFileHeader();
            this.skipToPageEnd(wis);
        }

        public void closeFile() throws Exception {
            this._dais.close();
            this._fis.close();
        }

        public ArrayList<SQLWarning> getWarnings() {
            try {
                ArrayList<SQLWarning> arrayList = this._warnings;
                return arrayList;
            }
            finally {
                this._warnings = null;
            }
        }

        private void addWarning(String message, Throwable t) {
            if (this._warnings == null) {
                this._warnings = new ArrayList();
            }
            this._warnings.add(new SQLWarning(message, t));
        }

        private void readFileHeader() throws Exception {
            this.readAllocPage(this._dais, PageHeader.readPageFormatableID(this._dais));
            ++this._pageCount;
        }

        private void skipToPageEnd(WrapperInputStream wis) throws Exception {
            int remainingBytesOnPage = this.getRemainingBytesOnPage(wis);
            DataInputStream dais = new DataInputStream(wis);
            if (remainingBytesOnPage != 0) {
                DataFileVTI.skipBytes(dais, remainingBytesOnPage);
            }
        }

        private int getRemainingBytesOnPage(WrapperInputStream wis) {
            long offsetIntoCurrentPage = this.currentOffsetIntoPage(wis);
            int remainingBytes = offsetIntoCurrentPage == 0L ? 0 : (int)((long)this._pageSize - offsetIntoCurrentPage);
            return remainingBytes;
        }

        private int currentOffsetIntoPage(WrapperInputStream wis) {
            return (int)(wis.getBytesRead() % (long)this._pageSize);
        }

        public ArrayList<DataValueDescriptor[]> readNextPage() {
            this._pageData = new byte[this._pageSize];
            try {
                this._dais.readFully(this._pageData);
            }
            catch (Throwable t) {
                if (!(t instanceof EOFException)) {
                    this.addWarning(this.formatThrowable(t, true), t);
                }
                return null;
            }
            try {
                return this.readNonHeaderPage();
            }
            catch (Throwable t) {
                this.addWarning(this.formatThrowable(t, false), t);
                return this.makeEmptyRowList();
            }
        }

        private ArrayList<DataValueDescriptor[]> readNonHeaderPage() throws Exception {
            ArrayList<DataValueDescriptor[]> result;
            if (this._decryptionEngine != null) {
                this._pageData = DataFileVTI.decryptPage(this._decryptionEngine, this._pageData);
            }
            WrapperInputStream wis = new WrapperInputStream(new ByteArrayInputStream(this._pageData));
            DataInputStream dais = new DataInputStream(wis);
            int pageFormatableID = PageHeader.readPageFormatableID(dais);
            switch (pageFormatableID) {
                case 118: {
                    result = this.readAllocPage(dais, pageFormatableID);
                    break;
                }
                case 117: {
                    result = this.formatRows();
                    break;
                }
                default: {
                    throw new IOException("Unknown page formatable ID: " + pageFormatableID);
                }
            }
            ++this._pageCount;
            return result;
        }

        private ArrayList<DataValueDescriptor[]> readAllocPage(DataInputStream dais, int formatableID) throws Exception {
            if (formatableID != 118) {
                throw new IOException("File header should start with formatable id 118 but instead starts with formatable id " + formatableID);
            }
            PageHeader.readPageHeader(dais);
            long nextAllocPageNumber = dais.readLong();
            long nextAllocPageOffset = dais.readLong();
            DataFileVTI.skipBytes(dais, 32);
            byte containerInfoLength = dais.readByte();
            if (containerInfoLength > 0) {
                this.readContainerInfo(dais, containerInfoLength);
            }
            return new ArrayList<DataValueDescriptor[]>();
        }

        private void readContainerInfo(DataInputStream dais, byte containerInfoLength) throws Exception {
            int formatableID = dais.readInt();
            if (formatableID != 116) {
                throw new IOException("Container info should start with formatable id 116 but instead starts with formatable id " + formatableID);
            }
            int containerStatus = dais.readInt();
            this._pageSize = dais.readInt();
            this._slotReader = new SlotReader(this._pageSize);
        }

        private ArrayList<DataValueDescriptor[]> formatRows() throws Exception {
            PageHeader ph = PageHeader.readPageHeader(this._pageData);
            ArrayInputStream ais = new ArrayInputStream(this._pageData);
            int recordCount = ph.getSlotsInUse();
            ArrayList<DataValueDescriptor[]> rows = this.makeEmptyRowList();
            if (ph.isOverFlowPage()) {
                return rows;
            }
            for (int slot = 0; slot < recordCount; ++slot) {
                byte recordStatusByte = this._pageData[this._slotReader.getRecordOffset(slot, this._pageData)];
                StoredRecordHeader recordHeader = this._slotReader.getRecordHeader(slot, this._pageData);
                int offset = this._slotReader.getRecordOffset(slot, this._pageData);
                if (recordHeader.isDeleted()) continue;
                int fieldCount = recordHeader.getNumberFields();
                ais.setPosition(offset += recordHeader.size());
                if (fieldCount <= 0) continue;
                DataValueDescriptor[] row = this.makeEmptyRow();
                boolean rowIsValid = true;
                for (int fieldIdx = 0; fieldIdx < fieldCount; ++fieldIdx) {
                    int fieldStatus = StoredFieldHeader.readStatus((ObjectInput)ais);
                    int fieldDataLength = StoredFieldHeader.readFieldDataLength((ObjectInput)ais, (int)fieldStatus, (int)this._slotReader.slotFieldSize());
                    int fieldDataOffset = ais.getPosition();
                    if (fieldDataLength < 0) continue;
                    if (StoredFieldHeader.isOverflow((int)fieldStatus)) {
                        int overflowId;
                        long overflowPage;
                        if (fieldIdx == 0 && fieldDataLength != 3) {
                            offset = ais.getPosition() + fieldDataLength;
                            overflowPage = CompressedNumber.readLong((DataInput)ais);
                            overflowId = CompressedNumber.readInt((DataInput)ais);
                            this.printIrregularity("questionable long column");
                            ais.setPosition(offset);
                            continue;
                        }
                        overflowPage = CompressedNumber.readLong((DataInput)ais);
                        overflowId = CompressedNumber.readInt((DataInput)ais);
                        this.readOverflowField(slot, fieldIdx, fieldDataOffset, fieldDataLength, row[fieldIdx], overflowPage, overflowId);
                        continue;
                    }
                    if (fieldDataLength > 0) {
                        if (this.recordHasFirstField(recordStatusByte) && (fieldCount == 1 || fieldCount != this._rowSignature.length)) {
                            rowIsValid = false;
                        } else {
                            try {
                                this.readField(slot, fieldIdx, fieldDataOffset, fieldDataLength, row[fieldIdx]);
                            }
                            catch (Throwable t) {
                                rowIsValid = false;
                            }
                        }
                    }
                    offset = ais.getPosition() + fieldDataLength;
                    ais.setPosition(offset);
                }
                if (!rowIsValid) continue;
                rows.add(row);
            }
            return rows;
        }

        private DataValueDescriptor[] makeEmptyRow() throws Exception {
            int columnCount = this._rowSignature.length;
            DataValueDescriptor[] row = new DataValueDescriptor[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = this._rowSignature[i].getNull();
            }
            return row;
        }

        private ArrayList<DataValueDescriptor[]> makeEmptyRowList() {
            return new ArrayList<DataValueDescriptor[]>();
        }

        private boolean recordHasFirstField(byte recordStatus) {
            return (recordStatus & 4) != 0;
        }

        private void readField(int recordNumber, int fieldNumber, int offset, int length, DataValueDescriptor dvd) throws Exception {
            try {
                byte[] bytes = new byte[length];
                System.arraycopy(this._pageData, offset, bytes, 0, length);
                ArrayInputStream ais = new ArrayInputStream(bytes);
                dvd.readExternalFromArray(ais);
            }
            catch (Exception e) {
                this.formatFieldWarning(recordNumber, fieldNumber, offset, length, dvd, e);
            }
        }

        private void readOverflowField(int recordNumber, int fieldNumber, int offset, int length, DataValueDescriptor dvd, long overflowPage, int overflowID) throws Exception {
            try {
                OverflowStream os = this.getOverflowStream().init(overflowPage, overflowID);
                FormatIdInputStream fiis = new FormatIdInputStream((InputStream)os);
                if (dvd instanceof StreamStorable) {
                    ((StreamStorable)dvd).setStream((InputStream)fiis);
                } else {
                    dvd.readExternal((ObjectInput)fiis);
                }
            }
            catch (Exception e) {
                this.formatFieldWarning(recordNumber, fieldNumber, offset, length, dvd, e);
            }
        }

        private OverflowStream getOverflowStream() throws IOException {
            if (this._overflowStream == null) {
                this._overflowStream = new OverflowStream(new RandomAccessFile(this._file, "r"), this._decryptionEngine, this._slotReader);
            }
            return this._overflowStream;
        }

        private void formatFieldWarning(int recordNumber, int fieldNumber, int offset, int length, DataValueDescriptor dvd, Throwable e) {
            String errorMessage = "Error reading field data. Offset = " + offset + ", length = " + length + ", datatype = " + this._rowSignature[fieldNumber].getSQLstring() + ": " + this.getFieldCoordinates(recordNumber, fieldNumber) + ": " + this.formatThrowable(e, false);
            this.addWarning(errorMessage, e);
        }

        private String getFieldCoordinates(int recordNumber, int fieldNumber) {
            return "Field " + fieldNumber + " in record " + recordNumber + this.getPageCoordinates();
        }

        private String getPageCoordinates() {
            return " on page " + this._pageCount + " in file " + this._file.getName();
        }

        private String formatThrowable(Throwable e, boolean includeStackTrace) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(e.getClass().getName() + ": " + e.getMessage());
            if (includeStackTrace) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                buffer.append(sw.toString());
            }
            return buffer.toString();
        }

        private void println(String text) {
            System.out.println(text);
        }

        private void printIrregularity(String text) {
        }
    }

    public static final class LDAPService
    extends JNDIAuthenticationService {
        private Properties _dbProperties;

        public LDAPService(Properties dbProperties) {
            this._dbProperties = dbProperties;
        }

        public String getProperty(String key) {
            return this._dbProperties.getProperty(key);
        }
    }
}

