/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.api;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.derby.vti.VTITemplate;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SimpleJsonVTI
extends VTITemplate {
    private JSONArray _topArray = null;
    private int _nextIdx = 0;
    private JSONObject _currentRow = null;
    private boolean _wasNull = true;
    private Connection _connection;
    private VTITemplate.ColumnDescriptor[] _returnColumns;
    private SQLWarning _warning = null;

    private SimpleJsonVTI(JSONArray array) throws SQLException {
        this._topArray = array;
        this._connection = DriverManager.getConnection("jdbc:default:connection");
    }

    public static SimpleJsonVTI readArray(JSONArray array) throws SQLException {
        return new SimpleJsonVTI(array);
    }

    public void close() throws SQLException {
        this._connection = null;
        this._returnColumns = null;
        this._topArray = null;
        this._currentRow = null;
    }

    public boolean next() throws SQLException {
        Object obj;
        if (this._topArray == null) {
            return false;
        }
        if (this._nextIdx >= this._topArray.size()) {
            return false;
        }
        if (this._returnColumns == null) {
            this._returnColumns = this.getReturnTableSignature(this._connection);
        }
        if ((obj = this._topArray.get(this._nextIdx)) == null || !(obj instanceof JSONObject)) {
            this._currentRow = null;
            String cellType = obj == null ? "NULL" : obj.getClass().getName();
            this.addWarning("Row " + this._nextIdx + " is not a JSON object. It is a " + cellType);
        } else {
            this._currentRow = (JSONObject)obj;
        }
        ++this._nextIdx;
        return true;
    }

    public boolean wasNull() {
        return this._wasNull;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
        throw this.notImplemented("clearWarnings");
    }

    public String getString(int columnIndex) throws SQLException {
        Object obj = this.getColumn(columnIndex);
        if (this._wasNull) {
            return null;
        }
        return obj.toString();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getColumn(columnIndex);
        if (this.nullOrWrongType(Boolean.class, columnIndex, obj)) {
            return false;
        }
        return (Boolean)obj;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Number number = this.getNumber(columnIndex);
        if (this._wasNull) {
            return 0;
        }
        return number.byteValue();
    }

    public short getShort(int columnIndex) throws SQLException {
        Number number = this.getNumber(columnIndex);
        if (this._wasNull) {
            return 0;
        }
        return number.shortValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        Number number = this.getNumber(columnIndex);
        if (this._wasNull) {
            return 0;
        }
        return number.intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        Number number = this.getNumber(columnIndex);
        if (this._wasNull) {
            return 0L;
        }
        return number.longValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        Number number = this.getNumber(columnIndex);
        if (this._wasNull) {
            return 0.0f;
        }
        return number.floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        Number number = this.getNumber(columnIndex);
        if (this._wasNull) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String stringValue = this.getString(columnIndex);
        if (this._wasNull) {
            return null;
        }
        try {
            return new BigDecimal(stringValue);
        }
        catch (Throwable t) {
            throw ToolUtilities.wrap(t);
        }
    }

    private Number getNumber(int idx) throws SQLException {
        Object obj = this.getColumn(idx);
        if (this.nullOrWrongType(Number.class, idx, obj)) {
            return null;
        }
        return (Number)obj;
    }

    private Object getColumn(int idx) throws SQLException {
        if (idx < 1 || idx > this._returnColumns.length) {
            throw new SQLException("Column index " + idx + " is out of bounds.");
        }
        if (this._currentRow == null) {
            this._wasNull = true;
            return null;
        }
        Object value = this._currentRow.get((Object)this._returnColumns[idx - 1].columnName);
        this._wasNull = value == null;
        return value;
    }

    private boolean nullOrWrongType(Class correctType, int columnIdx, Object obj) {
        if (this._wasNull) {
            return true;
        }
        if (!correctType.isInstance(obj)) {
            String desiredType = correctType.getName();
            String valueType = obj.getClass().getName();
            this.addWarning("Column " + columnIdx + " in row " + this._nextIdx + " is not a " + desiredType + ". It is a " + valueType + ".");
            this._wasNull = true;
            return true;
        }
        return false;
    }

    private void addWarning(String warningText) {
        SQLWarning warning = new SQLWarning(warningText);
        if (this._warning == null) {
            this._warning = warning;
        } else {
            this._warning.setNextWarning(warning);
        }
    }
}

