/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.util.Version;

public abstract class LuceneUtils {
    public static final String TEXT_FIELD_NAME = "luceneTextField";
    private static HashMap<String, Class<? extends Analyzer>> _analyzerClasses = new HashMap();

    public static Version currentVersion() {
        Version retval = null;
        for (Version current : Version.values()) {
            if (current == Version.LUCENE_CURRENT) continue;
            if (retval == null) {
                retval = current;
                continue;
            }
            if (!current.onOrAfter(retval)) continue;
            retval = current;
        }
        return retval;
    }

    public static Analyzer defaultAnalyzer() throws SQLException {
        return LuceneUtils.getAnalyzerForLocale(ConnectionUtil.getCurrentLCC().getDatabase().getLocale());
    }

    public static Analyzer getAnalyzerForLocale(Locale locale) throws SQLException {
        String language = locale.getLanguage();
        try {
            Class<? extends Analyzer> analyzerClass = _analyzerClasses.get(language);
            if (analyzerClass == null) {
                return LuceneUtils.standardAnalyzer();
            }
            Constructor<? extends Analyzer> constructor = analyzerClass.getConstructor(Version.class);
            return constructor.newInstance(LuceneUtils.currentVersion());
        }
        catch (IllegalAccessException iae) {
            throw ToolUtilities.wrap(iae);
        }
        catch (InstantiationException ie) {
            throw ToolUtilities.wrap(ie);
        }
        catch (InvocationTargetException ite) {
            throw ToolUtilities.wrap(ite);
        }
        catch (NoSuchMethodException nsme) {
            throw ToolUtilities.wrap(nsme);
        }
    }

    public static Analyzer standardAnalyzer() {
        return new StandardAnalyzer(LuceneUtils.currentVersion());
    }

    public static QueryParser defaultQueryParser(Version version, String[] fieldNames, Analyzer analyzer) {
        return new MultiFieldQueryParser(version, fieldNames, analyzer);
    }

    public static LuceneIndexDescriptor defaultIndexDescriptor() {
        return new DefaultIndexDescriptor();
    }

    private static void storeAnalyzerClass(Class<? extends Analyzer> analyzerClass) {
        _analyzerClasses.put(LuceneUtils.getLanguageCode(analyzerClass), analyzerClass);
    }

    private static String getLanguageCode(Class<? extends Analyzer> analyzerClass) {
        String className = analyzerClass.getName();
        String packageName = className.substring(0, className.lastIndexOf("."));
        String languageCode = packageName.substring(packageName.lastIndexOf(".") + 1, packageName.length());
        return languageCode;
    }

    static {
        LuceneUtils.storeAnalyzerClass(ArabicAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(ArmenianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(BasqueAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(BrazilianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(BulgarianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(CatalanAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(CzechAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(DanishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(DutchAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(EnglishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(FinnishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(FrenchAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(GalicianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(GermanAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(GreekAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(HindiAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(HungarianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(IndonesianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(IrishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(ItalianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(LatvianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(NorwegianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(PersianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(PortugueseAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(RomanianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(RussianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(SpanishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(SwedishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(ThaiAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(TurkishAnalyzer.class);
    }

    public static class DefaultIndexDescriptor
    implements LuceneIndexDescriptor {
        @Override
        public String[] getFieldNames() {
            return new String[]{LuceneUtils.TEXT_FIELD_NAME};
        }

        @Override
        public Analyzer getAnalyzer() throws SQLException {
            return LuceneUtils.defaultAnalyzer();
        }

        @Override
        public QueryParser getQueryParser() throws SQLException {
            return LuceneUtils.defaultQueryParser(LuceneUtils.currentVersion(), this.getFieldNames(), this.getAnalyzer());
        }
    }
}

